/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.fermentationvat;

import com.klikli_dev.theurgy.content.apparatus.fermentationvat.FermentationCraftingBehaviour;
import com.klikli_dev.theurgy.content.apparatus.fermentationvat.FermentationVatBlock;
import com.klikli_dev.theurgy.content.behaviour.storage.OutputStorageBehaviour;
import com.klikli_dev.theurgy.content.behaviour.storage.StorageBehaviour;
import com.klikli_dev.theurgy.content.storage.MonitoredFluidTank;
import com.klikli_dev.theurgy.content.storage.MonitoredItemStackHandler;
import com.klikli_dev.theurgy.content.storage.PreventInsertExtractFluidWrapper;
import com.klikli_dev.theurgy.content.storage.PreventInsertExtractWrapper;
import com.klikli_dev.theurgy.content.storage.PreventInsertWrapper;
import com.klikli_dev.theurgy.content.storage.SelectFluidHandlerWrapper;
import com.klikli_dev.theurgy.content.storage.SelectItemHandlerWrapper;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class FermentationStorageBehaviour
extends StorageBehaviour<FermentationStorageBehaviour>
implements OutputStorageBehaviour {
    public ItemStackHandler inputInventory;
    public IItemHandlerModifiable inputInventoryReadOnlyWrapper;
    public SelectItemHandlerWrapper inputInventoryOpenCloseAwareWrapper;
    public ItemStackHandler outputInventory;
    public IItemHandlerModifiable outputInventoryExtractOnlyWrapper;
    public IItemHandlerModifiable outputInventoryReadOnlyWrapper;
    public SelectItemHandlerWrapper outputInventoryOpenCloseAwareWrapper;
    public CombinedInvWrapper inventory;
    public IItemHandlerModifiable inventoryReadOnlyWrapper;
    public SelectItemHandlerWrapper inventoryOpenCloseAwareWrapper;
    public FluidTank fluidTank;
    public IFluidHandler fluidTankReadOnlyWrapper;
    public SelectFluidHandlerWrapper fluidTankCloseAwareWrapper;
    public Supplier<FermentationCraftingBehaviour> craftingBehaviour;

    public FermentationStorageBehaviour(BlockEntity blockEntity, Supplier<FermentationCraftingBehaviour> craftingBehaviour) {
        super(blockEntity);
        this.craftingBehaviour = craftingBehaviour;
        this.inputInventory = new InputInventory();
        this.inputInventoryReadOnlyWrapper = new PreventInsertExtractWrapper((IItemHandlerModifiable)this.inputInventory);
        this.inputInventoryOpenCloseAwareWrapper = new SelectItemHandlerWrapper(this.selectHandler(), new IItemHandlerModifiable[]{this.inputInventory, this.inputInventoryReadOnlyWrapper});
        this.outputInventory = new OutputInventory();
        this.outputInventoryExtractOnlyWrapper = new PreventInsertWrapper((IItemHandlerModifiable)this.outputInventory);
        this.outputInventoryReadOnlyWrapper = new PreventInsertExtractWrapper((IItemHandlerModifiable)this.outputInventory);
        this.outputInventoryOpenCloseAwareWrapper = new SelectItemHandlerWrapper(this.selectHandler(), this.outputInventoryExtractOnlyWrapper, this.outputInventoryReadOnlyWrapper);
        this.inventory = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.outputInventoryExtractOnlyWrapper});
        this.inventoryReadOnlyWrapper = new PreventInsertExtractWrapper((IItemHandlerModifiable)this.inventory);
        this.inventoryOpenCloseAwareWrapper = new SelectItemHandlerWrapper(this.selectHandler(), new IItemHandlerModifiable[]{this.inventory, this.inventoryReadOnlyWrapper});
        this.fluidTank = new WaterTank(10000, f -> this.craftingBehaviour.get().canProcess((FluidStack)f));
        this.fluidTankReadOnlyWrapper = new PreventInsertExtractFluidWrapper((IFluidHandler)this.fluidTank);
        this.fluidTankCloseAwareWrapper = new SelectFluidHandlerWrapper(this.selectHandler(), new IFluidHandler[]{this.fluidTank, this.fluidTankReadOnlyWrapper});
    }

    private Supplier<Integer> selectHandler() {
        return () -> (Boolean)this.blockEntity.getBlockState().getValue((Property)BlockStateProperties.OPEN) != false ? 0 : 1;
    }

    @Override
    public void readNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        if (pTag.contains("inputInventory")) {
            this.inputInventory.deserializeNBT(pRegistries, pTag.getCompound("inputInventory"));
        }
        if (pTag.contains("outputInventory")) {
            this.outputInventory.deserializeNBT(pRegistries, pTag.getCompound("outputInventory"));
        }
        if (pTag.contains("fluidTank")) {
            this.fluidTank.readFromNBT(pRegistries, pTag.getCompound("fluidTank"));
        }
    }

    @Override
    public void writeNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.put("inputInventory", (Tag)this.inputInventory.serializeNBT(pRegistries));
        pTag.put("outputInventory", (Tag)this.outputInventory.serializeNBT(pRegistries));
        pTag.put("fluidTank", (Tag)this.fluidTank.writeToNBT(pRegistries, new CompoundTag()));
    }

    @Override
    public void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.writeNetwork(pTag, pRegistries);
    }

    @Override
    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.readNetwork(pTag, pRegistries);
    }

    @Override
    public boolean hasOutput() {
        return !this.outputInventory.getStackInSlot(0).isEmpty();
    }

    @Override
    public IItemHandler outputInventory() {
        return this.outputInventory;
    }

    public class InputInventory
    extends MonitoredItemStackHandler {
        public InputInventory() {
            super(3);
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            FermentationStorageBehaviour.this.craftingBehaviour.get().onInputItemChanged(oldStack, newStack);
            FermentationStorageBehaviour.this.sendBlockUpdated();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            for (int i = 0; i < this.getSlots(); ++i) {
                if (i == slot || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.getStackInSlot(i))) continue;
                return false;
            }
            return FermentationStorageBehaviour.this.craftingBehaviour.get().canProcess(stack) && super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            FermentationStorageBehaviour.this.craftingBehaviour.get().onInputChanged();
            FermentationStorageBehaviour.this.setChanged();
        }
    }

    public class OutputInventory
    extends MonitoredItemStackHandler {
        public OutputInventory() {
            super(1);
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            FermentationStorageBehaviour.this.blockEntity.getLevel().setBlock(FermentationStorageBehaviour.this.blockEntity.getBlockPos(), (BlockState)FermentationStorageBehaviour.this.blockEntity.getBlockState().setValue((Property)FermentationVatBlock.HAS_OUTPUT, (Comparable)Boolean.valueOf(!newStack.isEmpty())), 3);
            FermentationStorageBehaviour.this.sendBlockUpdated();
            FermentationStorageBehaviour.this.blockEntity.getLevel().updateNeighborsAt(FermentationStorageBehaviour.this.blockEntity.getBlockPos(), FermentationStorageBehaviour.this.blockEntity.getBlockState().getBlock());
        }

        protected void onContentsChanged(int slot) {
            FermentationStorageBehaviour.this.setChanged();
        }
    }

    public class WaterTank
    extends MonitoredFluidTank {
        public WaterTank(int capacity, Predicate<FluidStack> validator) {
            super(capacity, validator);
        }

        protected void onContentsChanged() {
            FermentationStorageBehaviour.this.craftingBehaviour.get().onInputChanged();
            FermentationStorageBehaviour.this.setChanged();
        }

        @Override
        protected void onContentTypeChanged(FluidStack oldStack, FluidStack newStack) {
            FermentationStorageBehaviour.this.sendBlockUpdated();
        }
    }
}

