/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.mercurialwand.mode;

import com.klikli_dev.theurgy.content.item.mercurialwand.mode.MercurialWandItemMode;
import com.klikli_dev.theurgy.content.item.mode.EnabledSetter;
import com.klikli_dev.theurgy.content.item.mode.ItemModeRenderHandler;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class SwitchLogisticsEnabledMode
extends MercurialWandItemMode {
    private final Lazy<ItemModeRenderHandler<SwitchLogisticsEnabledMode>> renderHandler = Lazy.of(() -> new ItemModeRenderHandler<SwitchLogisticsEnabledMode>(this));

    protected SwitchLogisticsEnabledMode() {
    }

    @Override
    public String descriptionId() {
        return "item.mode.theurgy.mercurial_wand.switch_logistics_enabled";
    }

    @Override
    public void appendHUDText(Player pPlayer, HitResult pHitResult, ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents) {
        BlockHitResult blockHitResult;
        BlockEntity blockEntity;
        MutableComponent description = this.description(pStack, pLevel);
        if (pHitResult instanceof BlockHitResult && (blockEntity = pLevel.getBlockEntity((blockHitResult = (BlockHitResult)pHitResult).getBlockPos())) instanceof EnabledSetter) {
            EnabledSetter enabledSetter = (EnabledSetter)blockEntity;
            boolean enabled = enabledSetter.enabled();
            MutableComponent component = Component.translatable((String)"item.mode.theurgy.mercurial_wand.switch_logistics_enabled.hud", (Object[])new Object[]{Component.translatable((String)(enabled ? "item.mode.theurgy.mercurial_wand.enabled" : "item.mode.theurgy.mercurial_wand.disabled")).withStyle(enabled ? ChatFormatting.GREEN : ChatFormatting.RED)});
            description.append((Component)component);
        }
        pTooltipComponents.add((Component)description);
    }

    @Override
    public ItemModeRenderHandler<?> renderHandler() {
        return (ItemModeRenderHandler)this.renderHandler.get();
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockPos blockPos = context.getClickedPos();
        Level level = context.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof EnabledSetter) {
            EnabledSetter enabledSetter = (EnabledSetter)blockEntity;
            if (!level.isClientSide) {
                enabledSetter.enabled(!enabledSetter.enabled());
                boolean enabled = enabledSetter.enabled();
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"item.mode.theurgy.mercurial_wand.switch_logistics_enabled.success", (Object[])new Object[]{Component.translatable((String)(enabled ? "item.mode.theurgy.mercurial_wand.enabled" : "item.mode.theurgy.mercurial_wand.disabled")).withStyle(enabled ? ChatFormatting.GREEN : ChatFormatting.RED)}), true);
            }
            return InteractionResult.SUCCESS;
        }
        return super.onItemUseFirst(stack, context);
    }
}

