/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.lang;

import com.klikli_dev.modonomicon.api.datagen.AbstractModonomiconLanguageProvider;
import com.klikli_dev.theurgy.content.apparatus.calcinationoven.CalcinationOvenBlock;
import com.klikli_dev.theurgy.content.apparatus.caloricfluxemitter.CaloricFluxEmitterBlock;
import com.klikli_dev.theurgy.content.apparatus.digestionvat.DigestionVatBlock;
import com.klikli_dev.theurgy.content.apparatus.distiller.DistillerBlock;
import com.klikli_dev.theurgy.content.apparatus.fermentationvat.FermentationVatBlock;
import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorBlock;
import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorMercuryVesselBlock;
import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorSaltVesselBlock;
import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorSulfurVesselBlock;
import com.klikli_dev.theurgy.content.apparatus.liquefactioncauldron.LiquefactionCauldronBlock;
import com.klikli_dev.theurgy.content.apparatus.logisticsconnectionnode.LogisticsConnectionNodeBlock;
import com.klikli_dev.theurgy.content.apparatus.logisticsfluidconnector.extractor.LogisticsFluidExtractorBlock;
import com.klikli_dev.theurgy.content.apparatus.logisticsfluidconnector.inserter.LogisticsFluidInserterBlock;
import com.klikli_dev.theurgy.content.apparatus.logisticsitemconnector.extractor.LogisticsItemExtractorBlock;
import com.klikli_dev.theurgy.content.apparatus.logisticsitemconnector.inserter.LogisticsItemInserterBlock;
import com.klikli_dev.theurgy.content.apparatus.mercurycatalyst.MercuryCatalystBlock;
import com.klikli_dev.theurgy.content.apparatus.pyromanticbrazier.PyromanticBrazierBlock;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationResultPedestalBlock;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationSourcePedestalBlock;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationTargetPedestalBlock;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterBlock;
import com.klikli_dev.theurgy.content.apparatus.salammoniacaccumulator.SalAmmoniacAccumulatorBlock;
import com.klikli_dev.theurgy.content.apparatus.salammoniactank.SalAmmoniacTankBlock;
import com.klikli_dev.theurgy.content.behaviour.filter.attribute.EnchantAttribute;
import com.klikli_dev.theurgy.content.behaviour.filter.attribute.FluidContentsAttribute;
import com.klikli_dev.theurgy.content.behaviour.filter.attribute.InTagAttribute;
import com.klikli_dev.theurgy.content.behaviour.filter.attribute.ItemAttribute;
import com.klikli_dev.theurgy.content.behaviour.filter.attribute.ItemNameAttribute;
import com.klikli_dev.theurgy.content.behaviour.filter.attribute.StandardAttributes;
import com.klikli_dev.theurgy.content.item.derivative.AlchemicalDerivativeTier;
import com.klikli_dev.theurgy.content.item.divinationrod.DivinationRodItem;
import com.klikli_dev.theurgy.content.item.niter.AlchemicalNiterItem;
import com.klikli_dev.theurgy.content.item.salt.AlchemicalSaltItem;
import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurType;
import com.klikli_dev.theurgy.datagen.lang.TooltipLanguageProvider;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import com.klikli_dev.theurgy.registry.FluidTagRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.klikli_dev.theurgy.registry.NiterRegistry;
import com.klikli_dev.theurgy.registry.SaltRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import java.text.MessageFormat;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ENUSProvider
extends AbstractModonomiconLanguageProvider
implements TooltipLanguageProvider {
    public ENUSProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "en_us");
    }

    protected String f(String pattern, Object ... arguments) {
        return MessageFormat.format(pattern, arguments);
    }

    protected String green(String text) {
        return String.valueOf(ChatFormatting.GREEN) + text + String.valueOf(ChatFormatting.RESET) + String.valueOf(ChatFormatting.GRAY);
    }

    protected String darkRed(String text) {
        return String.valueOf(ChatFormatting.DARK_RED) + text + String.valueOf(ChatFormatting.RESET) + String.valueOf(ChatFormatting.GRAY);
    }

    private void addKeys() {
        this.add("key.theurgy.category", "Theurgy");
        this.add("key.theurgy.change_item_mode", "Change Item Mode");
    }

    private void addItemTag(ResourceLocation resourceLocation, String string) {
        this.add("tag.item." + resourceLocation.getNamespace() + "." + resourceLocation.getPath().replace("/", "."), string);
    }

    private void addItemTag(TagKey<Item> item, String string) {
        this.addItemTag(item.location(), string);
    }

    private void addFluidTag(ResourceLocation resourceLocation, String string) {
        this.add("tag.fluid." + resourceLocation.getNamespace() + "." + resourceLocation.getPath().replace("/", "."), string);
    }

    private void addFluidTag(TagKey<Fluid> fluid, String string) {
        this.addFluidTag(fluid.location(), string);
    }

    private void addMisc() {
        this.add("tooltip.theurgy.show_extended", String.valueOf(ChatFormatting.GOLD) + "[" + String.valueOf(ChatFormatting.LIGHT_PURPLE) + "shift " + String.valueOf(ChatFormatting.GRAY) + "show more" + String.valueOf(ChatFormatting.GOLD) + "]");
        this.add("tooltip.theurgy.extended_heading", String.valueOf(ChatFormatting.GOLD) + "[" + String.valueOf(ChatFormatting.GRAY) + "more" + String.valueOf(ChatFormatting.GOLD) + "]");
        this.add("tooltip.theurgy.show_usage", String.valueOf(ChatFormatting.GOLD) + "[" + String.valueOf(ChatFormatting.LIGHT_PURPLE) + "ctrl " + String.valueOf(ChatFormatting.GRAY) + "show usage" + String.valueOf(ChatFormatting.GOLD) + "]");
        this.add("tooltip.theurgy.usage_heading", String.valueOf(ChatFormatting.GOLD) + "[" + String.valueOf(ChatFormatting.GRAY) + "usage" + String.valueOf(ChatFormatting.GOLD) + "]");
        this.add("theurgy.misc.unit.millibuckets", "%smB");
    }

    private void addGui() {
        this.add("theurgy.gui.filter.reset_button.tooltip", "Reset Filter Settings");
        this.add("theurgy.gui.filter.confirm_button.tooltip", "Save Filter Settings");
        this.add("theurgy.gui.filter.accept_list_button.tooltip", "Allow-List");
        this.add("theurgy.gui.filter.accept_list_button.tooltip.shift", "Items pass if they match any of the above. An empty Allow-List rejects everything.");
        this.add("theurgy.gui.filter.deny_list_button.tooltip", "Deny-List");
        this.add("theurgy.gui.filter.deny_list_button.tooltip.shift", "Items pass if they DO NOT match any of the above. An empty Deny-List accepts everything.");
        this.add("theurgy.gui.filter.respect_data_components_button.tooltip", "Respect Data");
        this.add("theurgy.gui.filter.respect_data_components_button.tooltip.shift", "Items pass if they match the data components of the filter item (durability, enchantments and others).");
        this.add("theurgy.gui.filter.ignore_data_components_button.tooltip", "Ignore Data");
        this.add("theurgy.gui.filter.ignore_data_components_button.tooltip.shift", "Items pass regardless of their data components (durability, enchantments and others).");
        this.add("theurgy.gui.scroll_input.default_title", "Choose an Option:");
        this.add("theurgy.gui.scroll_input.scroll_to_modify", "Scroll to Modify");
        this.add("theurgy.gui.scroll_input.scroll_to_select", "Scroll to Select");
        this.add("theurgy.gui.scroll_input.shift_scrolls_faster", "Shift to Scroll Faster");
        this.add("theurgy.gui.attribute_filter.accept_list_or_button.tooltip", "Allow-List (Any)");
        this.add("theurgy.gui.attribute_filter.accept_list_or_button.tooltip.shift", "Items pass if they have ANY of the selected attributes.");
        this.add("theurgy.gui.attribute_filter.accept_list_and_button.tooltip", "Allow-List (All)");
        this.add("theurgy.gui.attribute_filter.accept_list_and_button.tooltip.shift", "Items pass if they have ALL of the selected attributes.");
        this.add("theurgy.gui.attribute_filter.deny_list_button.tooltip", "Deny-List");
        this.add("theurgy.gui.attribute_filter.deny_list_button.tooltip.shift", "Items pass if they do NOT have any of the selected attributes.");
        this.add("theurgy.gui.attribute_filter.add_button.tooltip", "Add attribute to list");
        this.add("theurgy.gui.attribute_filter.add_inverted.tooltip", "Add opposite attribute to list");
        this.add("theurgy.gui.attribute_filter.add_reference_item", "Add Reference Item");
        this.add("theurgy.gui.attribute_filter.no_selected_attributes", "No attributes selected");
        this.add("theurgy.gui.attribute_filter.selected_attributes", "Selected attributes:");
    }

    private void addBehaviours() {
        this.add("theurgy.behaviour.selection.mode", "%1$s %2$s");
        this.add("theurgy.behaviour.selection.mode.caloric_flux_emitter", "Send caloric flux to");
        this.add("theurgy.behaviour.selection.outside_range", "%1$s selected blocks removed for being out of range.");
        this.add("theurgy.behaviour.selection.summary.caloric_flux_emitter", "Caloric Flux Emitter targets %1$s.");
        this.add("theurgy.behaviour.selection.summary.caloric_flux_emitter.no_selection", "Caloric Flux Emitter has no target.");
        this.add("theurgy.behaviour.selection.mode.sulfuric_flux_emitter", "Add to reformation array: ");
        this.add("theurgy.behaviour.selection.summary.sulfuric_flux_emitter", "Sulfuric Flux Emitter is linked to %1$s source, %2$s target and %3$s result pedestals.");
        this.add("theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_selection", "Sulfuric Flux Emitter has no linked pedestals.");
        this.add("theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_target", "Sulfuric Flux Emitter has no linked target pedestal.");
        this.add("theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_sources", "Sulfuric Flux Emitter has no linked source pedestals.");
        this.add("theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_result", "Sulfuric Flux Emitter has no linked result pedestal.");
        this.add("theurgy.behaviour.interaction.fermentation_vat.no_recipe", "Cannot close vat, the items in it do not form a valid fermentation recipe.");
        this.add("theurgy.behaviour.interaction.fermentation_vat.closed", "Cannot add or remove items or fluids from the vat while it is closed. Shift+Click to open.");
        this.add("theurgy.behaviour.interaction.digestion_vat.no_recipe", "Cannot close vat, the items in it do not form a valid digestion recipe.");
        this.add("theurgy.behaviour.interaction.digestion_vat.closed", "Cannot add or remove items or fluids from the vat while it is closed. Shift+Click to open.");
    }

    private void addIntegrations() {
        this.add("theurgy.jei.category.calcination", "Calcination");
        this.add("theurgy.jei.category.liquefaction", "Liquefaction");
        this.add("theurgy.jei.category.distillation", "Alchemical Distillation");
        this.add("theurgy.jei.category.incubation", "Incubation");
        this.add("theurgy.jei.category.accumulation", "Accumulation");
        this.add("theurgy.jei.category.reformation", "Reformation");
        this.add("theurgy.jei.category.fermentation", "Alchemical Fermentation");
        this.add("theurgy.jei.category.digestion", "Digestion");
        this.add("theurgy.jei.misc.mercury_flux", "Mercury Flux: %s");
        this.add("theurgy.jei.misc.source_pedestal_count", "%sx");
        this.add("theurgy.jei.misc.source_sulfur.tooltip", "The Target Sulfur will not be consumed!\nYou can retrieve it after crafting is complete.");
        this.add("config.jade.plugin_theurgy.mercury_flux", "Theurgy Mercury Flux");
        this.addItemTag(ItemTagRegistry.GEMS_SAL_AMMONIAC, "Sal Ammoniac Gems");
        this.addItemTag(ItemTagRegistry.ORES_SAL_AMMONIAC, "Sal Ammoniac Ores");
        this.addItemTag(ItemTagRegistry.SUGARS, "Sugars");
        this.addItemTag(ItemTagRegistry.FERMENTATION_STARTERS, "Fermentation Starters");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_MERCURIES, "Alchemical Mercuries");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_NITERS, "Alchemical Niters");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SALTS, "Alchemical Salts");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_AND_NITERS, "Alchemical Sulfurs and Niters");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS, "Alchemical Sulfurs");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_ABUNDANT, "Alchemical Sulfurs: Abundant");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_COMMON, "Alchemical Sulfurs: Common");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_RARE, "Alchemical Sulfurs: Rare");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_PRECIOUS, "Alchemical Sulfurs: Precious");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_EARTHEN_MATTERS, "Alchemical Sulfurs: Earthen Matters");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_EARTHEN_MATTERS_ABUNDANT, "Alchemical Sulfurs: Abundant Earthen Matters");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_EARTHEN_MATTERS_COMMON, "Alchemical Sulfurs: Common Earthen Matters");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_EARTHEN_MATTERS_RARE, "Alchemical Sulfurs: Rare Earthen Matters");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS, "Alchemical Sulfurs: Gems");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_ABUNDANT, "Alchemical Sulfurs: Abundant Gems");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_COMMON, "Alchemical Sulfurs: Common Gems");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_PRECIOUS, "Alchemical Sulfurs: Precious Gems");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_RARE, "Alchemical Sulfurs: Rare Gems");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_METALS, "Alchemical Sulfurs: Metals");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_ABUNDANT, "Alchemical Sulfurs: Abundant Metals");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_COMMON, "Alchemical Sulfurs: Common Metals");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_PRECIOUS, "Alchemical Sulfurs: Precious Metals");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_RARE, "Alchemical Sulfurs: Rare Metals");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS, "Alchemical Sulfurs: Other Minerals");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_ABUNDANT, "Alchemical Sulfurs: Abundant Other Minerals");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_COMMON, "Alchemical Sulfurs: Common Other Minerals");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_RARE, "Alchemical Sulfurs: Rare Other Minerals");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_PRECIOUS, "Alchemical Sulfurs: Precious Other Minerals");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_LOGS, "Alchemical Sulfurs: Logs");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_LOGS_ABUNDANT, "Alchemical Sulfurs: Abundant Logs");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_LOGS_COMMON, "Alchemical Sulfurs: Common Logs");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_LOGS_RARE, "Alchemical Sulfurs: Rare Logs");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_LOGS_PRECIOUS, "Alchemical Sulfurs: Precious Logs");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_CROPS, "Alchemical Sulfurs: Crops");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_CROPS_ABUNDANT, "Alchemical Sulfurs: Abundant Crops");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_CROPS_COMMON, "Alchemical Sulfurs: Common Crops");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_CROPS_RARE, "Alchemical Sulfurs: Rare Crops");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_CROPS_PRECIOUS, "Alchemical Sulfurs: Precious Crops");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_HERBS, "Alchemical Sulfurs: Herbs");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_HERBS_ABUNDANT, "Alchemical Sulfurs: Abundant Herbs");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_HERBS_COMMON, "Alchemical Sulfurs: Common Herbs");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_HERBS_RARE, "Alchemical Sulfurs: Rare Herbs");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_HERBS_PRECIOUS, "Alchemical Sulfurs: Precious Herbs");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_ANIMALS, "Alchemical Sulfurs: Animal Parts");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_ANIMALS_ABUNDANT, "Alchemical Sulfurs: Abundant Animal Parts");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_ANIMALS_COMMON, "Alchemical Sulfurs: Common Animal Parts");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_ANIMALS_RARE, "Alchemical Sulfurs: Rare Animal Parts");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_ANIMALS_PRECIOUS, "Alchemical Sulfurs: Precious Animal Parts");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_MOBS, "Alchemical Sulfurs: Mob Drops");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_MOBS_ABUNDANT, "Alchemical Sulfurs: Abundant Mob Drops");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_MOBS_COMMON, "Alchemical Sulfurs: Common Mob Drops");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_MOBS_COMMON_FOR_AUTOMATIC_RECIPES, "Alchemical Sulfurs: Common Mob Drops");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_MOBS_RARE, "Alchemical Sulfurs: Rare Mob Drops");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_MOBS_RARE_FOR_AUTOMATIC_RECIPES, "Alchemical Sulfurs: Rare Mob Drops");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_MOBS_PRECIOUS, "Alchemical Sulfurs: Precious Mob Drops");
        this.addItemTag(ItemTagRegistry.ALCHEMICAL_SULFURS_MOBS_PRECIOUS_FOR_AUTOMATIC_RECIPES, "Alchemical Sulfurs: Precious Mob Drops");
        this.addItemTag(ItemTagRegistry.HIGH_MERCURY_GEMS, "High Mercury Gems");
        this.addItemTag(ItemTagRegistry.LOW_MERCURY_GEMS, "Low Mercury Gems");
        this.addItemTag(ItemTagRegistry.MEDIUM_MERCURY_GEMS, "Medium Mercury Gems");
        this.addItemTag(ItemTagRegistry.HIGH_MERCURY_METALS, "High Mercury Metals");
        this.addItemTag(ItemTagRegistry.LOW_MERCURY_METALS, "Low Mercury Metals");
        this.addItemTag(ItemTagRegistry.MEDIUM_MERCURY_METALS, "Medium Mercury Metals");
        this.addItemTag(ItemTagRegistry.HIGH_MERCURY_ORES, "High Mercury Ores");
        this.addItemTag(ItemTagRegistry.LOW_MERCURY_ORES, "Low Mercury Ores");
        this.addItemTag(ItemTagRegistry.MEDIUM_MERCURY_ORES, "Medium Mercury Ores");
        this.addItemTag(ItemTagRegistry.OTHER_MINERALS, "Other Minerals");
        this.addItemTag(ItemTagRegistry.LOW_MERCURY_OTHER_MINERALS, "Low Mercury Other Minerals");
        this.addItemTag(ItemTagRegistry.MEDIUM_MERCURY_OTHER_MINERALS, "Medium Mercury Other Minerals");
        this.addItemTag(ItemTagRegistry.HIGH_MERCURY_OTHER_MINERALS, "High Mercury Other Minerals");
        this.addItemTag(ItemTagRegistry.LOW_MERCURY_RAW_MATERIALS, "Low Mercury Raw Materials");
        this.addItemTag(ItemTagRegistry.MEDIUM_MERCURY_RAW_MATERIALS, "Medium Mercury Raw Materials");
        this.addItemTag(ItemTagRegistry.HIGH_MERCURY_RAW_MATERIALS, "Medium Mercury Raw Materials");
        this.addFluidTag(FluidTagRegistry.SAL_AMMONIAC, "Sal Ammoniac");
        this.addFluidTag(FluidTagRegistry.SOLVENT, "Solvent");
        this.add("emi.category.theurgy.calcination", "Calcination");
        this.add("emi.category.theurgy.accumulation", "Accumulation");
        this.add("emi.category.theurgy.digestion", "Digestion");
        this.add("emi.category.theurgy.distillation", "Distillation");
        this.add("emi.category.theurgy.fermentation", "Fermentation");
        this.add("emi.category.theurgy.incubation", "Incubation");
        this.add("emi.category.theurgy.liquefaction", "Liquefaction");
        this.add("emi.category.theurgy.reformation", "Reformation");
        this.add("theurgy.emi.header", "Theurgy");
        this.add("theurgy.emi.info.water_bucket", "In Theurgy, Lava Buckets can be obtained by inserting Crystallized Lava into a Sal Ammoniac Accumulator placed on top of a Sal Ammoniac Tank. The tank fills with Lava slowly, which can then be extracted by clicking it with an Empty Bucket.");
        this.add("theurgy.emi.info.lava_bucket", "In Theurgy, Water Buckets can be obtained by inserting Crystallized Water into a Sal Ammoniac Accumulator placed on top of a Sal Ammoniac Tank. The tank fills with Water slowly, which can then be extracted by clicking it with an Empty Bucket.");
        this.add("theurgy.emi.info.sal_ammoniac_bucket", "In Theurgy, Sal Ammoniac Buckets can be obtained by inserting either just Water or Water and Sal Ammoniac Crystals into a Sal Ammoniac Accumulator placed on top of a Sal Ammoniac Tank. The tank fills with Sal Ammoniac slowly, which can then be extracted by clicking it with an Empty Bucket.");
        this.add("theurgy.gui.category.smelting.time.seconds", "%ss");
    }

    private void addSubtitles() {
        this.add("theurgy.subtitle.tuning_fork", "Using Divination Rod");
    }

    private void addMessages() {
        this.add("message.theurgy.divination_rod.linked", this.f("{0}: The divination rod is now attuned to %s.", this.green("Success")));
        this.add("message.theurgy.divination_rod.tier_too_low", this.f("{0}: You need a higher tier divination rod to attune to %s.", this.darkRed("Warning")));
        this.add("message.theurgy.divination_rod.block_not_allowed", this.f("{0}: The divination rod cannot be attuned to this type of block: %s.", this.darkRed("Warning")));
        this.add("message.theurgy.divination_rod.block_disallowed", this.f("{0}: The divination rod cannot be attuned to this type of block: %s.", this.darkRed("Warning")));
        this.add("message.theurgy.divination_rod.no_link", "The divination rod is not attuned to any material.");
        this.add("message.theurgy.divination_rod.attuning_not_allowed", this.f("{0}: This type of divination rod cannot be manually attuned.", this.darkRed("Warning")));
    }

    private void addFluids() {
        this.add("fluid_type.theurgy.sal_ammoniac", "Sal Ammoniac");
    }

    private void addBlocks() {
        this.addBlock((Supplier)BlockRegistry.CALCINATION_OVEN, "Calcination Oven");
        this.addTooltip(() -> ((CalcinationOvenBlock)((CalcinationOvenBlock)((Object)BlockRegistry.CALCINATION_OVEN.get()))).asItem(), "A device to extract Alchemical Salt from Items.", "Salt represents the \"body\" or \"physical matter\" of an object.", this.f("Place this on top of a heating device such as a Pyromantic Brazier.\n{0} with ingredients to place them in the oven for processing.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.PYROMANTIC_BRAZIER, "Pyromantic Brazier");
        this.addTooltip(() -> ((PyromanticBrazierBlock)((PyromanticBrazierBlock)((Object)BlockRegistry.PYROMANTIC_BRAZIER.get()))).asItem(), "A simple device to heat alchemical apparati.", "Place this below other alchemical apparati to heat them up", this.f("{0} with a fuel item to insert it (or using a hopper)", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.LIQUEFACTION_CAULDRON, "Liquefaction Cauldron");
        this.addTooltip(() -> ((LiquefactionCauldronBlock)((LiquefactionCauldronBlock)((Object)BlockRegistry.LIQUEFACTION_CAULDRON.get()))).asItem(), "A device to extract Alchemical Sulfur from Items using a Solvent.", "Sulfur represents the \"idea\" or \"soul\" of an object and is the key to replication and transmutation.", this.f("Place this on top of a heating device such as a Pyromantic Brazier.\n{0} with ingredients to add them to the cauldron for processing.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.DISTILLER, "Mercury Distiller");
        this.addTooltip(() -> ((DistillerBlock)((DistillerBlock)((Object)BlockRegistry.DISTILLER.get()))).asItem(), "A device to extract Alchemical Mercury from Items.", "Mercury represents the \"energy\" of an object. It has applications both as an energy source and as a catalyst.", this.f("Place this on top of a heating device such as a Pyromantic Brazier.\n{0} with ingredients to add them to the distiller for processing.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.INCUBATOR, "Incubator");
        this.addTooltip(() -> ((IncubatorBlock)((IncubatorBlock)((Object)BlockRegistry.INCUBATOR.get()))).asItem(), "A device to recombine Alchemical Sulfur, Salt and Mercury into items.", null, "Place this on top of a heating device such as a Pyromantic Brazier.\nNeeds Incubator Vessels for all three ingredient types adjacent horizontally to the incubator.\n");
        this.addBlock((Supplier)BlockRegistry.INCUBATOR_MERCURY_VESSEL, "Incubator Mercury Vessel");
        this.addTooltip(() -> ((IncubatorMercuryVesselBlock)((IncubatorMercuryVesselBlock)((Object)BlockRegistry.INCUBATOR_MERCURY_VESSEL.get()))).asItem(), "A vessel to hold Mercury for the Incubator.", null, this.f("Place horizontally next to the incubator.\n{0} with Alchemical Mercury to fill the vessel to allow the Incubator to process it.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.INCUBATOR_SALT_VESSEL, "Incubator Salt Vessel");
        this.addTooltip(() -> ((IncubatorSaltVesselBlock)((IncubatorSaltVesselBlock)((Object)BlockRegistry.INCUBATOR_SALT_VESSEL.get()))).asItem(), "A vessel to hold Salt for the Incubator.", null, this.f("Place horizontally next to the incubator.\n{0} with Alchemical Salt to fill the vessel to allow the Incubator to process it.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.INCUBATOR_SULFUR_VESSEL, "Incubator Sulfur Vessel");
        this.addTooltip(() -> ((IncubatorSulfurVesselBlock)((IncubatorSulfurVesselBlock)((Object)BlockRegistry.INCUBATOR_SULFUR_VESSEL.get()))).asItem(), "A vessel to hold Sulfur for the Incubator.", null, this.f("Place horizontally next to the incubator.\n{0} with Alchemical Sulfur to fill the vessel to allow the Incubator to process it.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.SAL_AMMONIAC_ACCUMULATOR, "Sal Ammoniac Accumulator");
        this.addTooltip(() -> ((SalAmmoniacAccumulatorBlock)((SalAmmoniacAccumulatorBlock)((Object)BlockRegistry.SAL_AMMONIAC_ACCUMULATOR.get()))).asItem(), "A simple device to increase the concentration of residual Sal Ammoniac in water by evaporation.", "The resulting concentrated Sal Ammoniac fluid is a solvent that can be used in Liquefaction Cauldrons.", this.f("Place this on top of a Sal Ammoniac Tank.\n{0} with water buckets to fill the accumulator.\nThe water will be consumed to fill the Sal Ammoniac Tank below.\nYou can additionally add Sal Ammoniac Crystals to the Accumulator to speed up the process.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.SAL_AMMONIAC_TANK, "Sal Ammoniac Tank");
        this.addTooltip(() -> ((SalAmmoniacTankBlock)((SalAmmoniacTankBlock)((Object)BlockRegistry.SAL_AMMONIAC_TANK.get()))).asItem(), "A tank to store concentrated Sal Ammoniac fluid.", "Sal Ammoniac is a solvent that can be used in Liquefaction Cauldrons.", "Place this below a filled Sal Ammoniac Accumulator.\nThe Tank will slowly be filled with Sal Ammoniac.\n");
        this.addBlock((Supplier)BlockRegistry.MERCURY_CATALYST, "Mercury Catalyst");
        this.addTooltip(() -> ((MercuryCatalystBlock)((MercuryCatalystBlock)((Object)BlockRegistry.MERCURY_CATALYST.get()))).asItem(), "Converts mercury from it's crystal form into it's flux form.", "Mercury in flux form is pure energy and may be used as an energy source for certain processes.", this.f("{0} with mercury shards to add them to the catalyst.\nThey will be slowly consumed to fill the internal energy storage of the catalyst with mercury flux.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.CALORIC_FLUX_EMITTER, "Caloric Flux Emitter");
        this.addTooltip(() -> ((CaloricFluxEmitterBlock)((CaloricFluxEmitterBlock)((Object)BlockRegistry.CALORIC_FLUX_EMITTER.get()))).asItem(), "Remotely heats an Apparatus by emitting Caloric Flux at it.", "Caloric Flux is energy in the form of raw heat, and as such a derivative of Mercury Flux.", this.f("{0} an apparatus block to set it as the target for the emitter.\nThen place the emitter on a Mercury Flux source, such as a Mercury Catalyst.\nIt will \"shoot\" Caloric Flux at the apparatus, heating it up.\n", this.green("Sneak-Right-Click")));
        this.addBlock((Supplier)BlockRegistry.SULFURIC_FLUX_EMITTER, "Sulfuric Flux Emitter");
        this.addTooltip(() -> ((SulfuricFluxEmitterBlock)((SulfuricFluxEmitterBlock)((Object)BlockRegistry.SULFURIC_FLUX_EMITTER.get()))).asItem(), "Used to power a sulfur reformation array to replicate Alchemical Sulfur.", "Sulfuric Flux allows to transfer, merge and manipulate Alchemical Sulfur.", this.f(" {0} on Source, Target and Reformation pedestals to set them as the targets for the emitter to form a reformation array.\nThen place the emitter on a Mercury Flux source, such as a Mercury Catalyst.\nView The Hermetica for more information.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.REFORMATION_SOURCE_PEDESTAL, "Reformation Source Pedestal");
        this.addTooltip(() -> ((ReformationSourcePedestalBlock)((ReformationSourcePedestalBlock)((Object)BlockRegistry.REFORMATION_SOURCE_PEDESTAL.get()))).asItem(), "Holds the source Alchemical Sulfur to be reformed into the target Alchemical Sulfur.");
        this.addBlock((Supplier)BlockRegistry.REFORMATION_TARGET_PEDESTAL, "Reformation Target Pedestal");
        this.addTooltip(() -> ((ReformationTargetPedestalBlock)((ReformationTargetPedestalBlock)((Object)BlockRegistry.REFORMATION_TARGET_PEDESTAL.get()))).asItem(), "Holds the target Alchemical Sulfur that the source Alchemical Sulfur should be reformed into.");
        this.addBlock((Supplier)BlockRegistry.REFORMATION_RESULT_PEDESTAL, "Reformation Result Pedestal");
        this.addTooltip(() -> ((ReformationResultPedestalBlock)((ReformationResultPedestalBlock)((Object)BlockRegistry.REFORMATION_RESULT_PEDESTAL.get()))).asItem(), "The reformation result will appear in this pedestal.");
        this.addBlock((Supplier)BlockRegistry.FERMENTATION_VAT, "Fermentation Vat");
        this.addTooltip(() -> ((FermentationVatBlock)((FermentationVatBlock)((Object)BlockRegistry.FERMENTATION_VAT.get()))).asItem(), "A vat for alchemical fermentation, required for transmutation.", "Fermentation is fundamental the conversion between types of matter (such as between metals and gems).", this.f("{0} with ingredients to place them in the vat for processing.\n{1} with an empty hand to close or open the vat to start or stop processing.\n", this.green("Right-Click"), this.green("Shift-right-Click")));
        this.addBlock((Supplier)BlockRegistry.DIGESTION_VAT, "Digestion Vat");
        this.addTooltip(() -> ((DigestionVatBlock)((DigestionVatBlock)((Object)BlockRegistry.DIGESTION_VAT.get()))).asItem(), "A vat for alchemical digestion, required for exaltation.", "Digestion is fundamental the conversion between tiers of matter (such as between common and rare [e.g. iron and gold]).", this.f("{0} with ingredients to place them in the vat for processing.\n{1} with an empty hand to close or open the vat to start or stop processing.\n", this.green("Right-Click"), this.green("Shift-right-Click")));
        this.addBlock((Supplier)BlockRegistry.SAL_AMMONIAC_ORE, "Sal Ammoniac Ore");
        this.addExtendedTooltip(() -> ((Block)((Block)BlockRegistry.SAL_AMMONIAC_ORE.get())).asItem(), "Ore that yields Sal Ammoniac Crystals for use in a Sal Ammoniac Accumulator.");
        this.addBlock((Supplier)BlockRegistry.DEEPSLATE_SAL_AMMONIAC_ORE, "Deepslate Sal Ammoniac Ore");
        this.addExtendedTooltip(() -> ((Block)((Block)BlockRegistry.DEEPSLATE_SAL_AMMONIAC_ORE.get())).asItem(), "Ore that yields Sal Ammoniac Crystals for use in a Sal Ammoniac Accumulator.");
        this.addBlock((Supplier)BlockRegistry.LOGISTICS_ITEM_INSERTER, "Mercurial Item Inserter");
        this.addTooltip(() -> ((LogisticsItemInserterBlock)((LogisticsItemInserterBlock)BlockRegistry.LOGISTICS_ITEM_INSERTER.get())).asItem(), "Allows to insert items into a block from a Mercurial Logistics Network", null, this.f("{0} the target block with the inserter to place it.\nThen {0} the inserter with a cable to connect it to the network.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.LOGISTICS_ITEM_EXTRACTOR, "Mercurial Item Extractor");
        this.addTooltip(() -> ((LogisticsItemExtractorBlock)((LogisticsItemExtractorBlock)BlockRegistry.LOGISTICS_ITEM_EXTRACTOR.get())).asItem(), "Allows to extract items from a block into a Mercurial Logistics Network", null, this.f("{0} the target block with the extractor to place it.\nThen {0} the extractor with a cable to connect it to the network.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.LOGISTICS_CONNECTION_NODE, "Mercurial Connection Node");
        this.addTooltip(() -> ((LogisticsConnectionNodeBlock)((LogisticsConnectionNodeBlock)BlockRegistry.LOGISTICS_CONNECTION_NODE.get())).asItem(), "Allows to connect multiple wires in a Mercurial Logistics Network", null, this.f("Place the connection node, then use wires to connect it with other connection nodes, or other mercurial logistics blocks.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.LOGISTICS_FLUID_INSERTER, "Mercurial Fluid Inserter");
        this.addTooltip(() -> ((LogisticsFluidInserterBlock)((LogisticsFluidInserterBlock)BlockRegistry.LOGISTICS_FLUID_INSERTER.get())).asItem(), "Allows to insert fluids into a block from a Mercurial Logistics Network", null, this.f("{0} the target block with the inserter to place it.\nThen {0} the inserter with a cable to connect it to the network.\n", this.green("Right-Click")));
        this.addBlock((Supplier)BlockRegistry.LOGISTICS_FLUID_EXTRACTOR, "Mercurial Fluid Extractor");
        this.addTooltip(() -> ((LogisticsFluidExtractorBlock)((LogisticsFluidExtractorBlock)BlockRegistry.LOGISTICS_FLUID_EXTRACTOR.get())).asItem(), "Allows to extract fluids from a block into a Mercurial Logistics Network", null, this.f("{0} the target block with the extractor to place it.\nThen {0} the extractor with a cable to connect it to the network.\n", this.green("Right-Click")));
    }

    private void addNiter(AlchemicalNiterItem niter) {
        this.addItem(() -> niter, "Alchemical Niter %s");
        this.addTooltip(() -> niter, "Alchemical Niter crafted from Alchemical Sulfur of any %s.", "Niter represents the abstract category and value of an object, thus it is a further abstraction of the \"idea\" or \"soul\" represented by Sulfur.", "Niter extraction is a required intermediate step to transform one type of Sulfur into another type.");
    }

    private void addSulfurs() {
        this.add("item.theurgy.alchemical_derivative.unknown_source", "Unknown Source");
        this.add(AlchemicalDerivativeTier.ABUNDANT.descriptionId(), "Abundant");
        this.add(AlchemicalDerivativeTier.COMMON.descriptionId(), "Common");
        this.add(AlchemicalDerivativeTier.RARE.descriptionId(), "Rare");
        this.add(AlchemicalDerivativeTier.PRECIOUS.descriptionId(), "Precious");
        this.add(AlchemicalSulfurType.MISC.descriptionId(), "Misc");
        this.add(AlchemicalSulfurType.EARTHEN_MATTERS.descriptionId(), "Earthen Matters");
        this.add(AlchemicalSulfurType.METALS.descriptionId(), "Metals");
        this.add(AlchemicalSulfurType.GEMS.descriptionId(), "Gems");
        this.add(AlchemicalSulfurType.OTHER_MINERALS.descriptionId(), "Other Minerals");
        this.add(AlchemicalSulfurType.LOGS.descriptionId(), "Logs");
        this.add(AlchemicalSulfurType.CROPS.descriptionId(), "Crops");
        this.add(AlchemicalSulfurType.ANIMALS.descriptionId(), "Animal Parts");
        this.add(AlchemicalSulfurType.MOBS.descriptionId(), "Mob Drops");
        this.add("item.theurgy.alchemical_derivative.type.niter", "Niter");
        SulfurRegistry.SULFURS.getEntries().stream().map(DeferredHolder::get).map(AlchemicalSulfurItem.class::cast).forEach(sulfur -> {
            if (sulfur.useAutomaticNameLangGeneration) {
                this.addItem(() -> sulfur, "Alchemical Sulfur %s");
            }
            if (sulfur.useAutomaticTooltipLangGeneration) {
                this.addTooltip(() -> sulfur, "Alchemical Sulfur crafted from %s %s %s.", "Sulfur represents the \"idea\" or \"soul\" of an object", "Sulfur is the central element used in Spagyrics processes.\n\n" + String.valueOf(ChatFormatting.ITALIC) + "Hint: Sulfurs crafted from different states of the same material (such as from Ore or Ingots) are interchangeable." + String.valueOf(ChatFormatting.RESET));
            }
        });
        NiterRegistry.NITERS.getEntries().stream().map(DeferredHolder::get).map(AlchemicalNiterItem.class::cast).forEach(this::addNiter);
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.EARTHEN_MATTERS_ABUNDANT, "Abundant Earthen Matters");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.EARTHEN_MATTERS_COMMON, "Common Earthen Matters");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.GEMS_ABUNDANT, "Abundant Gems");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.GEMS_COMMON, "Common Gems");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.GEMS_RARE, "Rare Gems");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.GEMS_PRECIOUS, "Precious Gems");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.METALS_ABUNDANT, "Abundant Metals");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.METALS_COMMON, "Common Metals");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.METALS_RARE, "Rare Metals");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.METALS_PRECIOUS, "Precious Metals");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.OTHER_MINERALS_ABUNDANT, "Abundant Other Minerals");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.OTHER_MINERALS_COMMON, "Common Other Minerals");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.OTHER_MINERALS_RARE, "Rare Other Minerals");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.OTHER_MINERALS_PRECIOUS, "Precious Other Minerals");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.LOGS_ABUNDANT, "Abundant Logs");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.CROPS_ABUNDANT, "Abundant Crops");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.ANIMALS_ABUNDANT, "Abundant Animal Parts");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.ANIMALS_COMMON, "Common Animal Parts");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.ANIMALS_RARE, "Rare Animal Parts");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.MOBS_ABUNDANT, "Abundant Mob Drops");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.MOBS_COMMON, "Common Mob Drops");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.MOBS_RARE, "Rare Mob Drops");
        this.addDerivativeSource((Supplier<? extends Item>)NiterRegistry.MOBS_PRECIOUS, "Precious Mob Drops");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.OAK_LOG, "Oak");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.SPRUCE_LOG, "Spruce");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.BIRCH_LOG, "Birch");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.JUNGLE_LOG, "Jungle");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ACACIA_LOG, "Acacia");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CHERRY_LOG, "Cherry");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.DARK_OAK_LOG, "Dark Oak");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.MANGROVE_LOG, "Mangrove");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CRIMSON_STEM, "Crimson");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.WARPED_STEM, "Warped");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ROWAN_LOG, "Rowan");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.FIR_LOG, "Fir");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.REDWOOD_LOG, "Redwood");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.MAHOGANY_LOG, "Mahogany");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.JACARANDA_LOG, "Jacaranda");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.PALM_LOG, "Palm");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.WILLOW_LOG, "Willow");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.DEAD_LOG, "Dead");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.MAGIC_LOG, "Magic");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.UMBRAN_LOG, "Umbran");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.HELLBARK_LOG, "Hellbark");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CINNAMON_LOG, "Cinnamon");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.GLACIAN_LOG, "Glacian");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ARCHWOOD_LOG, "Archwood");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.BLUEBRIGHT_LOG, "Bluebright");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.STARLIT_LOG, "Starlit");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.FROSTBRIGHT_LOG, "Frostbright");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.COMET_LOG, "Comet");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.LUNAR_LOG, "Lunar");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.DUSK_LOG, "Dusk");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.MAPLE_LOG, "Maple");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CRYSTALLIZED_LOG, "Crystallized");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.LIVINGWOOD_LOG, "Livingwood");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.GLIMMERING_LIVINGWOOD_LOG, "Glimmering Livingwood");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.DREAMWOOD_LOG, "Dreamwood");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.GLIMMERING_DREAMWOOD_LOG, "Glimmering Dreamwood");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.WALNUT_LOG, "Walnut");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.FIG_LOG, "Fig");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.WOLFBERRY_LOG, "Wolfberry");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ECHO_LOG, "Echo");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ILLWOOD_LOG, "Illwood");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.UNDEAD_LOG, "Undead");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.AURUM_LOG, "Aurum");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.MENRIL_LOG, "Menril");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ASHEN_LOG, "Ashen");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.AZALEA_LOG, "Azalea");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.TRUMPET_LOG, "Trumpet");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.NETHERWOOD_LOG, "Netherwood");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.SKYROOT_LOG, "Skyroot");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.GOLDEN_OAK_LOG, "Golden Oak");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.TWILIGHT_OAK_LOG, "Twilight Oak");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CANOPY_TREE_LOG, "Canopy Tree");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.DARKWOOD_LOG, "Darkwood");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.TIMEWOOD_LOG, "Timewood");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.TRANSWOOD_LOG, "Transwood");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.SORTINGWOOD_LOG, "Sortingwood");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.MINEWOOD_LOG, "Minewood");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.SMOGSTEM_LOG, "Smogstem");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.WIGGLEWOOD_LOG, "Wigglewood");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.GRONGLE_LOG, "Grongle");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.RUBBERWOOD_LOG, "Rubberwood");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.OTHERWORLD_LOG, "Otherworld");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.BEETROOT, "Beetroot");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CARROT, "Carrot");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.POTATO, "Potato");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.WHEAT, "Wheat");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.APPLE, "Apple");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.COCOA, "Cocoa");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.NETHER_WART, "Nether Wart");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ARTICHOKE, "Artichoke");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ASPARAGUS, "Asparagus");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.BARLEY, "Barley");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.BASIL, "Basil");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.BELLPEPPER, "Bell Pepper");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.BLACKBEAN, "Black Bean");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.BLACKBERRY, "Blackberry");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.BLUEBERRY, "Blueberry");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.BROCCOLI, "Broccoli");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CABBAGE, "Cabbage");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CANTALOUPE, "Cantaloupe");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CAULIFLOWER, "Cauliflower");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CELERY, "Celery");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CHILE_PEPPER, "Chile Pepper");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.COFFEE_BEANS, "Coffee Beans");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CORN, "Corn");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CRANBERRY, "Cranberry");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CUCUMBER, "Cucumber");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CURRANT, "Currant");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.EGGPLANT, "Eggplant");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ELDERBERRY, "Elderberry");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.GARLIC, "Garlic");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.GINGER, "Ginger");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.GRAPE, "Grape");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.GREENBEAN, "Green Bean");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.GREENONION, "Green Onion");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.HONEYDEW, "Honeydew");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.HOPS, "Hops");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.KALE, "Kale");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.KIWI, "Kiwi");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.LEEK, "Leek");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.LETTUCE, "Lettuce");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.MUSTARD, "Mustard");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.OAT, "Oat");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.OLIVE, "Olive");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ONION, "Onion");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.PEANUT, "Peanut");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.PEPPER, "Pepper");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.PINEAPPLE, "Pineapple");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.RADISH, "Radish");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.RASPBERRY, "Raspberry");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.RHUBARB, "Rhubarb");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.RICE, "Rice");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.RUTABAGA, "Rutabaga");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.SAGUARO, "Saguaro");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.SOYBEAN, "Soybean");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.SPINACH, "Spinach");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.SQUASH, "Squash");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.STRAWBERRY, "Strawberry");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.SWEETPOTATO, "Sweet Potato");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.TEA_LEAVES, "Tea Leaves");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.TOMATILLO, "Tomatillo");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.TOMATO, "Tomato");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.TURMERIC, "Turmeric");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.TURNIP, "Turnip");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.VANILLA, "Vanilla");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.YAM, "Yam");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ZUCCHINI, "Zucchini");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.FLAX, "Flax");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.JUNIPERBERRY, "Juniperberry");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ALMOND, "Almond");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.APRICOT, "Apricot");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.AVOCADO, "Avocado");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.BANANA, "Banana");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CASHEW, "Cashew");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CHERRY, "Cherry");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.COCONUT, "Coconut");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.DATE, "Date");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.DRAGONFRUIT, "Dragonfruit");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.FIG, "Fig");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.GRAPEFRUIT, "Grapefruit");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.KUMQUAT, "Kumquat");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.LEMON, "Lemon");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.LIME, "Lime");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.MANDARIN, "Mandarin");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.MANGO, "Mango");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.NECTARINE, "Nectarine");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.NUTMEG, "Nutmeg");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ORANGE, "Orange");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.PEACH, "Peach");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.PEAR, "Pear");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.PECAN, "Pecan");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.PERSIMMON, "Persimmon");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.PLUM, "Plum");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.PORKCHOP, "Porkchop");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.BEEF, "Beef");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.MUTTON, "Mutton");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CHICKEN, "Chicken");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.EGG, "Egg");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.INK_SAC, "Ink Sac");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.GLOW_INK_SAC, "Glow Ink Sac");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.RABBIT, "Rabbit");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.RABBIT_HIDE, "Rabbit Hide");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.RABBIT_FOOT, "Rabbit Foot");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.LEATHER, "Leather");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.FEATHER, "Feather");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.WOOL, "Wool");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.COD, "Cod");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.SALMON, "Salmon");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.TROPICAL_FISH, "Tropical Fish");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.PUFFERFISH, "Pufferfish");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.TURTLE_SCUTE, "Turtle Scute");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ARMADILLO_SCUTE, "Armadillo Scute");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.DIRT, "Dirt");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.COARSE_DIRT, "Coarse Dirt");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.PODZOL, "Podzol");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.GRASS_BLOCK, "Grass Block");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ROOTED_DIRT, "Rooted Dirt");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.MOSS_BLOCK, "Moss Block");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.MUD, "Mud");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.MUDDY_MANGROVE_ROOTS, "Muddy Mangrove Roots");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.SAND, "Sand");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.RED_SAND, "Red Sand");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.GRAVEL, "Gravel");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.NETHERRACK, "Netherrack");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.SOUL_SAND, "Soul Sand");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.SOUL_SOIL, "Soul Soil");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.STONE, "Stone");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.INFESTED_STONE, "Infested Stone");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.COBBLESTONE, "Cobblestone");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.COBBLESTONE_MOSSY, "Mossy Cobblestone");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.COBBLESTONES_INFESTED, "Infested Cobblestone");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.DEEPSLATE, "Deepslate");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.COBBLESTONE_DEEPSLATE, "Deepslate Cobblestone");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.GRANITE, "Granite");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.DIORITE, "Diorite");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ANDESITE, "Andesite");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.BLACKSTONE, "Blackstone");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.BASALT, "Basalt");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.SANDSTONE, "Sandstone");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.RED_SANDSTONE, "Red Sandstone");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CLAY, "Clay");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.TERRACOTTA, "Terracotta");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CRIMSON_NYLIUM, "Crimson Nylium");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.WARPED_NYLIUM, "Warped Nylium");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.END_STONE, "End Stone");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.PURPUR_BLOCK, "Purpur Block");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.MYCELIUM, "Mycelium");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.OBSIDIAN, "Obsidian");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CRYING_OBSIDIAN, "Crying Obsidian");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.SNOW, "Snow");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ICE, "Ice");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.MAGMA, "Magma");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.WATER, "Water");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.LAVA, "Lava");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.IRON, "Iron");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.COPPER, "Copper");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.SILVER, "Silver");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.GOLD, "Gold");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.NETHERITE, "Netherite");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.URANIUM, "Uranium");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.URANINITE, "Uraninite");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.AZURE_SILVER, "Azure Silver");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ZINC, "Zinc");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.OSMIUM, "Osmium");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.NICKEL, "Nickel");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.LEAD, "Lead");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ALLTHEMODIUM, "Allthemodium");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.UNOBTAINIUM, "Unobtainium");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.IRIDIUM, "Iridium");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.TIN, "Tin");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ALUMINUM, "Aluminum");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CINNABAR, "Cinnabar");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CRIMSON_IRON, "Crimson Iron");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.PLATINUM, "Platinum");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.VIBRANIUM, "Vibranium");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.DESH, "Desh");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.OSTRUM, "Ostrum");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CALORITE, "Calorite");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.IESNIUM, "Iesnium");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.ANTIMONY, "Antimony");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.TITANIUM, "Titanium");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.TUNGSTEN, "Tungsten");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.DIAMOND, "Diamond");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.EMERALD, "Emerald");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.LAPIS, "Lapis");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.QUARTZ, "Quartz");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.AMETHYST, "Amethyst");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.PRISMARINE, "Prismarine");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.RUBY, "Ruby");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.APATITE, "Apatite");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.PERIDOT, "Peridot");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.FLUORITE, "Fluorite");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.SAPPHIRE, "Sapphire");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.DARK_GEM, "Dark Gem");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.SAL_AMMONIAC, "Sal Ammoniac");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CERTUS_QUARTZ, "Certus Quartz");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.FLUIX, "Fluix");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.NITER, "Niter");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.CHIMERITE, "Chimerite");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.DEMONITE, "Demonite");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.REDSTONE, "Redstone");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.COAL, "Coal");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.SULFUR, "Sulfur");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.GLOWSTONE, "Glowstone");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.LIGNITE_COAL, "Lignite Coal");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.MONAZITE, "Monazite");
        this.addDerivativeSource((Supplier<? extends Item>)SulfurRegistry.BAUXITE, "Bauxite");
    }

    private void addSalts() {
        this.addDerivativeSource((Supplier<? extends Item>)SaltRegistry.MINERAL, "Minerals");
        this.addDerivativeSource((Supplier<? extends Item>)SaltRegistry.PLANT, "Plants");
        this.addDerivativeSource((Supplier<? extends Item>)SaltRegistry.STRATA, "Strata");
        this.addExtendedTooltip(() -> ((AlchemicalSaltItem)((AlchemicalSaltItem)((Object)SaltRegistry.STRATA.get()))).asItem(), "Salt extracted from the strata, that is, sedimentary rock, soil, clay and so on.");
        this.addDerivativeSource((Supplier<? extends Item>)SaltRegistry.CREATURE, "Creatures");
        SaltRegistry.SALTS.getEntries().stream().map(DeferredHolder::get).map(AlchemicalSaltItem.class::cast).forEach(salt -> {
            this.addItem(() -> salt, "Alchemical Salt %s");
            this.addTooltip(() -> salt, "Alchemical Salt calcinated from %s.", null, "Salt represents the \"body\" or \"physical matter\" of an object.");
        });
    }

    public void addDerivativeSource(Supplier<? extends Item> key, String name) {
        this.add(key.get().getDescriptionId() + ".source", name);
    }

    public void addIngredientInfo(Supplier<Item> ingredient, String info) {
        this.add("jei.theurgy.ingredient." + BuiltInRegistries.ITEM.getKey((Object)ingredient.get()).getPath() + ".description", info);
    }

    private void addDivinationRods() {
        this.add("tooltip.theurgy..divination_rod.no_link", "The divination rod is " + String.valueOf(ChatFormatting.RED) + "not attuned" + String.valueOf(ChatFormatting.RESET) + " to any material.");
        this.add("tooltip.theurgy..divination_rod.linked_to", "The divination rod is attuned to %s");
        this.add("tooltip.theurgy..divination_rod.last_result", "Found %s at %s.");
        this.add("item.theurgy.divination_rod.unknown_linked_block", "Unknown Block (something went wrong)");
        String divinationRodUsage = this.f("{0} a block to attune the rod to it.\n{1} to let the rod search for blocks.\n{2} after a successful search to let the rod show the last found block without consuming durability.\n", this.green("Crouch-Click"), this.green("Right-Click and hold"), this.green("Right-Click without holding"));
        String sulfurAttunedDivinationRodUsage = this.f("{0} the rod with a type of Alchemical Sulfur to attune the rod to it.\n{1} to let the rod search for blocks.\n{2} after a successful search to let the rod show the last found block without consuming durability.\n", this.green("Craft"), this.green("Right-Click and hold"), this.green("Right-Click without holding"));
        String amethystDivinationRodUsage = this.f("{0} the rod, it is automatically attuned to Amethyst.\n{1} to let the rod search for blocks.\n{2} after a successful search to let the rod show the last found block without consuming durability.\n", this.green("Craft"), this.green("Right-Click and hold"), this.green("Right-Click without holding"));
        this.addItem((Supplier)ItemRegistry.DIVINATION_ROD_T1, "Glass Divination Rod");
        this.add(((DivinationRodItem)((Object)ItemRegistry.DIVINATION_ROD_T1.get())).getDescriptionId() + ".linked", "Glass Divination Rod %s");
        this.addExtendedTooltip((Supplier)ItemRegistry.DIVINATION_ROD_T1, "Divination rods can be attuned to a block and are then used to find other blocks of the same type.", divinationRodUsage);
        this.addItem((Supplier)ItemRegistry.DIVINATION_ROD_T2, "Iron Divination Rod");
        this.add(((DivinationRodItem)((Object)ItemRegistry.DIVINATION_ROD_T2.get())).getDescriptionId() + ".linked", "Iron Divination Rod %s");
        this.addExtendedTooltip((Supplier)ItemRegistry.DIVINATION_ROD_T2, "Divination rods can be attuned to a block and are then used to find other blocks of the same type.", divinationRodUsage);
        this.addItem((Supplier)ItemRegistry.DIVINATION_ROD_T3, "Diamond Divination Rod");
        this.add(((DivinationRodItem)((Object)ItemRegistry.DIVINATION_ROD_T3.get())).getDescriptionId() + ".linked", "Diamond Divination Rod %s");
        this.addExtendedTooltip((Supplier)ItemRegistry.DIVINATION_ROD_T3, "Divination rods can be attuned to a block and are then used to find other blocks of the same type.", divinationRodUsage);
        this.addItem((Supplier)ItemRegistry.DIVINATION_ROD_T4, "Netherite Divination Rod");
        this.add(((DivinationRodItem)((Object)ItemRegistry.DIVINATION_ROD_T4.get())).getDescriptionId() + ".linked", "Netherite Divination Rod %s");
        this.addExtendedTooltip((Supplier)ItemRegistry.DIVINATION_ROD_T4, "Divination rods can be attuned to a block and are then used to find other blocks of the same type.", divinationRodUsage);
        this.addItem((Supplier)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_ABUNDANT, "Divination Rod: Abundant Materials");
        this.add(((DivinationRodItem)((Object)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_ABUNDANT.get())).getDescriptionId() + ".linked", "Divination Rod: Abundant Materials %s");
        this.addTooltip((Supplier)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_ABUNDANT, "A divination rod attuned to find abundant materials by crafting it with an abundant alchemical sulfur.", "This type of divination rod is crafted pre-attuned to find blocks of the a specific type.", sulfurAttunedDivinationRodUsage);
        this.addItem((Supplier)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_COMMON, "Divination Rod: Common Materials");
        this.add(((DivinationRodItem)((Object)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_COMMON.get())).getDescriptionId() + ".linked", "Divination Rod: Common Materials %s");
        this.addTooltip((Supplier)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_COMMON, "A divination rod attuned to find common materials by crafting it with a common alchemical sulfur.", "This type of divination rod is crafted pre-attuned to find blocks of the a specific type.", sulfurAttunedDivinationRodUsage);
        this.addItem((Supplier)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_RARE, "Divination Rod: Rare Materials");
        this.add(((DivinationRodItem)((Object)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_RARE.get())).getDescriptionId() + ".linked", "Divination Rod: Rare Materials %s");
        this.addTooltip((Supplier)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_RARE, "A divination rod attuned to find rare materials by crafting it with a rare alchemical sulfur.", "This type of divination rod is crafted pre-attuned to find blocks of the a specific type.", sulfurAttunedDivinationRodUsage);
        this.addItem((Supplier)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_PRECIOUS, "Divination Rod: Precious Materials");
        this.add(((DivinationRodItem)((Object)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_PRECIOUS.get())).getDescriptionId() + ".linked", "Divination Rod: Precious Materials %s");
        this.addTooltip((Supplier)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_PRECIOUS, "A divination rod attuned to find precious materials by crafting it with a precious alchemical sulfur.", "This type of divination rod is crafted pre-attuned to find blocks of the a specific type.", sulfurAttunedDivinationRodUsage);
        this.addItem((Supplier)ItemRegistry.AMETHYST_DIVINATION_ROD, "Divination Rod: Amethyst");
        this.add(((DivinationRodItem)((Object)ItemRegistry.AMETHYST_DIVINATION_ROD.get())).getDescriptionId() + ".linked", "Divination Rod: %s");
        this.addTooltip((Supplier)ItemRegistry.AMETHYST_DIVINATION_ROD, "A divination rod attuned to find amethyst.", "This type of divination rod is crafted pre-attuned to find amethysts.", amethystDivinationRodUsage);
    }

    private void addItems() {
        this.add("itemGroup.theurgy", "Theurgy");
        this.addSalts();
        this.addSulfurs();
        this.addDivinationRods();
        this.addItem((Supplier)ItemRegistry.EMPTY_JAR_ICON, "Empty Jar Icon");
        this.addTooltip((Supplier)ItemRegistry.EMPTY_JAR_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.EMPTY_JAR_IRON_BAND_ICON, "Empty Jar with Iron Band Icon");
        this.addTooltip((Supplier)ItemRegistry.EMPTY_JAR_IRON_BAND_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.EMPTY_CERAMIC_JAR_ICON, "Empty Ceramic Jar Icon");
        this.addTooltip((Supplier)ItemRegistry.EMPTY_CERAMIC_JAR_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.EMPTY_JAR_LABELED_ICON, "Labeled Empty Jar Icon");
        this.addTooltip((Supplier)ItemRegistry.EMPTY_JAR_LABELED_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.EMPTY_CERAMIC_JAR_LABELED_ICON, "Labeled Empty Ceramic Jar Icon");
        this.addTooltip((Supplier)ItemRegistry.EMPTY_CERAMIC_JAR_LABELED_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.JAR_LABEL_ICON, "Jar Label Icon");
        this.addTooltip((Supplier)ItemRegistry.JAR_LABEL_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.JAR_LABEL_FRAME_ABUNDANT_ICON, "Jar Label Frame Abundant Icon");
        this.addTooltip((Supplier)ItemRegistry.JAR_LABEL_FRAME_ABUNDANT_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.JAR_LABEL_FRAME_COMMON_ICON, "Jar Label Frame Common Icon");
        this.addTooltip((Supplier)ItemRegistry.JAR_LABEL_FRAME_COMMON_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.JAR_LABEL_FRAME_RARE_ICON, "Jar Label Frame Rare Icon");
        this.addTooltip((Supplier)ItemRegistry.JAR_LABEL_FRAME_RARE_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.JAR_LABEL_FRAME_PRECIOUS_ICON, "Jar Label Frame Precious Icon");
        this.addTooltip((Supplier)ItemRegistry.JAR_LABEL_FRAME_PRECIOUS_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.THE_HERMETICA_ICON, "The Hermetica Icon");
        this.addTooltip((Supplier)ItemRegistry.THE_HERMETICA_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.GEMS_ABUNDANT_ICON, "Abundant Gems Icon");
        this.addTooltip((Supplier)ItemRegistry.GEMS_ABUNDANT_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.GEMS_COMMON_ICON, "Common Gems Icon");
        this.addTooltip((Supplier)ItemRegistry.GEMS_COMMON_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.GEMS_RARE_ICON, "Rare Gems Icon");
        this.addTooltip((Supplier)ItemRegistry.GEMS_RARE_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.GEMS_PRECIOUS_ICON, "Precious Gems Icon");
        this.addTooltip((Supplier)ItemRegistry.GEMS_PRECIOUS_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.METALS_ABUNDANT_ICON, "Abundant Metals Icon");
        this.addTooltip((Supplier)ItemRegistry.METALS_ABUNDANT_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.METALS_COMMON_ICON, "Common Metals Icon");
        this.addTooltip((Supplier)ItemRegistry.METALS_COMMON_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.METALS_RARE_ICON, "Rare Metals Icon");
        this.addTooltip((Supplier)ItemRegistry.METALS_RARE_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.METALS_PRECIOUS_ICON, "Precious Metals Icon");
        this.addTooltip((Supplier)ItemRegistry.METALS_PRECIOUS_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.OTHER_MINERALS_ABUNDANT_ICON, "Abundant Other Minerals Icon");
        this.addTooltip((Supplier)ItemRegistry.OTHER_MINERALS_ABUNDANT_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.OTHER_MINERALS_COMMON_ICON, "Common Other Minerals Icon");
        this.addTooltip((Supplier)ItemRegistry.OTHER_MINERALS_COMMON_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.OTHER_MINERALS_RARE_ICON, "Rare Other Minerals Icon");
        this.addTooltip((Supplier)ItemRegistry.OTHER_MINERALS_RARE_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.OTHER_MINERALS_PRECIOUS_ICON, "Precious Other Minerals Icon");
        this.addTooltip((Supplier)ItemRegistry.OTHER_MINERALS_PRECIOUS_ICON, "Dummy item for rendering.");
        this.addItem((Supplier)ItemRegistry.SAL_AMMONIAC_BUCKET, "Sal Ammoniac Bucket");
        this.addItem((Supplier)ItemRegistry.COPPER_WIRE, "Mercurial Copper Wire");
        this.addTooltip((Supplier)ItemRegistry.COPPER_WIRE, "A piece of copper wire capable of transferring matter in its mercurial form.", "Can be used to connect different parts of Mercurial Logistics Networks.", "Right-click one connector, then right-click another connector to connect them with the wire.\nRepeat the process to disconnect them.\n");
        this.addDynamicTooltip((Supplier)ItemRegistry.COPPER_WIRE, this.f("Linked to %1$s (Highlighted in yellow in the world).\n\n{0} another connector block to create wire connection.\n{1} the air or a non-connector block to unlink.\n{0} another connector block already wired to %1$s to remove the wire.\n", this.green("Right-Click"), this.green("Shift-Right-Click")));
        this.addItem((Supplier)ItemRegistry.MERCURIAL_WAND, "Mercurial Wand");
        String wandUsage = this.f("{0} to use current mode.\nHold {1} and {3} to cycle through modes.\n", this.green("Right-Click"), this.green("Crouch"), this.green("Right Mouse Button"), this.green("Scroll"));
        this.addTooltip((Supplier)ItemRegistry.MERCURIAL_WAND, "Definitely not just a wrench.", "Allows configuring alchemical apparatuses and mercurial logistics networks.", wandUsage);
        this.add("item.mode.theurgy.mercurial_wand.select_direction", "Select direction (Currently: %s)");
        this.add("item.mode.theurgy.mercurial_wand.select_direction.success", "Direction: %s");
        this.add("item.mode.theurgy.mercurial_wand.set_selected_direction", "Set direction to %s");
        this.add("item.mode.theurgy.mercurial_wand.set_selected_direction.with_target", "Set direction from %s to %s");
        this.add("item.mode.theurgy.mercurial_wand.set_selected_direction.success", "Set direction to %s");
        this.add("item.mode.theurgy.mercurial_wand.rotate_selected_direction", "Cycle selected direction");
        this.add("item.mode.theurgy.mercurial_wand.rotate_selected_direction.with_target", "Set direction from %s to %s");
        this.add("item.mode.theurgy.mercurial_wand.rotate_selected_direction.success", "Cycle direction to %s");
        this.add("item.mode.theurgy.mercurial_wand.switch_logistics_enabled", "Enable/Disable");
        this.add("item.mode.theurgy.mercurial_wand.switch_logistics_enabled.hud", " (Currently: %s)");
        this.add("item.mode.theurgy.mercurial_wand.switch_logistics_enabled.success", "Logistics Connector is now %s");
        this.add("item.mode.theurgy.mercurial_wand.enabled", "Enabled");
        this.add("item.mode.theurgy.mercurial_wand.disabled", "Disabled");
        this.add("item.mode.theurgy.mercurial_wand.select_frequency", "Selected frequency: %s");
        this.add("item.mode.theurgy.mercurial_wand.set_selected_frequency", "Set frequency to %s");
        this.add("item.mode.theurgy.mercurial_wand.set_selected_frequency.with_target", "Set frequency from %s to %s");
        this.add("item.mode.theurgy.mercurial_wand.set_selected_frequency.success", "Set frequency to %s");
        this.addItem((Supplier)ItemRegistry.LIST_FILTER, "Mercurial List Filter");
        this.addUsageTooltip((Supplier)ItemRegistry.LIST_FILTER, this.f("{0} the air to open the filter GUI and add items.\n{0} a logistics inserter or extractor to apply the filter.\n{0} a filtered block with an empty hand to remove the filter.\n", this.green("Right-Click")));
        this.addItem((Supplier)ItemRegistry.ATTRIBUTE_FILTER, "Mercurial Attribute Filter");
        this.addUsageTooltip((Supplier)ItemRegistry.ATTRIBUTE_FILTER, this.f("{0} the air to open the filter GUI and add items.\n{0} a logistics inserter or extractor to apply the filter.\n{0} a filtered block with an empty hand to remove the filter.\n", this.green("Right-Click")));
        this.addItem((Supplier)ItemRegistry.MERCURY_SHARD, "Mercury Shard");
        this.addExtendedTooltip((Supplier)ItemRegistry.MERCURY_SHARD, "Mercury shards are small pieces of Mercury in crystalline form. Their main uses are as ingredient in Digestion processes and as an energy source.");
        this.addItem((Supplier)ItemRegistry.MERCURY_CRYSTAL, "Mercury Crystal");
        this.addExtendedTooltip((Supplier)ItemRegistry.MERCURY_CRYSTAL, "Mercury crystals are large pieces of Mercury in crystalline form. Their main uses are as ingredient in Digestion processes and as an energy source.");
        this.addItem((Supplier)ItemRegistry.SAL_AMMONIAC_CRYSTAL, "Sal Ammoniac Crystal");
        this.addExtendedTooltip((Supplier)ItemRegistry.SAL_AMMONIAC_CRYSTAL, "Obtained by mining Sal Ammoniac Ore, or by crafting a Sal Ammoniac Bucket in a crafting grid.\n");
        this.addUsageTooltip((Supplier)ItemRegistry.SAL_AMMONIAC_CRYSTAL, "Can be used in a Sal Ammoniac Accumulator to rapidly create Sal Ammoniac to be used as a solvent.\n");
        this.addIngredientInfo((Supplier<Item>)ItemRegistry.SAL_AMMONIAC_CRYSTAL, "Obtained by mining Sal Ammoniac Ore.");
        this.addItem((Supplier)ItemRegistry.PURIFIED_GOLD, "Purified Gold");
        this.addTooltip((Supplier)ItemRegistry.PURIFIED_GOLD, "Alchemically pure gold.", "Gold that has been purified by alchemical Digestion. This further improves the property of Gold not to react with other elements, allowing it to be used in alchemical processes without adding impurities to the result.\n", "Acts as a catalysator, enabling various alchemical processes.");
        this.addItem((Supplier)ItemRegistry.FERMENTATION_STARTER, "Fermentation Starter");
        this.addTooltip((Supplier)ItemRegistry.FERMENTATION_STARTER, "Fermentation aid for recipes in the Fermentation Vat.", "An extract of sugar and plant material that exhibits a high fermentation potential. Can be used as a more efficient alternative to raw sugar or crops in the Fermentation Vat.\n");
        this.addItem((Supplier)ItemRegistry.CRYSTALLIZED_WATER, "Crystallized Water");
        this.addTooltip((Supplier)ItemRegistry.CRYSTALLIZED_WATER, "Water in solid form for easy transportation, and alchemical processing.");
        this.addItem((Supplier)ItemRegistry.CRYSTALLIZED_LAVA, "Crystallized Lava");
        this.addTooltip((Supplier)ItemRegistry.CRYSTALLIZED_LAVA, "Lava in solid form for easy transportation, and alchemical processing.");
    }

    protected void addItemAttributes() {
        this.addItemAttribute(ItemAttribute.addedBy, false, "was added by %1$s");
        this.addItemAttribute(ItemAttribute.addedBy, true, "was not added by %1$s");
        this.addItemAttribute(StandardAttributes.BADLY_DAMAGED, false, "is heavily damaged");
        this.addItemAttribute(StandardAttributes.BADLY_DAMAGED, true, "is not heavily damaged");
        this.addItemAttribute(StandardAttributes.BLASTABLE, false, "can be Smelted in a Blast Furnace");
        this.addItemAttribute(StandardAttributes.BLASTABLE, true, "cannot be Smelted in a Blast Furnace");
        this.addItemAttribute(StandardAttributes.COMPOSTABLE, false, "can be composted");
        this.addItemAttribute(StandardAttributes.COMPOSTABLE, true, "cannot be composted");
        this.addItemAttribute(StandardAttributes.CONSUMABLE, false, "can be eaten");
        this.addItemAttribute(StandardAttributes.CONSUMABLE, true, "cannot be eaten");
        this.addItemAttribute(StandardAttributes.DAMAGED, false, "is damaged");
        this.addItemAttribute(StandardAttributes.DAMAGED, true, "is not damaged");
        this.addItemAttribute(StandardAttributes.ENCHANTED, false, "is enchanted");
        this.addItemAttribute(StandardAttributes.ENCHANTED, true, "is unenchanted");
        this.addItemAttribute(StandardAttributes.EQUIPABLE, false, "can be equipped");
        this.addItemAttribute(StandardAttributes.EQUIPABLE, true, "cannot be equipped");
        this.addItemAttribute(StandardAttributes.FLUID_CONTAINER, false, "can store fluids");
        this.addItemAttribute(StandardAttributes.FLUID_CONTAINER, true, "cannot store fluids");
        this.addItemAttribute(StandardAttributes.FURNACE_FUEL, false, "is furnace fuel");
        this.addItemAttribute(StandardAttributes.FURNACE_FUEL, true, "is not furnace fuel");
        this.addItemAttribute(EnchantAttribute.EMPTY, false, "is enchanted with %1$s");
        this.addItemAttribute(EnchantAttribute.EMPTY, true, "is not enchanted with %1$s");
        this.addItemAttribute(FluidContentsAttribute.EMPTY, false, "contains %1$s");
        this.addItemAttribute(FluidContentsAttribute.EMPTY, true, "does not contain %1$s");
        this.addItemAttribute(ItemNameAttribute.DUMMY, false, "has the custom name %1$s");
        this.addItemAttribute(ItemNameAttribute.DUMMY, true, "does not have the custom name %1$s");
        this.addItemAttribute(InTagAttribute.DUMMY, false, "is tagged %1$s");
        this.addItemAttribute(InTagAttribute.DUMMY, true, "is not tagged %1$s");
        this.addItemAttribute(StandardAttributes.MAX_ENCHANTED, false, "is enchanted at max level");
        this.addItemAttribute(StandardAttributes.MAX_ENCHANTED, true, "is not enchanted at max level");
        this.addItemAttribute(StandardAttributes.NOT_STACKABLE, false, "cannot be stacked");
        this.addItemAttribute(StandardAttributes.NOT_STACKABLE, true, "can be stacked");
        this.addItemAttribute(StandardAttributes.PLACEABLE, false, "is placeable");
        this.addItemAttribute(StandardAttributes.PLACEABLE, true, "is not placeable");
        this.addItemAttribute(StandardAttributes.RENAMED, false, "has a custom name");
        this.addItemAttribute(StandardAttributes.RENAMED, true, "does not have a custom name");
        this.addItemAttribute(StandardAttributes.SMELTABLE, false, "can be Smelted");
        this.addItemAttribute(StandardAttributes.SMELTABLE, true, "cannot be Smelted");
        this.addItemAttribute(StandardAttributes.SMOKABLE, false, "can be Smoked");
        this.addItemAttribute(StandardAttributes.SMOKABLE, true, "cannot be Smoked");
    }

    protected void addItemAttribute(ItemAttribute attribute, boolean inverted, String text) {
        this.add("item_attributes." + attribute.getTranslationKey() + (inverted ? ".inverted" : ""), text);
    }

    private void addConfigurationTranslations() {
        this.addConfig("recipes", "Recipe Settings");
        this.addConfig("sulfurSourceToBlockMapping", "Sulfur Source to Block Mapping");
        this.addConfig("rendering", "Rendering Settings");
        this.addConfig("renderSulfurSourceItem", "Render Sulfur Source Items");
        this.addConfig("enableItemHUD", "Enable Item HUD");
        this.addConfig("hudScale", "HUD Scale");
        this.addConfig("misc", "Misc Settings");
    }

    private void addConfig(String key, String name) {
        this.add("theurgy.configuration." + key, name);
    }

    protected void addTranslations() {
        this.addMisc();
        this.addKeys();
        this.addSubtitles();
        this.addMessages();
        this.addItems();
        this.addBlocks();
        this.addFluids();
        this.addIntegrations();
        this.addBehaviours();
        this.addGui();
        this.addItemAttributes();
        this.addConfigurationTranslations();
    }

    @Override
    public void add(String key, String name) {
        super.add(key, name);
    }
}

