/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.client.gui;

import com.github.yimeng261.maidspell.client.KeyBinds;
import com.github.yimeng261.maidspell.item.bauble.enderPocket.EnderPocketService;
import com.github.yimeng261.maidspell.network.message.C2SEnderPocketOpenInventory;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnderPocketScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("touhou_little_maid_spell", "textures/gui/ender_pocket.png");
    private List<EnderPocketService.EnderPocketMaidInfo> maidInfos;
    private static final int GUI_WIDTH = 90;
    private static final int GUI_HEIGHT = 153;

    public EnderPocketScreen(List<EnderPocketService.EnderPocketMaidInfo> maidInfos) {
        super((Component)Component.translatable((String)"gui.maidspell.ender_pocket.title"));
        this.maidInfos = maidInfos;
    }

    public void updateMaidInfos(List<EnderPocketService.EnderPocketMaidInfo> newMaidInfos) {
        this.maidInfos = newMaidInfos;
        this.init();
    }

    protected void init() {
        super.init();
        this.clearWidgets();
        int startX = (this.width - 90) / 2;
        int startY = (this.height - 153) / 2;
        for (int i = 0; i < this.maidInfos.size() && i < 8; ++i) {
            EnderPocketService.EnderPocketMaidInfo maidInfo = this.maidInfos.get(i);
            int buttonX = startX + 6;
            int buttonHeight = 16;
            int buttonY = startY + 16 + i * buttonHeight;
            int buttonWidth = 78;
            TransparentButton maidButton = new TransparentButton(buttonX, buttonY, buttonWidth, buttonHeight, (Component)Component.literal((String)maidInfo.maidName), button -> this.openMaidInventory(maidInfo.maidEntityId));
            this.addRenderableWidget((GuiEventListener)maidButton);
        }
    }

    private void openMaidInventory(int maidEntityId) {
        this.getMinecraft().getConnection().send((CustomPacketPayload)new C2SEnderPocketOpenInventory(maidEntityId));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 || KeyBinds.OPEN_ENDER_POCKET_GUI.getKey().getValue() == keyCode) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderGui(guiGraphics);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    private void renderGui(GuiGraphics guiGraphics) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int startX = (this.width - 90) / 2;
        int startY = (this.height - 153) / 2;
        guiGraphics.blit(BACKGROUND_TEXTURE, startX, startY, 0, 0, 90, 153);
        int titleX = this.width / 2 - this.font.width((FormattedText)this.title) / 2;
        guiGraphics.drawString(this.font, this.title, titleX, startY + 6, 0x404040, false);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public static class TransparentButton
    extends Button {
        public TransparentButton(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
            super(x, y, width, height, message, onPress, DEFAULT_NARRATION);
        }

        public void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.isHovered()) {
                guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -2130706433);
                guiGraphics.renderOutline(this.getX(), this.getY(), this.width, this.height, -1);
            }
            int textColor = this.active ? 0xFFFFFF : 0xA0A0A0;
            guiGraphics.drawCenteredString(Minecraft.getInstance().font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, textColor);
        }
    }
}

