/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.debug;

import com.github.yimeng261.maidspell.utils.TrueDamageUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.slf4j.Logger;

@EventBusSubscriber
public class TrueDamageDebugCommand {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"truedamage").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"setHealth").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"health", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            Entity entity = EntityArgument.getEntity((CommandContext)context, (String)"target");
            float health = FloatArgumentType.getFloat((CommandContext)context, (String)"health");
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.setHealth(health);
            }
            return 0;
        }))))).then(Commands.literal((String)"deal").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"damage", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(context -> {
            try {
                Entity entity = EntityArgument.getEntity((CommandContext)context, (String)"target");
                float damage = FloatArgumentType.getFloat((CommandContext)context, (String)"damage");
                if (!(entity instanceof LivingEntity)) {
                    ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"\u76ee\u6807\u5fc5\u987b\u662f\u751f\u7269\u5b9e\u4f53"));
                    return 0;
                }
                LivingEntity target = (LivingEntity)entity;
                float oldHealth = target.getHealth();
                TrueDamageUtil.dealTrueDamage(target, damage, (LivingEntity)((CommandSourceStack)context.getSource()).getPlayer());
                float newHealth = target.getHealth();
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.format("\u5bf9 %s \u9020\u6210 %.1f \u771f\u5b9e\u4f24\u5bb3\uff0c\u5065\u5eb7\u503c\u4ece %.1f \u53d8\u4e3a %.1f", target.getName().getString(), Float.valueOf(damage), Float.valueOf(oldHealth), Float.valueOf(newHealth))), true);
                return 1;
            }
            catch (Exception e) {
                LOGGER.error("\u6267\u884c\u771f\u5b9e\u4f24\u5bb3\u547d\u4ee4\u65f6\u51fa\u9519", (Throwable)e);
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("\u547d\u4ee4\u6267\u884c\u5931\u8d25: " + e.getMessage())));
                return 0;
            }
        }))))).then(Commands.literal((String)"entitydata").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).executes(context -> {
            try {
                String[] lines;
                Entity entity = EntityArgument.getEntity((CommandContext)context, (String)"target");
                if (!(entity instanceof LivingEntity)) {
                    ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"\u76ee\u6807\u5fc5\u987b\u662f\u751f\u7269\u5b9e\u4f53"));
                    return 0;
                }
                LivingEntity target = (LivingEntity)entity;
                String info = TrueDamageUtil.getEntityDataInfo(target);
                for (String line : lines = info.split("\n")) {
                    if (line.trim().isEmpty()) continue;
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)line), false);
                }
                return 1;
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u5b9e\u4f53\u6570\u636e\u4fe1\u606f\u65f6\u51fa\u9519", (Throwable)e);
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("\u83b7\u53d6\u4fe1\u606f\u5931\u8d25: " + e.getMessage())));
                return 0;
            }
        }))));
    }
}

