/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.blueNote;

import com.github.yimeng261.maidspell.item.bauble.blueNote.contianer.BlueNoteContainerProvider;
import com.github.yimeng261.maidspell.item.bauble.blueNote.contianer.BlueNoteSpellManager;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemStackHandler;

public class BlueNote
extends Item {
    public BlueNote() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC));
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int slot = hand == InteractionHand.MAIN_HAND ? player.getInventory().selected : 40;
            this.openGUI(serverPlayer, stack, slot);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
    }

    private void openGUI(ServerPlayer player, ItemStack blueNoteStack, int slot) {
        ItemStackHandler scrollHandler = new ItemStackHandler(27);
        BlueNoteSpellManager.loadScrollsFromItem(blueNoteStack, scrollHandler);
        player.openMenu((MenuProvider)new BlueNoteContainerProvider(scrollHandler, blueNoteStack, slot), buf -> {
            buf.writeInt(slot);
            ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)blueNoteStack);
        });
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)"item.maidspell.blue_note.desc1").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.maidspell.blue_note.desc2").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"item.maidspell.blue_note.desc3").withStyle(ChatFormatting.YELLOW));
    }
}

