/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.blueNote.contianer;

import com.github.yimeng261.maidspell.item.MaidSpellDataComponents;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellSlot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class BlueNoteSpellManager {
    public static void loadScrollsFromItem(ItemStack blueNoteStack, ItemStackHandler scrollHandler) {
        int i;
        if (blueNoteStack.isEmpty()) {
            return;
        }
        List scrollsList = (List)blueNoteStack.get(MaidSpellDataComponents.BLUE_NOTE_SCROLLS_TAG);
        if (scrollsList == null) {
            return;
        }
        for (i = 0; i < scrollHandler.getSlots(); ++i) {
            scrollHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
        for (i = 0; i < scrollsList.size() && i < scrollHandler.getSlots(); ++i) {
            ItemStack scroll = (ItemStack)scrollsList.get(i);
            if (scroll.isEmpty()) continue;
            scrollHandler.setStackInSlot(i, scroll);
        }
    }

    public static void saveScrollsToItem(ItemStack blueNoteStack, ItemStackHandler scrollHandler) {
        if (blueNoteStack.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> scrollsList = new ArrayList<ItemStack>();
        for (int i = 0; i < scrollHandler.getSlots(); ++i) {
            ItemStack scroll = scrollHandler.getStackInSlot(i);
            if (!scroll.isEmpty()) {
                scrollsList.add(scroll);
                continue;
            }
            scrollsList.add(ItemStack.EMPTY);
        }
        blueNoteStack.set(MaidSpellDataComponents.BLUE_NOTE_SCROLLS_TAG, scrollsList);
        BlueNoteSpellManager.saveSpellIdsToItem(blueNoteStack, scrollHandler);
    }

    public static void saveSpellIdsToItem(ItemStack blueNoteStack, ItemStackHandler scrollHandler) {
        if (blueNoteStack.isEmpty()) {
            return;
        }
        List<String> spellIds = BlueNoteSpellManager.extractSpellIdsFromScrolls(scrollHandler);
        blueNoteStack.set(MaidSpellDataComponents.BLUE_NOTE_SPELL_IDS_TAG, spellIds);
    }

    private static List<String> extractSpellIdsFromScrolls(ItemStackHandler scrollHandler) {
        ArrayList<String> spellIds = new ArrayList<String>();
        for (int i = 0; i < scrollHandler.getSlots(); ++i) {
            SpellSlot[] scrollSpells;
            ISpellContainer container;
            ItemStack stack = scrollHandler.getStackInSlot(i);
            if (stack.isEmpty() || !ISpellContainer.isSpellContainer((ItemStack)stack) || (container = ISpellContainer.get((ItemStack)stack)).isEmpty()) continue;
            for (SpellSlot spellSlot : scrollSpells = container.getAllSpells()) {
                if (spellSlot == null || spellSlot.getSpell() == null) continue;
                spellIds.add(spellSlot.getSpell().getSpellId());
            }
        }
        return spellIds;
    }

    public static List<String> getStoredSpellIds(ItemStack blueNoteStack) {
        ArrayList<String> spellIds = new ArrayList<String>();
        if (blueNoteStack.isEmpty()) {
            return spellIds;
        }
        return (List)blueNoteStack.getOrDefault(MaidSpellDataComponents.BLUE_NOTE_SPELL_IDS_TAG, spellIds);
    }

    public static void clearStoredData(ItemStack blueNoteStack) {
        if (!blueNoteStack.isEmpty()) {
            blueNoteStack.remove(MaidSpellDataComponents.BLUE_NOTE_SCROLLS_TAG);
            blueNoteStack.remove(MaidSpellDataComponents.BLUE_NOTE_SPELL_IDS_TAG);
        }
    }
}

