/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.enderPocket;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.client.event.MaidBackpackEnderPocketIntegration;
import com.github.yimeng261.maidspell.item.bauble.enderPocket.EnderPocketService;
import com.github.yimeng261.maidspell.network.message.S2CEnderPocketPushUpdate;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EnderPocketBauble
implements IMaidBauble {
    public void onPutOn(EntityMaid maid, ItemStack baubleItem) {
        try {
            LivingEntity livingEntity;
            if (maid.level().isClientSide()) {
                ClientHandler.handleBaubleChange();
            }
            if (!maid.level().isClientSide() && (livingEntity = maid.getOwner()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                this.pushEnderPocketDataToClient(player);
            }
        }
        catch (Exception e) {
            Global.LOGGER.error("Failed to handle ender pocket bauble add for maid: {}", (Object)maid.getName().getString(), (Object)e);
        }
    }

    public void onTakeOff(EntityMaid maid, ItemStack baubleItem) {
        try {
            LivingEntity livingEntity;
            if (maid.level().isClientSide()) {
                ClientHandler.handleBaubleChange();
            }
            if (!maid.level().isClientSide() && (livingEntity = maid.getOwner()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                this.pushEnderPocketDataToClient(player);
            }
        }
        catch (Exception e) {
            Global.LOGGER.error("Failed to handle ender pocket bauble remove for maid: {}", (Object)maid.getName().getString(), (Object)e);
        }
    }

    private void pushEnderPocketDataToClient(ServerPlayer player) {
        try {
            List<EnderPocketService.EnderPocketMaidInfo> maidInfos = EnderPocketService.getPlayerEnderPocketMaids(player);
            player.connection.send((CustomPacketPayload)new S2CEnderPocketPushUpdate(maidInfos, true));
        }
        catch (Exception e) {
            Global.LOGGER.error("Failed to push ender pocket data to client for player: {}", (Object)player.getName().getString(), (Object)e);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void handleBaubleChange() {
            try {
                Minecraft mc = Minecraft.getInstance();
                if (mc.getConnection() != null) {
                    MaidBackpackEnderPocketIntegration.forceRefreshData();
                }
            }
            catch (Exception e) {
                Global.LOGGER.error("Failed to handle bauble change on client side: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

