/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.soulBook;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Config;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

public class SoulBookBauble
implements IMaidBauble {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<UUID, Integer> lastHurtTimeMap = new HashMap<UUID, Integer>();
    public static final Map<UUID, Integer> maidSoulBookCount = new HashMap<UUID, Integer>();

    public static Pair<Boolean, Float> damageCalc(EntityMaid maid, float originalDamage) {
        UUID maidId = maid.getUUID();
        int currentTime = maid.tickCount;
        int lastHurtTime = lastHurtTimeMap.computeIfAbsent(maidId, uuid -> maid.tickCount);
        int timeDiff = currentTime - lastHurtTime;
        float damageThreshold = Math.min(originalDamage, maid.getMaxHealth() * (float)Config.soulBookDamageThresholdPercent);
        return new Pair((Object)(timeDiff > Config.soulBookDamageIntervalThreshold ? 1 : 0), (Object)Float.valueOf(damageThreshold));
    }

    public void onPutOn(EntityMaid maid, ItemStack baubleItem) {
        UUID id = maid.getOwnerUUID();
        int count = maidSoulBookCount.getOrDefault(id, 0);
        maidSoulBookCount.put(id, ++count);
    }

    public void onTakeOff(EntityMaid maid, ItemStack baubleItem) {
        UUID maidId = maid.getUUID();
        lastHurtTimeMap.remove(maidId);
        UUID id = maid.getOwnerUUID();
        int count = maidSoulBookCount.getOrDefault(id, 0);
        maidSoulBookCount.put(id, Math.max(0, count - 1));
    }
}

