/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.spellCore;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.slf4j.Logger;

public class SpellEnhancementBauble
implements IMaidBauble {
    private static final List<AttributeConfig> ATTRIBUTES = new ArrayList<AttributeConfig>();
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void initializeAttributes(RegisterEvent event) {
        Registry registry = event.getRegistry(Registries.ATTRIBUTE);
        if (registry == null) {
            return;
        }
        for (Map.Entry entry : registry.entrySet()) {
            ResourceLocation id = ((ResourceKey)entry.getKey()).location();
            Attribute attribute = (Attribute)entry.getValue();
            if (!"irons_spellbooks".equals(id.getNamespace())) continue;
            double defaultValue = attribute.getDefaultValue();
            ATTRIBUTES.add(new AttributeConfig((Holder<Attribute>)registry.wrapAsHolder((Object)attribute), defaultValue, ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid_spell", (String)id.getPath())));
        }
    }

    public void onTick(EntityMaid maid, ItemStack baubleItem) {
        if (maid.level().isClientSide || maid.tickCount % 40 != 0) {
            return;
        }
        LivingEntity owner = maid.getOwner();
        if (!(owner instanceof Player)) {
            return;
        }
        Player player = (Player)owner;
        this.updateMaidEnhancements(maid, player);
    }

    private void updateMaidEnhancements(EntityMaid maid, Player player) {
        for (AttributeConfig config : ATTRIBUTES) {
            double bonus = 0.0;
            if (player != null) {
                double playerValue = player.getAttributeValue(config.attribute);
                bonus = Math.max(0.0, playerValue - config.defaultValue);
            }
            AttributeInstance maidAttr = maid.getAttribute(config.attribute);
            AttributeModifier modifier = new AttributeModifier(config.renamedId, bonus, AttributeModifier.Operation.ADD_VALUE);
            if (maidAttr == null) {
                return;
            }
            if (config.renamedId != null) {
                maidAttr.removeModifier(config.renamedId);
            }
            config.renamedId = modifier.id();
            maidAttr.addTransientModifier(modifier);
        }
    }

    private void clearAllEnhancements(EntityMaid maid) {
        for (AttributeConfig config : ATTRIBUTES) {
            AttributeInstance maidAttr = maid.getAttribute(config.attribute);
            if (maidAttr == null || config.renamedId == null) continue;
            maidAttr.removeModifier(config.renamedId);
            LOGGER.debug("Removed modifier {} for attribute {} from maid {}", new Object[]{config.renamedId, config.attribute.getKey(), maid.getName().getString()});
        }
    }

    private static class AttributeConfig {
        final Holder<Attribute> attribute;
        final double defaultValue;
        ResourceLocation renamedId;

        AttributeConfig(Holder<Attribute> attribute, double defaultValue, ResourceLocation renamedId) {
            this.attribute = attribute;
            this.defaultValue = defaultValue;
            this.renamedId = renamedId;
        }
    }
}

