/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.common.WindSeekingBell;

import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.entity.WindSeekingBellEntity;
import com.github.yimeng261.maidspell.item.common.WindSeekingBell.BiomeValidator;
import com.github.yimeng261.maidspell.item.common.WindSeekingBell.SearchCacheManager;
import com.github.yimeng261.maidspell.item.common.WindSeekingBell.StructureSearchEngine;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import org.jetbrains.annotations.NotNull;

public class WindSeekingBell
extends Item {
    private static final Component NO_STRUCTURE_MESSAGE = Component.translatable((String)"item.touhou_little_maid_spell.wind_seeking_bell.no_structure").withStyle(ChatFormatting.RED);
    private static final Component CLICK_SUGGEST_MESSAGE = Component.translatable((String)"item.touhou_little_maid_spell.wind_seeking_bell.click_to_suggest").withStyle(ChatFormatting.YELLOW);
    private static final SearchCacheManager cacheManager = new SearchCacheManager();
    private static final BiomeValidator biomeValidator = new BiomeValidator();
    private static final StructureSearchEngine searchEngine = new StructureSearchEngine(biomeValidator, cacheManager);

    public WindSeekingBell() {
        super(new Item.Properties().stacksTo(16).rarity(Rarity.UNCOMMON));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos playerPos = player.blockPosition();
            this.findNearestHiddenRetreatAsync(serverLevel, playerPos, player, itemStack);
            return InteractionResultHolder.success((Object)itemStack);
        }
        return InteractionResultHolder.consume((Object)itemStack);
    }

    private void findNearestHiddenRetreatAsync(ServerLevel serverLevel, BlockPos playerPos, Player player, ItemStack itemStack) {
        long searchStartTime = System.currentTimeMillis();
        searchEngine.searchAsync(serverLevel, playerPos).thenAccept(result -> {
            long searchTime = System.currentTimeMillis() - searchStartTime;
            this.handleSearchResult(serverLevel, playerPos, player, itemStack, (BlockPos)result, searchTime);
        });
    }

    private void handleSearchResult(ServerLevel serverLevel, BlockPos playerPos, Player player, ItemStack itemStack, BlockPos structurePos, long searchTime) {
        serverLevel.getServer().execute(() -> {
            if (structurePos != null) {
                ServerPlayer serverPlayer;
                int count;
                int height = serverLevel.getChunkSource().getGenerator().getFirstOccupiedHeight(structurePos.getX(), structurePos.getZ(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, serverLevel.getChunk(structurePos).getHeightAccessorForGeneration(), serverLevel.getChunkSource().randomState());
                BlockPos structurePosVec3i = new BlockPos(structurePos.getX(), 0, structurePos.getZ());
                BlockPos playerPosVec3i = new BlockPos(playerPos.getX(), 0, playerPos.getZ());
                WindSeekingBellEntity windSeekingBell = new WindSeekingBellEntity((Level)serverLevel, player);
                ItemStack newItemStack = itemStack.copy();
                newItemStack.setCount(1);
                windSeekingBell.setItem(newItemStack);
                windSeekingBell.signalTo(structurePosVec3i.above(height + 3));
                serverLevel.addFreshEntity((Entity)windSeekingBell);
                int distance = (int)Math.sqrt(structurePosVec3i.distSqr((Vec3i)playerPosVec3i));
                String tpCommand = String.format("/tp %f %d %f", (double)structurePos.getX() + 0.5, height + 3, (double)structurePos.getZ() + 0.5);
                MutableComponent coordinateMessage = Component.translatable((String)"item.touhou_little_maid_spell.wind_seeking_bell.found_structure", (Object[])new Object[]{structurePos.getX(), height, structurePos.getZ(), distance}).withStyle(ChatFormatting.GREEN).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, tpCommand)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)CLICK_SUGGEST_MESSAGE)));
                MutableComponent timingMessage = Component.translatable((String)"item.touhou_little_maid_spell.wind_seeking_bell.search_time", (Object[])new Object[]{searchTime}).withStyle(ChatFormatting.AQUA);
                player.sendSystemMessage((Component)coordinateMessage);
                player.sendSystemMessage((Component)timingMessage);
                if (player instanceof ServerPlayer && (count = (serverPlayer = (ServerPlayer)player).getStats().getValue(Stats.ITEM_USED.get((Object)this))) == 0) {
                    serverPlayer.sendSystemMessage((Component)Component.translatable((String)"item.touhou_little_maid_spell.wind_seeking_bell.first_use").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
            } else {
                MutableComponent timingMessage = Component.translatable((String)"item.touhou_little_maid_spell.wind_seeking_bell.search_time", (Object[])new Object[]{searchTime}).withStyle(ChatFormatting.GREEN);
                player.displayClientMessage(NO_STRUCTURE_MESSAGE, true);
                player.sendSystemMessage((Component)timingMessage);
            }
        });
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)"item.touhou_little_maid_spell.wind_seeking_bell.desc1").withStyle(ChatFormatting.LIGHT_PURPLE));
        tooltip.add((Component)Component.translatable((String)"item.touhou_little_maid_spell.wind_seeking_bell.desc2").withStyle(ChatFormatting.GOLD));
    }

    public boolean isFoil(@Nonnull ItemStack stack) {
        return true;
    }

    public static void clearAllCaches() {
        cacheManager.clearAll();
        StructureSearchEngine.clearCaches();
        Global.LOGGER.debug("WindSeekingBell: All caches cleared");
    }

    @EventBusSubscriber(modid="touhou_little_maid_spell")
    public static class ServerEventHandler {
        @SubscribeEvent
        public static void onServerStarted(ServerStartedEvent event) {
            WindSeekingBell.clearAllCaches();
            Global.LOGGER.info("WindSeekingBell: Cleared caches on server startup");
            Global.LOGGER.info("WindSeekingBell: Using striped lock with {} segments for improved concurrency", (Object)64);
        }

        @SubscribeEvent
        public static void onServerStopped(ServerStoppedEvent event) {
            WindSeekingBell.clearAllCaches();
            Global.LOGGER.info("WindSeekingBell: Cleared caches on server shutdown");
        }
    }
}

