/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.mixin;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.spell.manager.BaubleStateManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class}, remap=false)
public class EntityMixin {
    @Inject(method={"save(Lnet/minecraft/nbt/CompoundTag;)Z"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    public void onSave(CompoundTag pCompound, CallbackInfoReturnable<Boolean> cir) {
        try {
            EntityMixin entityMixin = this;
            if (entityMixin instanceof EntityMaid) {
                StackTraceElement[] stackTrace;
                EntityMaid maid = (EntityMaid)entityMixin;
                if (!BaubleStateManager.hasBauble(maid, MaidSpellItems.ANCHOR_CORE)) {
                    Global.LOGGER.debug("Maid {} does not have anchor_core, allowing save", (Object)maid.getUUID());
                    return;
                }
                for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
                    String className = stackTraceElement.getClassName();
                    if (className.startsWith("net.minecraft") || className.startsWith("java") || className.startsWith("it.unimi.dsi") || className.startsWith("com.github.tartaricacid") || className.startsWith("com.github.yimeng261") || className.startsWith("com.google") || className.startsWith("com.mojang") || className.contains("backup") || className.contains("maid")) continue;
                    cir.setReturnValue((Object)false);
                    Global.LOGGER.debug("[MaidSpell] Illegal Save called for {} (anchor_core protection)", (Object)maid);
                    return;
                }
            }
        }
        catch (Exception e) {
            Global.LOGGER.error("Failed to check maid save source", (Throwable)e);
        }
    }
}

