/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Config;
import com.github.yimeng261.maidspell.api.ISpellBookProvider;
import com.github.yimeng261.maidspell.spell.manager.SpellBookManager;
import com.mojang.logging.LogUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;

public class SimplifiedSpellCaster {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final EntityMaid maid;
    private LivingEntity target;
    public static double MELEE_RANGE;
    public static double FAR_RANGE;
    private final SpellBookManager spellBookManager;

    public SimplifiedSpellCaster(EntityMaid maid) {
        this.maid = maid;
        this.spellBookManager = SpellBookManager.getOrCreateManager(maid);
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
        if (this.spellBookManager != null) {
            for (ISpellBookProvider<?, ?> provider : this.spellBookManager.getProviders()) {
                provider.setTarget(this.maid, target);
            }
        }
    }

    public boolean hasValidTarget() {
        return this.target != null && this.target.isAlive();
    }

    public void melee_tick() {
        if (!this.hasValidTarget()) {
            return;
        }
        if (this.maid.tickCount % Config.meleeAttackInterval == 0) {
            SimplifiedSpellCaster.clearLookTarget(this.maid);
            double distance = this.maid.distanceTo((Entity)this.target);
            this.executeCombat(distance);
        }
    }

    public void far_tick() {
        if (!this.hasValidTarget()) {
            return;
        }
        if (this.maid.tickCount % Config.farAttackInterval == 0) {
            SimplifiedSpellCaster.clearLookTarget(this.maid);
            this.executeCombatFar();
        }
    }

    public static void clearLookTarget(EntityMaid maid) {
        maid.getBrain().getMemory(MemoryModuleType.LOOK_TARGET).ifPresent(lookTarget -> {
            EntityTracker tracker;
            if (lookTarget instanceof EntityTracker && (tracker = (EntityTracker)lookTarget).getEntity() instanceof Player) {
                maid.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
            }
        });
    }

    private void executeCombat(double distance) {
        if (this.target == null) {
            return;
        }
        this.target.invulnerableTime = 0;
        if (this.spellBookManager != null) {
            this.spellBookManager.castSpell(this.maid);
        }
        if (distance <= MELEE_RANGE + 1.0) {
            this.maid.doHurtTarget((Entity)this.target);
            this.maid.swing(InteractionHand.MAIN_HAND);
        }
    }

    private void executeCombatFar() {
        if (this.target == null) {
            return;
        }
        this.target.invulnerableTime = 0;
        if (this.spellBookManager != null) {
            this.spellBookManager.castSpell(this.maid);
        }
    }
}

