/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.providers;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.api.ISpellBookProvider;
import com.github.yimeng261.maidspell.spell.data.MaidArsNouveauSpellData;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class ArsNouveauProvider
extends ISpellBookProvider<MaidArsNouveauSpellData, Spell> {
    private static final Logger LOGGER = LogUtils.getLogger();

    public ArsNouveauProvider() {
        super(MaidArsNouveauSpellData::getOrCreate, Spell.class);
    }

    @Override
    protected List<Spell> collectSpellFromSingleSpellBook(ItemStack spellBook, EntityMaid maid) {
        ArrayList<Spell> spells = new ArrayList<Spell>();
        if (spellBook == null || spellBook.isEmpty() || !this.isSpellBook(spellBook)) {
            return spells;
        }
        AbstractCaster caster = SpellCasterRegistry.from((ItemStack)spellBook);
        if (caster == null) {
            return spells;
        }
        for (int i = 0; i < caster.getMaxSlots(); ++i) {
            Spell spell = caster.getSpell(i);
            if (spell == null || !spell.isValid() || spell.isEmpty()) continue;
            spells.add(spell);
        }
        return spells;
    }

    @Override
    public boolean isSpellBook(ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            return false;
        }
        return itemStack.getItem() instanceof SpellBook;
    }

    @Override
    public void initiateCasting(EntityMaid maid) {
        MaidArsNouveauSpellData data = (MaidArsNouveauSpellData)this.getData(maid);
        this.ensureManaCapability(maid);
        Spell spell = this.selectRandomSpell(maid);
        if (spell == null) {
            return;
        }
        LivingEntity target = data.getTarget();
        if (target != null) {
            BehaviorUtils.lookAtEntity((LivingEntity)maid, (LivingEntity)target);
        }
        data.setCasting(true);
        data.setCastingTicks(0);
        data.setCurrentSpell(spell);
        data.setSpellCooldown(spell.name(), spell.getCost() / 2, maid);
        maid.swing(InteractionHand.MAIN_HAND);
    }

    @Override
    public void processContinuousCasting(EntityMaid maid) {
        MaidArsNouveauSpellData data = (MaidArsNouveauSpellData)this.getData(maid);
        if (data == null || !data.isCasting() || data.getCurrentSpell() == null) {
            return;
        }
        data.incrementCastingTicks();
        LivingEntity target = data.getTarget();
        if (target != null) {
            BehaviorUtils.lookAtEntity((LivingEntity)maid, (LivingEntity)target);
        }
        if (data.isCastingComplete()) {
            this.completeCasting(maid);
        }
    }

    @Override
    public void stopCasting(EntityMaid maid) {
        MaidArsNouveauSpellData data = (MaidArsNouveauSpellData)this.getData(maid);
        if (data == null || !data.isCasting()) {
            return;
        }
        data.resetCastingState();
    }

    private void ensureManaCapability(EntityMaid maid) {
        if (maid == null) {
            return;
        }
        ManaCap manaCap = CapabilityRegistry.getMana((LivingEntity)maid);
        if (manaCap == null) {
            return;
        }
        if (manaCap.getCurrentMana() < 1000.0) {
            manaCap.setMana(1000.0);
        }
    }

    private List<Spell> getAvailableSpells(EntityMaid maid) {
        MaidArsNouveauSpellData data = (MaidArsNouveauSpellData)this.getData(maid);
        List allSpells = this.collectSpellFromAvailableSpellBooks(maid);
        ArrayList<Spell> availableSpells = new ArrayList<Spell>();
        for (Spell spell : allSpells) {
            if (data.isSpellOnCooldown(spell.name())) continue;
            availableSpells.add(spell);
        }
        return availableSpells;
    }

    private Spell selectRandomSpell(EntityMaid maid) {
        List<Spell> availableSpells = this.getAvailableSpells(maid);
        if (availableSpells.isEmpty()) {
            return null;
        }
        int randomIndex = (int)(Math.random() * (double)availableSpells.size());
        return availableSpells.get(randomIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeCasting(EntityMaid maid) {
        MaidArsNouveauSpellData data = (MaidArsNouveauSpellData)this.getData(maid);
        try {
            this.ensureManaCapability(maid);
            LivingCaster wrappedCaster = new LivingCaster((LivingEntity)maid);
            SpellContext context = new SpellContext(maid.level(), data.getCurrentSpell(), (LivingEntity)maid, (IWrappedCaster)wrappedCaster, data.getSpellBook());
            SpellResolver resolver = new SpellResolver(this, context){

                protected boolean enoughMana(LivingEntity entity) {
                    return true;
                }

                public void expendMana() {
                }
            };
            LivingEntity target = data.getTarget();
            if (target != null) {
                Vec3 targetPos = target.getEyePosition();
                Vec3 maidPos = maid.getEyePosition();
                Vec3 direction = targetPos.subtract(maidPos).normalize();
                float yaw = (float)(Math.atan2(direction.x, direction.z) * 180.0 / Math.PI);
                float pitch = (float)(Math.asin(-direction.y) * 180.0 / Math.PI);
                maid.setYRot(yaw);
                maid.setXRot(pitch);
                maid.yRotO = yaw;
                maid.xRotO = pitch;
                if (data.getCurrentSpell().getCastMethod() instanceof MethodProjectile) {
                    try {
                        EntityProjectileSpell projectile = new EntityProjectileSpell(maid.level(), resolver);
                        projectile.setOwner((Entity)maid);
                        projectile.setPos(maidPos.x, maidPos.y - 0.1, maidPos.z);
                        float velocity = Math.max(0.1f, 0.75f + resolver.getCastStats().getAccMultiplier() / 2.0f);
                        projectile.shoot(direction.x, direction.y, direction.z, velocity, 0.0f);
                        maid.level().addFreshEntity((Entity)projectile);
                    }
                    catch (Exception e) {
                        resolver.onCastOnEntity(data.getSpellBook(), (Entity)target, InteractionHand.MAIN_HAND);
                    }
                } else {
                    resolver.hitResult = new EntityHitResult((Entity)target, targetPos);
                    resolver.onCastOnEntity(data.getSpellBook(), (Entity)target, InteractionHand.MAIN_HAND);
                }
            } else {
                EntityHitResult entityHitResult;
                boolean isSensitive = data.getCurrentSpell().getBuffsAtIndex(0, (LivingEntity)maid, (AbstractAugment)AugmentSensitive.INSTANCE) > 0;
                HitResult result = SpellUtil.rayTrace((Entity)maid, (double)5.5, (float)0.0f, (boolean)isSensitive);
                if (result instanceof EntityHitResult && (entityHitResult = (EntityHitResult)result).getEntity() instanceof LivingEntity) {
                    resolver.onCastOnEntity(data.getSpellBook(), entityHitResult.getEntity(), InteractionHand.MAIN_HAND);
                } else if (result instanceof BlockHitResult) {
                    BlockHitResult blockHitResult = (BlockHitResult)result;
                    resolver.onCastOnBlock(blockHitResult);
                } else {
                    resolver.onCast(data.getSpellBook(), maid.level());
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            data.resetCastingState();
        }
    }
}

