/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.providers;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.github.yimeng261.maidspell.api.ISpellBookProvider;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.item.bauble.blueNote.BlueNote;
import com.github.yimeng261.maidspell.item.bauble.blueNote.contianer.BlueNoteSpellManager;
import com.github.yimeng261.maidspell.spell.data.MaidIronsSpellData;
import com.github.yimeng261.maidspell.spell.manager.BaubleStateManager;
import com.mojang.logging.LogUtils;
import io.redspace.ironsspellbooks.api.item.weapons.MagicSwordItem;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellSlot;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.spells.target_area.TargetedAreaEntity;
import io.redspace.ironsspellbooks.spells.TargetAreaCastData;
import io.redspace.ironsspellbooks.spells.ender.TeleportSpell;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class IronsSpellbooksProvider
extends ISpellBookProvider<MaidIronsSpellData, SpellSlot> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final List<String> spellBlacklist = List.of("irons_spellbooks:spectral_hammer");

    public IronsSpellbooksProvider() {
        super(MaidIronsSpellData::getOrCreate, SpellSlot.class);
    }

    @Override
    protected List<SpellSlot> collectSpellFromSingleSpellBook(ItemStack spellBook, EntityMaid maid) {
        ArrayList<SpellSlot> spells = new ArrayList<SpellSlot>();
        ISpellContainer spellContainer = ISpellContainer.get((ItemStack)spellBook);
        if (spellContainer.isEmpty()) {
            return spells;
        }
        return spellContainer.getActiveSpells();
    }

    @Override
    public boolean isSpellBook(ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            return false;
        }
        return ISpellContainer.isSpellContainer((ItemStack)itemStack);
    }

    @Override
    public void initiateCasting(EntityMaid maid) {
        MaidIronsSpellData data = (MaidIronsSpellData)this.getData(maid);
        if (data == null) {
            return;
        }
        if (data.getSpellBooks().isEmpty()) {
            return;
        }
        List availableSpells = this.collectSpellFromAvailableSpellBooks(maid);
        availableSpells.removeIf(spellData -> {
            if (spellData == null || spellData.getSpell() == null) {
                return true;
            }
            String spellId = spellData.getSpell().getSpellId();
            if (data.isSpellOnCooldown(spellId)) {
                return true;
            }
            if (spellBlacklist.contains(spellId)) {
                LOGGER.debug("\u6cd5\u672f {} \u5728\u9ed1\u540d\u5355\u4e2d\uff0c\u5973\u4ec6 {} \u8df3\u8fc7\u65bd\u653e", (Object)spellId, (Object)maid.getUUID());
                return true;
            }
            return false;
        });
        if (availableSpells.isEmpty()) {
            return;
        }
        int index = (int)(Math.random() * (double)availableSpells.size());
        SpellSlot spellData2 = (SpellSlot)availableSpells.get(index);
        if (BaubleStateManager.hasBauble(maid, MaidSpellItems.BLUE_NOTE)) {
            ItemStack bauble = null;
            BaubleItemHandler baubleItemHandler = maid.getMaidBauble();
            for (int i = 0; i < baubleItemHandler.getSlots() && !((bauble = baubleItemHandler.getStackInSlot(i)).getItem() instanceof BlueNote); ++i) {
            }
            if (bauble != null && BlueNoteSpellManager.getStoredSpellIds(bauble).contains(spellData2.getSpell().getSpellId())) {
                LOGGER.debug("should cast to owner : {}", (Object)spellData2.getSpell().getSpellId());
                data.switchTargetToOwner(maid);
            }
        }
        this.actualCasting(maid, spellData2);
    }

    private void actualCasting(EntityMaid maid, SpellSlot spellData) {
        MaidIronsSpellData data = (MaidIronsSpellData)this.getData(maid);
        try {
            AbstractSpell spell = spellData.getSpell();
            this.forceLookAtTarget(maid, data);
            this.setupSpellTargetData(maid, spell);
            MagicData magicData = data.getMagicData();
            if (!spell.checkPreCastConditions(maid.level(), spellData.getLevel(), (LivingEntity)maid, magicData)) {
                LOGGER.debug("spell check failed : {}", (Object)spellData.getSpell().getSpellId());
                return;
            }
            int effectiveCastTime = spell.getEffectiveCastTime(spellData.getLevel(), (LivingEntity)maid);
            CastSource castSource = this.getCastSource(data, spellData);
            magicData.initiateCast(spell, spellData.getLevel(), effectiveCastTime, castSource, "offhand");
            spell.onServerPreCast(maid.level(), spellData.getLevel(), (LivingEntity)maid, magicData);
            data.setCurrentCastingSpell(spellData);
            data.setCasting(true);
            maid.swing(maid.getUsedItemHand());
        }
        catch (Exception e) {
            LOGGER.debug("[MaidSpell] error: {}", (Object)e.getMessage());
            data.resetCastingState();
        }
    }

    @Override
    public void processContinuousCasting(EntityMaid maid) {
        int remaining;
        MaidIronsSpellData data = (MaidIronsSpellData)this.getData(maid);
        if (data == null || !data.isCasting() || data.getCurrentCastingSpell() == null) {
            return;
        }
        AbstractSpell spell = data.getCurrentCastingSpell().getSpell();
        MagicData magicData = data.getMagicData();
        this.forceLookAtTarget(maid, data);
        magicData.handleCastDuration();
        if (magicData.isCasting()) {
            spell.onServerCastTick(maid.level(), data.getCurrentCastingSpell().getLevel(), (LivingEntity)maid, magicData);
        }
        if ((remaining = magicData.getCastDurationRemaining()) <= 0) {
            this.completeCasting(maid);
        } else if (spell.getCastType() == CastType.CONTINUOUS && (remaining + 1) % 10 == 0) {
            CastSource castSource = this.getCastSource(data, data.getCurrentCastingSpell());
            spell.onCast(maid.level(), data.getCurrentCastingSpell().getLevel(), (LivingEntity)maid, castSource, magicData);
        }
    }

    private void forceLookAtTarget(EntityMaid maid, MaidIronsSpellData data) {
        LivingEntity target = data.getTarget();
        if (target != null) {
            if (target == maid.getOwner()) {
                LOGGER.debug("look at owner");
            }
            BehaviorUtils.lookAtEntity((LivingEntity)maid, (LivingEntity)target);
            maid.setYRot(Mth.rotateIfNecessary((float)maid.getYRot(), (float)maid.yHeadRot, (float)0.0f));
            maid.lookAt(EntityAnchorArgument.Anchor.EYES, target.getEyePosition());
        }
    }

    @Override
    public void stopCasting(EntityMaid maid) {
        MaidIronsSpellData data = (MaidIronsSpellData)this.getData(maid);
        if (data == null || !data.isCasting() || data.getCurrentCastingSpell() == null) {
            return;
        }
        this.forceCompleteCasting(maid);
    }

    private CastSource getCastSource(ItemStack spellContainer) {
        if (spellContainer == null || spellContainer.isEmpty()) {
            return CastSource.SPELLBOOK;
        }
        if (spellContainer.getItem() instanceof MagicSwordItem) {
            return CastSource.SWORD;
        }
        return CastSource.SPELLBOOK;
    }

    private CastSource getCastSource(MaidIronsSpellData data, SpellSlot currentSpell) {
        if (data == null || currentSpell == null) {
            return CastSource.SPELLBOOK;
        }
        for (ItemStack container : data.getSpellBooks()) {
            ISpellContainer spellContainer;
            if (container.isEmpty() || (spellContainer = ISpellContainer.get((ItemStack)container)).isEmpty()) continue;
            for (SpellSlot spellSlot : spellContainer.getActiveSpells()) {
                if (!spellSlot.equals((Object)currentSpell)) continue;
                return this.getCastSource(container);
            }
        }
        return CastSource.SPELLBOOK;
    }

    private void setCooldown(EntityMaid maid, AbstractSpell spell) {
        MaidIronsSpellData data = (MaidIronsSpellData)this.getData(maid);
        if (data == null || spell == null) {
            return;
        }
        double cooldownModifier = maid.getAttributeValue((Holder)AttributeRegistry.COOLDOWN_REDUCTION);
        int cooldownTicks = (int)((double)spell.getSpellCooldown() * (2.0 - Utils.softCapFormula((double)cooldownModifier)));
        String spellId = spell.getSpellId();
        data.setSpellCooldown(spellId, cooldownTicks, maid);
    }

    private void forceCompleteCasting(EntityMaid maid) {
        MaidIronsSpellData data = (MaidIronsSpellData)this.getData(maid);
        if (data == null || data.getCurrentCastingSpell() == null) {
            return;
        }
        AbstractSpell spell = data.getCurrentCastingSpell().getSpell();
        this.setCooldown(maid, spell);
        data.resetCastingState();
    }

    private void completeCasting(EntityMaid maid) {
        MaidIronsSpellData data = (MaidIronsSpellData)this.getData(maid);
        if (data == null || data.getCurrentCastingSpell() == null) {
            return;
        }
        AbstractSpell spell = data.getCurrentCastingSpell().getSpell();
        MagicData magicData = data.getMagicData();
        if (spell.getCastType() == CastType.LONG || spell.getCastType() == CastType.INSTANT) {
            CastSource castSource = this.getCastSource(data, data.getCurrentCastingSpell());
            spell.onCast(maid.level(), data.getCurrentCastingSpell().getLevel(), (LivingEntity)maid, castSource, magicData);
        }
        spell.onServerCastComplete(maid.level(), data.getCurrentCastingSpell().getLevel(), (LivingEntity)maid, magicData, false);
        this.setCooldown(maid, spell);
        data.resetCastingState();
    }

    private void setupSpellTargetData(EntityMaid maid, AbstractSpell spell) {
        MaidIronsSpellData data = (MaidIronsSpellData)this.getData(maid);
        if (data == null) {
            return;
        }
        LivingEntity target = data.getTarget();
        if (target == null) {
            return;
        }
        MagicData magicData = data.getMagicData();
        String spellId = spell.getSpellId();
        if (spellId.equals("irons_spellbooks:teleport") || spellId.contains("step")) {
            this.setTeleportLocationBehindTarget(maid, target, magicData);
        } else if (spellId.equals("irons_spellbooks:starfall") || spellId.equals("irons_spellbooks:scorch") || spellId.contains("storm") || spellId.contains("surge")) {
            Vec3 targetPosition = target.position();
            if (spellId.equals("irons_spellbooks:starfall")) {
                targetPosition = Utils.moveToRelativeGroundLevel((Level)maid.level(), (Vec3)targetPosition, (int)12);
                TargetedAreaEntity area = TargetedAreaEntity.createTargetAreaEntity((Level)maid.level(), (Vec3)targetPosition, (float)6.0f, (int)6291596);
                magicData.setAdditionalCastData((ICastData)new TargetAreaCastData(targetPosition, area));
            } else if (spellId.equals("irons_spellbooks:scorch")) {
                float radius = 2.5f;
                TargetedAreaEntity area = TargetedAreaEntity.createTargetAreaEntity((Level)maid.level(), (Vec3)targetPosition, (float)radius, (int)Utils.packRGB((Vector3f)spell.getTargetingColor()));
                magicData.setAdditionalCastData((ICastData)new TargetAreaCastData(targetPosition, area));
            }
        }
    }

    private void setTeleportLocationBehindTarget(EntityMaid maid, LivingEntity target, MagicData magicData) {
        if (target == null || maid == null) {
            return;
        }
        int distance = 10;
        Vec3 teleportPos = target.position();
        boolean validPositionFound = false;
        for (int i = 0; i < 24; ++i) {
            Vec3 randomness = Utils.getRandomVec3((double)(0.15f * (float)i)).multiply(1.0, 0.0, 1.0);
            teleportPos = Utils.moveToRelativeGroundLevel((Level)maid.level(), (Vec3)target.position().subtract(new Vec3(0.0, 0.0, (double)((float)distance / (float)(i / 7 + 1))).yRot(-(target.getYRot() + (float)(i * 45)) * ((float)Math.PI / 180))).add(randomness), (int)5);
            teleportPos = new Vec3(teleportPos.x, teleportPos.y + (double)0.1f, teleportPos.z);
            AABB reposBB = maid.getBoundingBox().move(teleportPos.subtract(maid.position()));
            if (maid.level().collidesWithSuffocatingBlock((Entity)maid, reposBB.inflate((double)-0.05f))) continue;
            validPositionFound = true;
            break;
        }
        if (!validPositionFound) {
            teleportPos = target.position();
        }
        magicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(teleportPos));
    }
}

