/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRangedWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.spell.SimplifiedSpellCaster;
import com.github.yimeng261.maidspell.spell.data.MaidIronsSpellData;
import com.github.yimeng261.maidspell.task.SpellCombatMeleeTask;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class SpellCombatFarTask
extends SpellCombatMeleeTask {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation UID = new ResourceLocation("maidspell", "spell_combat_far");
    private static final MutableComponent NAME = Component.translatable((String)"task.maidspell.spell_combat_far");
    private static float SPELL_RANGE;

    public static void setSpellRange(Float range) {
        SPELL_RANGE = range.floatValue();
    }

    @Override
    @NotNull
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    @NotNull
    public MutableComponent getName() {
        return NAME;
    }

    @Override
    public boolean enableLookAndRandomWalk(@NotNull EntityMaid maid) {
        return false;
    }

    public static boolean isInCombat(@NotNull EntityMaid maid) {
        LivingEntity target = maid.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        return target != null && target.isAlive() && !(target instanceof Player);
    }

    @Override
    @NotNull
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(@NotNull EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.create(this::hasSpellBook, IAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.create(target -> this.farAway((LivingEntity)target, maid));
        BehaviorControl moveToTargetTask = MaidRangedWalkToTarget.create((float)0.6f);
        FarSpellCombatBehavior spellCastingTask = new FarSpellCombatBehavior(this);
        SpellStrafingTask strafingTask = new SpellStrafingTask(this);
        SpellCombatMeleeTask.CombatLookControlTask lookControlTask = new SpellCombatMeleeTask.CombatLookControlTask();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)1, (Object)((Object)lookControlTask)), Pair.of((Object)2, (Object)supplementedTask), Pair.of((Object)2, (Object)findTargetTask), Pair.of((Object)2, (Object)moveToTargetTask), Pair.of((Object)2, (Object)((Object)spellCastingTask)), Pair.of((Object)2, (Object)((Object)strafingTask))});
    }

    private class FarSpellCombatBehavior
    extends SpellCombatMeleeTask.SpellCombatBehavior {
        private SimplifiedSpellCaster currentSpellCaster;

        private FarSpellCombatBehavior(SpellCombatFarTask spellCombatFarTask) {
        }

        @Override
        protected void start(ServerLevel level, EntityMaid maid, long gameTime) {
            this.currentSpellCaster = new SimplifiedSpellCaster(maid);
            LivingEntity target = maid.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
            if (target == maid.getOwner() && ModList.get().isLoaded("irons_spellbooks")) {
                target = MaidIronsSpellData.getOrCreate(maid).getOriginTarget();
            }
            if (!(target instanceof Player)) {
                this.currentSpellCaster.setTarget(target);
            }
        }

        @Override
        protected void tick(ServerLevel level, EntityMaid maid, long gameTime) {
            if (this.currentSpellCaster != null) {
                LivingEntity currentTarget = maid.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
                if (!(currentTarget instanceof Player)) {
                    this.currentSpellCaster.setTarget(currentTarget);
                }
                this.currentSpellCaster.far_tick();
            }
        }

        @Override
        protected void stop(ServerLevel level, EntityMaid maid, long gameTime) {
            if (this.currentSpellCaster != null) {
                this.currentSpellCaster = null;
            }
        }
    }

    class SpellStrafingTask
    extends SpellCombatMeleeTask.SpellStrafingTask {
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;
        private double optimalMinDistance = SimplifiedSpellCaster.FAR_RANGE;
        private double maxAttackDistance = SPELL_RANGE;
        private double rangeRange = 5.0;

        public SpellStrafingTask(SpellCombatFarTask this$0) {
        }

        @Override
        protected void tick(ServerLevel worldIn, EntityMaid maid, long gameTime) {
            SpellCombatFarTask task = new SpellCombatFarTask();
            if (!task.hasSpellBook(maid)) {
                return;
            }
            maid.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).ifPresent(target -> {
                double distance = maid.distanceTo((Entity)target);
                double optimalMaxDistance = this.optimalMinDistance + this.rangeRange;
                this.strafingTime = distance < this.maxAttackDistance && maid.canSee(target) ? ++this.strafingTime : -1;
                if (this.strafingTime >= 20) {
                    if ((double)maid.getRandom().nextFloat() < 0.3) {
                        boolean bl = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)maid.getRandom().nextFloat() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (distance > optimalMaxDistance) {
                        this.strafingBackwards = false;
                    } else if (distance < this.optimalMinDistance) {
                        this.strafingBackwards = true;
                    }
                    float forwardSpeed = this.strafingBackwards ? -0.7f : 0.7f;
                    float strafeSpeed = this.strafingClockwise ? 0.7f : -0.7f;
                    maid.getMoveControl().strafe(forwardSpeed, strafeSpeed);
                    maid.setYRot(Mth.rotateIfNecessary((float)maid.getYRot(), (float)maid.yHeadRot, (float)0.0f));
                }
            });
        }
    }
}

