/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRangedWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.github.yimeng261.maidspell.spell.SimplifiedSpellCaster;
import com.github.yimeng261.maidspell.spell.data.MaidIronsSpellData;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class SpellCombatMeleeTask
implements IRangedAttackTask {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation UID = new ResourceLocation("maidspell", "spell_combat_melee");
    private static final MutableComponent NAME = Component.translatable((String)"task.maidspell.spell_combat");
    private static float SPELL_RANGE;

    public static void setSpellRange(Float range) {
        SPELL_RANGE = range.floatValue();
    }

    public boolean enableLookAndRandomWalk(@NotNull EntityMaid maid) {
        return false;
    }

    public static boolean isInCombat(@NotNull EntityMaid maid) {
        LivingEntity target = maid.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        return target != null && target.isAlive() && !(target instanceof Player);
    }

    @NotNull
    public ResourceLocation getUid() {
        return UID;
    }

    @NotNull
    public MutableComponent getName() {
        return NAME;
    }

    @NotNull
    public ItemStack getIcon() {
        return Items.ENCHANTED_BOOK.getDefaultInstance();
    }

    public SoundEvent getAmbientSound(@NotNull EntityMaid maid) {
        return SoundUtil.attackSound((EntityMaid)maid, (SoundEvent)((SoundEvent)InitSounds.MAID_RANGE_ATTACK.get()), (float)0.5f);
    }

    public boolean isEnable(@NotNull EntityMaid maid) {
        return true;
    }

    @NotNull
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(@NotNull EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.create(this::hasSpellBook, IAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.create(target -> this.farAway((LivingEntity)target, maid));
        BehaviorControl moveToTargetTask = MaidRangedWalkToTarget.create((float)0.6f);
        SpellCombatBehavior spellCastingTask = new SpellCombatBehavior();
        SpellStrafingTask strafingTask = new SpellStrafingTask();
        CombatLookControlTask lookControlTask = new CombatLookControlTask();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)1, (Object)((Object)lookControlTask)), Pair.of((Object)2, (Object)supplementedTask), Pair.of((Object)2, (Object)findTargetTask), Pair.of((Object)2, (Object)moveToTargetTask), Pair.of((Object)2, (Object)((Object)spellCastingTask)), Pair.of((Object)2, (Object)((Object)strafingTask))});
    }

    public void performRangedAttack(@NotNull EntityMaid shooter, @NotNull LivingEntity target, float distanceFactor) {
    }

    public boolean canSee(EntityMaid maid, @NotNull LivingEntity target) {
        return (double)maid.distanceTo((Entity)target) <= (double)SPELL_RANGE * 1.2 && Math.abs(maid.getY() - target.getY()) < 5.0 && !(target instanceof Player);
    }

    @NotNull
    public AABB searchDimension(EntityMaid maid) {
        float searchRange = SPELL_RANGE;
        return maid.hasRestriction() ? new AABB(maid.getRestrictCenter()).inflate((double)searchRange) : maid.getBoundingBox().inflate((double)searchRange);
    }

    public float searchRadius(@NotNull EntityMaid maid) {
        return SPELL_RANGE;
    }

    public boolean hasExtraAttack(@NotNull EntityMaid maid, @NotNull Entity target) {
        return this.hasSpellBook(maid) && target instanceof LivingEntity && maid.distanceTo(target) <= SPELL_RANGE && !(target instanceof Player);
    }

    @NotNull
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(@NotNull EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"spell_book", this::hasSpellBook)});
    }

    public boolean isWeapon(@NotNull EntityMaid maid, @NotNull ItemStack stack) {
        return true;
    }

    boolean hasSpellBook(EntityMaid maid) {
        return true;
    }

    boolean farAway(LivingEntity target, EntityMaid maid) {
        return maid.distanceTo((Entity)target) > this.searchRadius(maid);
    }

    static class SpellCombatBehavior
    extends Behavior<EntityMaid> {
        private SimplifiedSpellCaster currentSpellCaster;

        public SpellCombatBehavior() {
            super(Map.of(MemoryModuleType.ATTACK_TARGET, MemoryStatus.VALUE_PRESENT, MemoryModuleType.LOOK_TARGET, MemoryStatus.REGISTERED));
        }

        protected boolean checkExtraStartConditions(ServerLevel level, EntityMaid maid) {
            LivingEntity target = maid.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
            if (target == null || !target.isAlive() || target instanceof Player) {
                return false;
            }
            double distance = maid.distanceTo((Entity)target);
            return distance <= (double)SPELL_RANGE;
        }

        protected boolean canStillUse(ServerLevel level, EntityMaid maid, long gameTime) {
            return this.checkExtraStartConditions(level, maid);
        }

        protected void start(ServerLevel level, EntityMaid maid, long gameTime) {
            this.currentSpellCaster = new SimplifiedSpellCaster(maid);
            LivingEntity target = maid.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
            if (target == maid.getOwner() && ModList.get().isLoaded("irons_spellbooks")) {
                target = MaidIronsSpellData.getOrCreate(maid).getOriginTarget();
            }
            if (!(target instanceof Player)) {
                this.currentSpellCaster.setTarget(target);
            }
        }

        protected void tick(ServerLevel level, EntityMaid maid, long gameTime) {
            LivingEntity currentTarget;
            if (this.currentSpellCaster != null && !((currentTarget = (LivingEntity)maid.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null)) instanceof Player)) {
                this.currentSpellCaster.setTarget(currentTarget);
                this.currentSpellCaster.melee_tick();
            }
        }

        protected void stop(ServerLevel level, EntityMaid maid, long gameTime) {
            if (this.currentSpellCaster != null) {
                this.currentSpellCaster = null;
            }
        }
    }

    static class SpellStrafingTask
    extends Behavior<EntityMaid> {
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;
        private final double optimalMinDistance = SimplifiedSpellCaster.MELEE_RANGE - 1.0;
        private final double maxAttackDistance = SPELL_RANGE;
        private final double rangeRange = 1.5;

        public SpellStrafingTask() {
            super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT), 1200);
        }

        protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
            LivingEntity target = maid.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
            return target != null && target.isAlive() && !(target instanceof Player);
        }

        protected void tick(ServerLevel worldIn, EntityMaid maid, long gameTime) {
            maid.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).ifPresent(target -> {
                double distance = maid.distanceTo((Entity)target);
                double optimalMaxDistance = this.optimalMinDistance + this.rangeRange;
                this.strafingTime = distance < this.maxAttackDistance && maid.canSee(target) ? ++this.strafingTime : -1;
                if (this.strafingTime >= 20) {
                    if ((double)maid.getRandom().nextFloat() < 0.3) {
                        boolean bl = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)maid.getRandom().nextFloat() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (distance > optimalMaxDistance) {
                        this.strafingBackwards = false;
                    } else if (distance < this.optimalMinDistance) {
                        this.strafingBackwards = true;
                    }
                    float forwardSpeed = this.strafingBackwards ? -0.7f : 0.7f;
                    float strafeSpeed = this.strafingClockwise ? 0.7f : -0.7f;
                    maid.getMoveControl().strafe(forwardSpeed, strafeSpeed);
                    maid.setYRot(Mth.rotateIfNecessary((float)maid.getYRot(), (float)maid.yHeadRot, (float)0.0f));
                }
            });
        }

        protected void start(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
            entityIn.setSwingingArms(true);
        }

        protected void stop(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
            entityIn.setSwingingArms(false);
            entityIn.getMoveControl().strafe(0.0f, 0.0f);
        }

        protected boolean canStillUse(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
            return this.checkExtraStartConditions(worldIn, entityIn);
        }
    }

    static class CombatLookControlTask
    extends Behavior<EntityMaid> {
        public CombatLookControlTask() {
            super(Map.of(MemoryModuleType.ATTACK_TARGET, MemoryStatus.VALUE_PRESENT, MemoryModuleType.LOOK_TARGET, MemoryStatus.REGISTERED));
        }

        protected boolean checkExtraStartConditions(ServerLevel level, EntityMaid maid) {
            LivingEntity target = maid.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
            if (target instanceof Player && this.isIronSpellSpecialCase(maid)) {
                return true;
            }
            return target != null && target.isAlive() && !(target instanceof Player);
        }

        protected boolean canStillUse(ServerLevel level, EntityMaid maid, long gameTime) {
            return this.checkExtraStartConditions(level, maid);
        }

        protected void tick(ServerLevel level, EntityMaid maid, long gameTime) {
            LivingEntity target = maid.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
            if (target != null && target.isAlive()) {
                if (target instanceof Player && this.isIronSpellSpecialCase(maid)) {
                    maid.getLookControl().setLookAt(target.getX(), target.getEyeY(), target.getZ());
                } else if (!(target instanceof Player)) {
                    maid.getLookControl().setLookAt(target.getX(), target.getEyeY(), target.getZ());
                    maid.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
                }
            }
        }

        protected void start(ServerLevel level, EntityMaid maid, long gameTime) {
            LivingEntity target = maid.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
            if (!(target instanceof Player) || !this.isIronSpellSpecialCase(maid)) {
                maid.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
            }
        }

        protected void stop(ServerLevel level, EntityMaid maid, long gameTime) {
        }

        private boolean isIronSpellSpecialCase(EntityMaid maid) {
            if (!ModList.get().isLoaded("irons_spellbooks")) {
                return false;
            }
            try {
                MaidIronsSpellData data = MaidIronsSpellData.getOrCreate(maid);
                if (data == null) {
                    return false;
                }
                LivingEntity currentTarget = data.getTarget();
                LivingEntity originTarget = data.getOriginTarget();
                LivingEntity owner = maid.getOwner();
                return currentTarget == owner && originTarget != null && originTarget != owner;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

