/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.utils;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.spell.manager.BaubleStateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber(modid="touhou_little_maid_spell")
public class ChunkLoadingManager {
    public static final Map<UUID, ChunkKey> maidChunkPositions = new ConcurrentHashMap<UUID, ChunkKey>();
    private static final Map<ChunkKey, ChunkTimer> chunkTimers = new ConcurrentHashMap<ChunkKey, ChunkTimer>();
    private static final int CHECK_INTERVAL_TICKS = 20;
    private static final int DEFAULT_CHUNK_LIFETIME_TICKS = 200;

    public static void enableChunkLoading(EntityMaid maid) {
        if (maid == null || maid.level().isClientSide()) {
            return;
        }
        UUID maidId = maid.getUUID();
        ServerLevel serverLevel = (ServerLevel)maid.level();
        ChunkPos chunkPos = maid.chunkPosition();
        ChunkKey chunkKey = new ChunkKey(chunkPos, serverLevel);
        Global.LOGGER.debug("\u4e3a\u5973\u4ec6 {} \u542f\u7528\u533a\u5757\u52a0\u8f7d: {}", (Object)maidId, (Object)chunkKey);
        ChunkLoadingManager.enableChunkLoadingWithTimer(maidId, serverLevel, chunkKey, 200);
        maidChunkPositions.put(maidId, chunkKey);
    }

    private static void enableChunkLoadingWithTimer(UUID maidId, ServerLevel serverLevel, ChunkKey chunkKey, int lifetimeTicks) {
        ChunkTimer timer = chunkTimers.get(chunkKey);
        if (timer == null) {
            timer = new ChunkTimer(chunkKey, lifetimeTicks);
            timer.addMaid(maidId);
            Global.LOGGER.debug("\u51c6\u5907\u8fdb\u884c\u533a\u5757\u52a0\u8f7d");
            boolean success = ChunkLoadingManager.performChunkOperation(serverLevel, maidId, chunkKey.chunkPos, true);
            if (success) {
                chunkTimers.put(chunkKey, timer);
                Global.LOGGER.debug("\u65b0\u5efa\u533a\u5757\u8ba1\u65f6\u5668: {} ({}\u79d2)", (Object)chunkKey, (Object)(lifetimeTicks / 20));
                ChunkLoadingManager.saveToGlobalData(serverLevel.getServer());
            } else {
                Global.LOGGER.warn("\u65e0\u6cd5\u4e3a\u5973\u4ec6 {} \u542f\u7528\u533a\u5757\u52a0\u8f7d: {}", (Object)maidId, (Object)chunkKey);
            }
        }
    }

    public static void preloadTeleportTarget(EntityMaid maid, Vec3 targetPos, ServerLevel level) {
        if (maid == null || targetPos == null) {
            return;
        }
        UUID maidId = maid.getUUID();
        ChunkPos targetChunk = new ChunkPos(BlockPos.containing((Position)targetPos));
        ChunkKey targetKey = new ChunkKey(targetChunk, level);
        Global.LOGGER.debug("\u5973\u4ec6 {} \u9884\u52a0\u8f7d\u4f20\u9001\u76ee\u6807\u533a\u5757: {}", (Object)maidId, (Object)targetKey);
        try {
            MinecraftServer server = maid.getServer();
            if (server == null) {
                return;
            }
            if (level == null) {
                Global.LOGGER.warn("\u65e0\u6cd5\u627e\u5230\u76ee\u6807\u7ef4\u5ea6 {} \u6765\u9884\u52a0\u8f7d\u533a\u5757", (Object)level);
                return;
            }
            ChunkLoadingManager.enableChunkLoadingWithTimer(maidId, level, targetKey, 100);
        }
        catch (Exception e) {
            Global.LOGGER.error("\u9884\u52a0\u8f7d\u5973\u4ec6 {} \u4f20\u9001\u76ee\u6807\u533a\u5757\u65f6\u53d1\u751f\u9519\u8bef", (Object)maidId, (Object)e);
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        if (event.getServer().getTickCount() % 20 == 0) {
            ChunkLoadingManager.processChunkTimers();
        }
    }

    private static void processChunkTimers() {
        if (chunkTimers.isEmpty()) {
            return;
        }
        ArrayList<ChunkKey> expiredChunks = new ArrayList<ChunkKey>();
        MinecraftServer server = ChunkLoadingManager.getCurrentServer();
        if (server == null) {
            return;
        }
        for (Map.Entry<ChunkKey, ChunkTimer> entry : chunkTimers.entrySet()) {
            ChunkKey chunkKey = entry.getKey();
            ChunkTimer timer = entry.getValue();
            HashSet<UUID> validMaids = new HashSet<UUID>();
            for (UUID maidId : timer.getAssociatedMaids()) {
                EntityMaid maid;
                Entity entity = timer.chunkKey.level.getEntity(maidId);
                if (!(entity instanceof EntityMaid) || !BaubleStateManager.hasBauble(maid = (EntityMaid)entity, MaidSpellItems.ANCHOR_CORE) || !maid.chunkPosition().equals((Object)timer.chunkKey.chunkPos)) continue;
                validMaids.add(maidId);
            }
            timer.getAssociatedMaids().clear();
            for (UUID validMaid : validMaids) {
                timer.addMaid(validMaid);
            }
            if (!validMaids.isEmpty()) continue;
            timer.update();
            if (!timer.isExpired()) continue;
            expiredChunks.add(chunkKey);
        }
        for (ChunkKey expiredChunk : expiredChunks) {
            ChunkLoadingManager.unloadExpiredChunk(expiredChunk, server);
        }
        if (!expiredChunks.isEmpty()) {
            Global.LOGGER.debug("\u5378\u8f7d\u4e86 {} \u4e2a\u8fc7\u671f\u533a\u5757", (Object)expiredChunks.size());
        }
    }

    private static void unloadExpiredChunk(ChunkKey chunkKey, MinecraftServer server) {
        ChunkTimer timer = chunkTimers.remove(chunkKey);
        if (timer == null) {
            return;
        }
        ServerLevel serverLevel = chunkKey.level;
        if (serverLevel == null) {
            Global.LOGGER.warn("\u65e0\u6cd5\u627e\u5230\u7ef4\u5ea6 {} \u6765\u5378\u8f7d\u533a\u5757", (Object)chunkKey.level);
            return;
        }
        for (UUID maidId : timer.getAssociatedMaids()) {
            ChunkKey maidInfo;
            boolean success = ChunkLoadingManager.performChunkOperation(serverLevel, maidId, chunkKey.chunkPos, false);
            if (!success || (maidInfo = maidChunkPositions.get(maidId)) == null || !maidInfo.chunkPos.equals((Object)chunkKey.chunkPos) || !maidInfo.level.equals(chunkKey.level)) continue;
            maidChunkPositions.remove(maidId);
        }
        Global.LOGGER.debug("\u5378\u8f7d\u8fc7\u671f\u533a\u5757: {} (\u5173\u8054\u5973\u4ec6: {})", (Object)chunkKey, timer.getAssociatedMaids());
        ChunkLoadingManager.saveToGlobalData(server);
    }

    private static MinecraftServer getCurrentServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static boolean shouldEnableChunkLoading(EntityMaid maid, MinecraftServer server) {
        UUID maidId = maid.getUUID();
        if (maidChunkPositions.containsKey(maidId)) {
            return true;
        }
        try {
            ChunkLoadingData data = ChunkLoadingData.get(server);
            return data.getSavedPositions().containsKey(maidId);
        }
        catch (Exception e) {
            Global.LOGGER.warn("\u68c0\u67e5\u5168\u5c40\u533a\u5757\u52a0\u8f7d\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static void restoreChunkLoadingFromSavedData(EntityMaid maid, MinecraftServer server) {
        if (maid == null || maid.level().isClientSide()) {
            return;
        }
        UUID maidId = maid.getUUID();
        try {
            ChunkLoadingData data = ChunkLoadingData.get(server);
            ChunkKey savedInfo = data.getMaidRecord(maidId);
            if (savedInfo == null) {
                ChunkLoadingManager.enableChunkLoading(maid);
                return;
            }
            ServerLevel serverLevel = (ServerLevel)maid.level();
            ChunkPos currentChunk = maid.chunkPosition();
            ResourceKey currentDimension = serverLevel.dimension();
            if (currentDimension.equals(savedInfo.level.dimension()) && currentChunk.equals((Object)savedInfo.chunkPos)) {
                ChunkLoadingManager.restoreChunkLoadingAtPosition(maid, serverLevel, savedInfo);
            } else {
                Global.LOGGER.debug("\u5973\u4ec6 {} \u4f4d\u7f6e\u5df2\u53d8\u5316\uff0c\u66f4\u65b0\u533a\u5757\u52a0\u8f7d\u5230\u65b0\u4f4d\u7f6e: \u4ece {} \u5230 {}", new Object[]{maid.getUUID(), savedInfo, new ChunkKey(currentChunk, serverLevel)});
                ChunkLoadingManager.enableChunkLoading(maid);
            }
        }
        catch (Exception e) {
            Global.LOGGER.error("\u4eceSavedData\u6062\u590d\u5973\u4ec6 {} \u533a\u5757\u52a0\u8f7d\u65f6\u53d1\u751f\u9519\u8bef", (Object)maid.getUUID(), (Object)e);
        }
    }

    private static boolean performChunkOperation(ServerLevel serverLevel, UUID maidId, ChunkPos chunkPos, boolean enable) {
        try {
            Global.LOGGER.debug("before force load: chunk=[{}, {}], enable={}, maid={}", new Object[]{chunkPos.x, chunkPos.z, enable, maidId});
            if (enable && serverLevel.getForcedChunks().contains(chunkPos.toLong())) {
                Global.LOGGER.debug("\u533a\u5757 {} \u5df2\u7ecf\u88ab\u5f3a\u5236\u52a0\u8f7d\uff0c\u8df3\u8fc7", (Object)chunkPos);
                return true;
            }
            return serverLevel.setChunkForced(chunkPos.x, chunkPos.z, true);
        }
        catch (Exception e) {
            Global.LOGGER.error("\u533a\u5757\u64cd\u4f5c\u5931\u8d25: chunk=[{}, {}], enable={}, error={}", new Object[]{chunkPos.x, chunkPos.z, enable, e.getMessage(), e});
            return false;
        }
    }

    private static void restoreChunkLoadingAtPosition(EntityMaid maid, ServerLevel serverLevel, ChunkKey savedInfo) {
        UUID maidId = maid.getUUID();
        boolean success = ChunkLoadingManager.performChunkOperation(serverLevel, maidId, savedInfo.chunkPos(), true);
        if (success) {
            maidChunkPositions.put(maidId, savedInfo);
        }
    }

    private static void saveToGlobalData(MinecraftServer server) {
        try {
            ChunkLoadingData data = ChunkLoadingData.get(server);
            for (Map.Entry<UUID, ChunkKey> entry : maidChunkPositions.entrySet()) {
                data.updateMaidPosition(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            Global.LOGGER.error("\u4fdd\u5b58\u533a\u5757\u52a0\u8f7d\u5168\u5c40\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        try {
            ChunkLoadingData data = ChunkLoadingData.get(server);
            Map<UUID, ChunkKey> savedPositions = data.getSavedPositions();
            if (!savedPositions.isEmpty()) {
                Global.LOGGER.info("\u670d\u52a1\u5668\u542f\u52a8\u65f6\u53d1\u73b0 {} \u4e2a\u5973\u4ec6\u7684\u533a\u5757\u52a0\u8f7d\u914d\u7f6e\uff0c\u5c06\u5728\u5973\u4ec6\u52a0\u8f7d\u65f6\u81ea\u52a8\u6062\u590d", (Object)savedPositions.size());
                maidChunkPositions.putAll(savedPositions);
            }
        }
        catch (Exception e) {
            Global.LOGGER.error("\u670d\u52a1\u5668\u542f\u52a8\u65f6\u52a0\u8f7d\u533a\u5757\u52a0\u8f7d\u6570\u636e\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    public record ChunkKey(ChunkPos chunkPos, ServerLevel level) {
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ChunkKey)) {
                return false;
            }
            ChunkKey other = (ChunkKey)obj;
            return this.chunkPos.equals((Object)other.chunkPos) && this.level.equals(other.level);
        }

        @Override
        public String toString() {
            return String.valueOf(this.chunkPos) + " (" + String.valueOf(this.level) + ")";
        }
    }

    private static class ChunkTimer {
        private int remainingTicks;
        private final Set<UUID> associatedMaids;
        private final ChunkKey chunkKey;

        public ChunkTimer(ChunkKey chunkKey, int initialTicks) {
            this.chunkKey = chunkKey;
            this.remainingTicks = initialTicks;
            this.associatedMaids = new HashSet<UUID>();
        }

        public void addMaid(UUID maidId) {
            this.associatedMaids.add(maidId);
        }

        public Set<UUID> getAssociatedMaids() {
            return this.associatedMaids;
        }

        public void update() {
            this.remainingTicks = Math.max(0, this.remainingTicks - 20);
        }

        public boolean isExpired() {
            return this.remainingTicks <= 0;
        }

        public String toString() {
            return String.format("ChunkTimer{%s, ticks=%d, maids=%s}", this.chunkKey, this.remainingTicks, this.associatedMaids);
        }
    }

    public static class ChunkLoadingData
    extends SavedData {
        private static final String DATA_NAME = "maidspell_chunk_loading";
        private final Map<UUID, ChunkKey> savedPositions = new HashMap<UUID, ChunkKey>();

        public static ChunkLoadingData load(CompoundTag tag, HolderLookup.Provider provider) {
            ChunkLoadingData data = new ChunkLoadingData();
            CompoundTag maidsTag = tag.getCompound("maids");
            for (String uuidStr : maidsTag.getAllKeys()) {
                try {
                    UUID maidId = UUID.fromString(uuidStr);
                    CompoundTag maidTag = maidsTag.getCompound(uuidStr);
                    int x = maidTag.getInt("x");
                    int z = maidTag.getInt("z");
                    String dimensionStr = maidTag.getString("level");
                    ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)dimensionStr));
                    MinecraftServer server = ChunkLoadingManager.getCurrentServer();
                    if (server == null) {
                        Global.LOGGER.warn("\u65e0\u6cd5\u83b7\u53d6\u670d\u52a1\u5668\u5b9e\u4f8b\uff0c\u8df3\u8fc7\u5973\u4ec6 {} \u7684\u533a\u5757\u52a0\u8f7d\u6570\u636e", (Object)maidId);
                        continue;
                    }
                    ServerLevel level = server.getLevel(dimension);
                    if (level == null) {
                        Global.LOGGER.warn("\u65e0\u6cd5\u627e\u5230\u7ef4\u5ea6 {}\uff0c\u8df3\u8fc7\u5973\u4ec6 {} \u7684\u533a\u5757\u52a0\u8f7d\u6570\u636e", (Object)dimensionStr, (Object)maidId);
                        continue;
                    }
                    data.savedPositions.put(maidId, new ChunkKey(new ChunkPos(x, z), level));
                    Global.LOGGER.debug("\u6210\u529f\u52a0\u8f7d\u5973\u4ec6 {} \u7684\u533a\u5757\u52a0\u8f7d\u6570\u636e: \u4f4d\u7f6e({}, {}) \u7ef4\u5ea6{}", new Object[]{maidId, x, z, dimensionStr});
                }
                catch (Exception e) {
                    Global.LOGGER.warn("\u52a0\u8f7d\u5973\u4ec6 {} \u533a\u5757\u52a0\u8f7d\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)uuidStr, (Object)e.getMessage());
                }
            }
            Global.LOGGER.info("\u6210\u529f\u52a0\u8f7d {} \u4e2a\u5973\u4ec6\u7684\u533a\u5757\u52a0\u8f7d\u6570\u636e", (Object)data.savedPositions.size());
            return data;
        }

        public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
            CompoundTag maidsTag = new CompoundTag();
            for (Map.Entry<UUID, ChunkKey> entry : this.savedPositions.entrySet()) {
                try {
                    CompoundTag maidTag = new CompoundTag();
                    ChunkKey info = entry.getValue();
                    maidTag.putInt("x", info.chunkPos.x);
                    maidTag.putInt("z", info.chunkPos.z);
                    maidTag.putString("level", info.level.dimension().location().toString());
                    maidsTag.put(entry.getKey().toString(), (Tag)maidTag);
                    Global.LOGGER.debug("\u4fdd\u5b58\u5973\u4ec6 {} \u7684\u533a\u5757\u52a0\u8f7d\u6570\u636e: \u4f4d\u7f6e({}, {}) \u7ef4\u5ea6{}", new Object[]{entry.getKey(), info.chunkPos.x, info.chunkPos.z, info.level.dimension().location().toString()});
                }
                catch (Exception e) {
                    Global.LOGGER.warn("\u4fdd\u5b58\u5973\u4ec6 {} \u533a\u5757\u52a0\u8f7d\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)entry.getKey(), (Object)e.getMessage());
                }
            }
            tag.put("maids", (Tag)maidsTag);
            Global.LOGGER.debug("\u6210\u529f\u4fdd\u5b58 {} \u4e2a\u5973\u4ec6\u7684\u533a\u5757\u52a0\u8f7d\u6570\u636e", (Object)this.savedPositions.size());
            return tag;
        }

        public void updateMaidPosition(UUID maidId, ChunkKey info) {
            if (info != null) {
                this.savedPositions.put(maidId, info);
            } else {
                this.savedPositions.remove(maidId);
            }
            this.setDirty();
        }

        public Map<UUID, ChunkKey> getSavedPositions() {
            return new HashMap<UUID, ChunkKey>(this.savedPositions);
        }

        public boolean hasMaidRecord(UUID maidId) {
            return this.savedPositions.containsKey(maidId);
        }

        public ChunkKey getMaidRecord(UUID maidId) {
            return this.savedPositions.get(maidId);
        }

        public static ChunkLoadingData get(MinecraftServer server) {
            return (ChunkLoadingData)server.overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(ChunkLoadingData::new, ChunkLoadingData::load), DATA_NAME);
        }
    }
}

