/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.worldgen.structure;

import com.github.yimeng261.maidspell.worldgen.MaidSpellStructures;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class HiddenRetreatStructure
extends Structure {
    public static final MapCodec<HiddenRetreatStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Structure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size)).apply((Applicative)instance, HiddenRetreatStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final int size;
    private int height;
    private static final double MAX_TERRAIN_VARIANCE = 16.0;
    private static final int SAMPLES_PER_CHUNK = 5;

    public HiddenRetreatStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int size) {
        super(settings);
        this.startPool = startPool;
        this.size = size;
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        BlockPos centerPos = new BlockPos(chunkPos.getMinBlockX() + 8, 0, chunkPos.getMinBlockZ() + 8);
        if (!this.isValidGenerationLocation(context, chunkPos)) {
            return Optional.empty();
        }
        BlockPos structurePos = new BlockPos(centerPos.getX(), this.height, centerPos.getZ());
        return JigsawPlacement.addPieces((Structure.GenerationContext)context, this.startPool, Optional.empty(), (int)this.size, (BlockPos)structurePos, (boolean)false, Optional.empty(), (int)150, (PoolAliasLookup)PoolAliasLookup.EMPTY, (DimensionPadding)DimensionPadding.ZERO, (LiquidSettings)LiquidSettings.IGNORE_WATERLOGGING);
    }

    public StructureType<?> type() {
        return (StructureType)MaidSpellStructures.HIDDEN_RETREAT.get();
    }

    private boolean isValidGenerationLocation(Structure.GenerationContext context, ChunkPos centerChunk) {
        ArrayList<Integer> heightSamples = new ArrayList<Integer>();
        int range = 2;
        for (int dx = -range; dx <= range; ++dx) {
            for (int dz = -range; dz <= range; ++dz) {
                ChunkPos checkChunk = new ChunkPos(centerChunk.x + dx, centerChunk.z + dz);
                int x = checkChunk.getMinBlockX() + 8;
                int z = checkChunk.getMinBlockZ() + 8;
                int y = context.chunkGenerator().getSeaLevel();
                Holder biome = context.biomeSource().getNoiseBiome(x >> 2, y >> 2, z >> 2, context.randomState().sampler());
                if (!biome.is(Biomes.CHERRY_GROVE)) {
                    return false;
                }
                List<Integer> chunkHeightSamples = this.sampleChunkHeights(context, checkChunk);
                heightSamples.addAll(chunkHeightSamples);
            }
        }
        return this.isTerrainFlat(heightSamples);
    }

    private List<Integer> sampleChunkHeights(Structure.GenerationContext context, ChunkPos chunk) {
        ArrayList<Integer> heights = new ArrayList<Integer>();
        RandomSource random = RandomSource.create((long)chunk.toLong());
        int minX = chunk.getMinBlockX();
        int minZ = chunk.getMinBlockZ();
        for (int i = 0; i < 5; ++i) {
            int x = minX + random.nextInt(16);
            int z = minZ + random.nextInt(16);
            int height = context.chunkGenerator().getFirstOccupiedHeight(x, z, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, context.heightAccessor(), context.randomState());
            heights.add(height);
        }
        return heights;
    }

    private boolean isTerrainFlat(List<Integer> heights) {
        if (heights.size() < 2) {
            return true;
        }
        double sum = 0.0;
        for (int height : heights) {
            sum += (double)height;
        }
        double mean = sum / (double)heights.size();
        this.height = (int)mean;
        double varianceSum = 0.0;
        for (int height : heights) {
            double diff = (double)height - mean;
            varianceSum += diff * diff;
        }
        double variance = varianceSum / (double)heights.size();
        return variance <= 16.0;
    }
}

