/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.simplebedrockmodel.client.bedrock.model;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockCube;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BedrockCubeBox
implements BedrockCube {
    protected static final Vector3f[] VERTICES = new Vector3f[8];
    protected static final Vector3f EDGE_X = new Vector3f();
    protected static final Vector3f EDGE_Y = new Vector3f();
    protected static final Vector3f EDGE_Z = new Vector3f();
    protected static final int[][] UV_ORDER_NO_MIRROR = new int[][]{{1, 2, 6, 7}, {2, 3, 7, 6}, {1, 2, 7, 8}, {4, 5, 7, 8}, {0, 1, 7, 8}, {2, 4, 7, 8}};
    protected static final int[][] UV_ORDER_MIRRORED = new int[][]{{2, 1, 6, 7}, {3, 2, 7, 6}, {2, 1, 7, 8}, {5, 4, 7, 8}, {4, 2, 7, 8}, {1, 0, 7, 8}};
    protected final float width;
    protected final float height;
    protected final float depth;
    protected final float x;
    protected final float y;
    protected final float z;
    protected final float[] uvs;
    protected final int[][] uvOrder;

    public BedrockCubeBox(float texOffX, float texOffY, float x, float y, float z, float width, float height, float depth, float delta, boolean mirror, float texWidth, float texHeight) {
        this.x = (x - delta) / 16.0f;
        this.y = (y - delta) / 16.0f;
        this.z = (z - delta) / 16.0f;
        this.width = (width + delta * 2.0f) / 16.0f;
        this.height = (height + delta * 2.0f) / 16.0f;
        this.depth = (depth + delta * 2.0f) / 16.0f;
        float dx = Mth.floor((float)width);
        float dy = Mth.floor((float)height);
        float dz = Mth.floor((float)depth);
        float scaleU = 1.0f / texWidth;
        float scaleV = 1.0f / texHeight;
        this.uvs = new float[9];
        this.uvs[0] = scaleU * texOffX;
        this.uvs[1] = scaleU * (texOffX + dz);
        this.uvs[2] = scaleU * (texOffX + dz + dx);
        this.uvs[3] = scaleU * (texOffX + dz + dx + dx);
        this.uvs[4] = scaleU * (texOffX + dz + dx + dz);
        this.uvs[5] = scaleU * (texOffX + dz + dx + dz + dx);
        this.uvs[6] = scaleV * texOffY;
        this.uvs[7] = scaleV * (texOffY + dz);
        this.uvs[8] = scaleV * (texOffY + dz + dy);
        this.uvOrder = mirror ? UV_ORDER_MIRRORED : UV_ORDER_NO_MIRROR;
    }

    protected void prepareVertices(Matrix4f pose) {
        EDGE_X.set(pose.m00(), pose.m01(), pose.m02()).mul(this.width);
        EDGE_Y.set(pose.m10(), pose.m11(), pose.m12()).mul(this.height);
        EDGE_Z.set(pose.m20(), pose.m21(), pose.m22()).mul(this.depth);
        VERTICES[0].set(this.x, this.y, this.z).mulPosition((Matrix4fc)pose);
        VERTICES[0].add((Vector3fc)EDGE_X, VERTICES[1]);
        VERTICES[1].add((Vector3fc)EDGE_Y, VERTICES[2]);
        VERTICES[0].add((Vector3fc)EDGE_Y, VERTICES[3]);
        VERTICES[0].add((Vector3fc)EDGE_Z, VERTICES[4]);
        VERTICES[1].add((Vector3fc)EDGE_Z, VERTICES[5]);
        VERTICES[2].add((Vector3fc)EDGE_Z, VERTICES[6]);
        VERTICES[3].add((Vector3fc)EDGE_Z, VERTICES[7]);
    }

    @Override
    public void compile(PoseStack.Pose pose, Vector3f[] normals, VertexConsumer consumer, int lightmap, int overlay, float r, float g, float b, float a) {
        Matrix4f matrix4f = pose.pose();
        this.prepareVertices(matrix4f);
        for (int i = 0; i < 6; ++i) {
            consumer.addVertex(BedrockCubeBox.VERTICES[BedrockCubeBox.VERTEX_ORDER[i][0]].x, BedrockCubeBox.VERTICES[BedrockCubeBox.VERTEX_ORDER[i][0]].y, BedrockCubeBox.VERTICES[BedrockCubeBox.VERTEX_ORDER[i][0]].z).setColor(r, g, b, a).setUv(this.uvs[this.uvOrder[i][1]], this.uvs[this.uvOrder[i][2]]).setOverlay(overlay).setLight(lightmap).setNormal(normals[i].x, normals[i].y, normals[i].z);
            consumer.addVertex(BedrockCubeBox.VERTICES[BedrockCubeBox.VERTEX_ORDER[i][1]].x, BedrockCubeBox.VERTICES[BedrockCubeBox.VERTEX_ORDER[i][1]].y, BedrockCubeBox.VERTICES[BedrockCubeBox.VERTEX_ORDER[i][1]].z).setColor(r, g, b, a).setUv(this.uvs[this.uvOrder[i][0]], this.uvs[this.uvOrder[i][2]]).setOverlay(overlay).setLight(lightmap).setNormal(normals[i].x, normals[i].y, normals[i].z);
            consumer.addVertex(BedrockCubeBox.VERTICES[BedrockCubeBox.VERTEX_ORDER[i][2]].x, BedrockCubeBox.VERTICES[BedrockCubeBox.VERTEX_ORDER[i][2]].y, BedrockCubeBox.VERTICES[BedrockCubeBox.VERTEX_ORDER[i][2]].z).setColor(r, g, b, a).setUv(this.uvs[this.uvOrder[i][0]], this.uvs[this.uvOrder[i][3]]).setOverlay(overlay).setLight(lightmap).setNormal(normals[i].x, normals[i].y, normals[i].z);
            consumer.addVertex(BedrockCubeBox.VERTICES[BedrockCubeBox.VERTEX_ORDER[i][3]].x, BedrockCubeBox.VERTICES[BedrockCubeBox.VERTEX_ORDER[i][3]].y, BedrockCubeBox.VERTICES[BedrockCubeBox.VERTEX_ORDER[i][3]].z).setColor(r, g, b, a).setUv(this.uvs[this.uvOrder[i][1]], this.uvs[this.uvOrder[i][3]]).setOverlay(overlay).setLight(lightmap).setNormal(normals[i].x, normals[i].y, normals[i].z);
        }
    }

    static {
        for (int i = 0; i < VERTICES.length; ++i) {
            BedrockCubeBox.VERTICES[i] = new Vector3f();
        }
    }
}

