/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.service.stt.aliyun;

import com.github.tartaricacid.touhoulittlemaid.ai.service.SerializableSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.STTApiType;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.STTClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.STTSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.aliyun.STTAliyunClient;
import com.github.tartaricacid.touhoulittlemaid.util.http.UrlTool;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class STTAliyunSite
implements STTSite {
    public static final String API_TYPE = STTApiType.ALIYUN.getName();
    private final String id;
    private final ResourceLocation icon;
    private boolean enabled;
    private String url;
    private String secretKey;
    private String appKey;
    private String vocabularyId;
    private String customizationId;
    private boolean enablePunctuationPrediction;
    private boolean enableInverseTextNormalization;
    private boolean enableVoiceDetection;
    private boolean disfluency;

    public STTAliyunSite(String id, ResourceLocation icon, boolean enabled, String url, String secretKey, String appKey, String vocabularyId, String customizationId, boolean enablePunctuationPrediction, boolean enableInverseTextNormalization, boolean enableVoiceDetection, boolean disfluency) {
        this.id = id;
        this.icon = icon;
        this.enabled = enabled;
        this.url = url;
        this.secretKey = secretKey;
        this.appKey = appKey;
        this.vocabularyId = vocabularyId;
        this.customizationId = customizationId;
        this.enablePunctuationPrediction = enablePunctuationPrediction;
        this.enableInverseTextNormalization = enableInverseTextNormalization;
        this.enableVoiceDetection = enableVoiceDetection;
        this.disfluency = disfluency;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ResourceLocation icon() {
        return this.icon;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public String getApiType() {
        return API_TYPE;
    }

    @Override
    public STTClient client() {
        return new STTAliyunClient(STT_HTTP_CLIENT, this);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setVocabularyId(String vocabularyId) {
        this.vocabularyId = vocabularyId;
    }

    public void setCustomizationId(String customizationId) {
        this.customizationId = customizationId;
    }

    public void setEnablePunctuationPrediction(boolean enablePunctuationPrediction) {
        this.enablePunctuationPrediction = enablePunctuationPrediction;
    }

    public void setEnableInverseTextNormalization(boolean enableInverseTextNormalization) {
        this.enableInverseTextNormalization = enableInverseTextNormalization;
    }

    public void setEnableVoiceDetection(boolean enableVoiceDetection) {
        this.enableVoiceDetection = enableVoiceDetection;
    }

    public void setDisfluency(boolean disfluency) {
        this.disfluency = disfluency;
    }

    @Override
    public String url() {
        HashMap params = Maps.newHashMap();
        params.put("appkey", this.getAppKey());
        params.put("format", "wav");
        params.put("sample_rate", "16000");
        params.put("enable_punctuation_prediction", String.valueOf(this.isEnablePunctuationPrediction()));
        params.put("enable_inverse_text_normalization", String.valueOf(this.isEnableInverseTextNormalization()));
        params.put("enable_voice_detection", String.valueOf(this.isEnableVoiceDetection()));
        params.put("disfluency", String.valueOf(this.isDisfluency()));
        if (StringUtils.isNotBlank((CharSequence)this.getVocabularyId())) {
            params.put("vocabulary_id", this.getVocabularyId());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getCustomizationId())) {
            params.put("customization_id", this.getCustomizationId());
        }
        return UrlTool.buildQueryString(this.getBaseUrl(), params);
    }

    private String getBaseUrl() {
        return this.url;
    }

    @Override
    public Map<String, String> headers() {
        return Map.of();
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    private String getAppKey() {
        return this.appKey;
    }

    private String getVocabularyId() {
        return this.vocabularyId;
    }

    private String getCustomizationId() {
        return this.customizationId;
    }

    private boolean isEnablePunctuationPrediction() {
        return this.enablePunctuationPrediction;
    }

    private boolean isEnableInverseTextNormalization() {
        return this.enableInverseTextNormalization;
    }

    private boolean isEnableVoiceDetection() {
        return this.enableVoiceDetection;
    }

    private boolean isDisfluency() {
        return this.disfluency;
    }

    public static class Serializer
    implements SerializableSite<STTAliyunSite> {
        public static final Codec<STTAliyunSite> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(STTAliyunSite::id), (App)ResourceLocation.CODEC.fieldOf("icon").forGetter(STTAliyunSite::icon), (App)Codec.BOOL.fieldOf("enabled").forGetter(STTAliyunSite::enabled), (App)Codec.STRING.fieldOf("url").forGetter(STTAliyunSite::getBaseUrl), (App)Codec.STRING.fieldOf("secret_key").forGetter(STTAliyunSite::getSecretKey), (App)Codec.STRING.fieldOf("app_key").forGetter(STTAliyunSite::getAppKey), (App)Codec.STRING.optionalFieldOf("vocabulary_id", (Object)"").forGetter(STTAliyunSite::getVocabularyId), (App)Codec.STRING.optionalFieldOf("customization_id", (Object)"").forGetter(STTAliyunSite::getCustomizationId), (App)Codec.BOOL.optionalFieldOf("enable_punctuation_prediction", (Object)false).forGetter(STTAliyunSite::isEnablePunctuationPrediction), (App)Codec.BOOL.optionalFieldOf("enable_inverse_text_normalization", (Object)false).forGetter(STTAliyunSite::isEnableInverseTextNormalization), (App)Codec.BOOL.optionalFieldOf("enable_voice_detection", (Object)false).forGetter(STTAliyunSite::isEnableVoiceDetection), (App)Codec.BOOL.optionalFieldOf("disfluency", (Object)false).forGetter(STTAliyunSite::isDisfluency)).apply((Applicative)instance, STTAliyunSite::new));

        @Override
        public STTAliyunSite defaultSite() {
            return new STTAliyunSite(API_TYPE, SerializableSite.defaultIcon(API_TYPE), false, "https://nls-gateway-cn-shanghai.aliyuncs.com/stream/v1/asr", "", "", "", "", false, false, false, false);
        }

        @Override
        public Codec<STTAliyunSite> codec() {
            return CODEC;
        }
    }
}

