/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.data.inner.AttackListData;
import com.github.tartaricacid.touhoulittlemaid.entity.item.AbstractEntityFromItem;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.DefaultMonsterType;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.MonsterType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTaskData;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.task.AttackTaskConfigContainer;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface IAttackTask
extends IMaidTask {
    public static final String MAID_NO_ATTACK_TAG = "MaidNoAttack";

    public static Optional<? extends LivingEntity> findFirstValidAttackTarget(EntityMaid maid) {
        return maid.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).flatMap(mobs -> mobs.findClosest(e -> maid.canAttack((LivingEntity)e) && maid.isWithinRestriction(e.blockPosition())));
    }

    default public boolean canAttack(EntityMaid maid, LivingEntity target) {
        TamableAnimal tamableAnimal;
        ResourceLocation id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)target.getType());
        if (target instanceof ArmorStand || target instanceof AbstractEntityFromItem || target instanceof Player) {
            return false;
        }
        if (target instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)target).getOwnerUUID() != null) {
            return false;
        }
        if (target.getCustomName() != null && target.getCustomName().getString().startsWith(MAID_NO_ATTACK_TAG)) {
            return false;
        }
        if (((List)MaidConfig.MAID_ATTACK_IGNORE.get()).contains(id.toString())) {
            return false;
        }
        AttackListData attackListData = maid.getData(InitTaskData.ATTACK_LIST);
        MonsterType monsterType = attackListData != null && attackListData.attackGroups().containsKey(id) ? attackListData.attackGroups().get(id) : DefaultMonsterType.getMonsterType(target);
        return DefaultMonsterType.canAttack(maid, target, monsterType);
    }

    default public boolean hasExtraAttack(EntityMaid maid, Entity target) {
        return false;
    }

    default public boolean doExtraAttack(EntityMaid maid, Entity target) {
        return false;
    }

    default public boolean isWeapon(EntityMaid maid, ItemStack stack) {
        return false;
    }

    @Override
    default public MenuProvider getTaskConfigGuiProvider(EntityMaid maid) {
        final int entityId = maid.getId();
        return new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"Maid Attack Config Container");
            }

            public AbstractMaidContainer createMenu(int index, Inventory playerInventory, Player player) {
                return new AttackTaskConfigContainer(index, playerInventory, entityId);
            }

            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return false;
            }
        };
    }

    @Override
    default public boolean enablePanic(EntityMaid maid) {
        return false;
    }
}

