/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.mixin.accessor.CropBlockAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public interface ISpecialCropHandler {
    default public boolean isSeed(ItemStack stack) {
        return true;
    }

    default public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        return false;
    }

    default public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState, boolean isDestroyMode) {
        if (isDestroyMode) {
            maid.destroyBlock(cropPos);
        } else {
            Block block = cropState.getBlock();
            if (block instanceof CropBlockAccessor) {
                CropBlockAccessor crop = (CropBlockAccessor)block;
                BlockEntity blockEntity = cropState.hasBlockEntity() ? maid.level.getBlockEntity(cropPos) : null;
                maid.dropResourcesToMaidInv(cropState, maid.level, cropPos, blockEntity, maid, maid.getMainHandItem());
                maid.level.levelEvent(2001, cropPos, Block.getId((BlockState)cropState));
                if (cropState.hasProperty((Property)crop.tlmAgeProperty())) {
                    try {
                        cropState = (BlockState)cropState.trySetValue((Property)crop.tlmAgeProperty(), (Comparable)Integer.valueOf(0));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                maid.level.setBlock(cropPos, cropState, 3);
                maid.level.gameEvent((Entity)maid, (Holder)GameEvent.BLOCK_CHANGE, cropPos);
            }
        }
    }

    default public boolean canPlant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        BlockPos abovePos = basePos.above();
        BlockState aboveState = maid.level.getBlockState(abovePos);
        if (!aboveState.canBeReplaced() || aboveState.liquid()) {
            return false;
        }
        Item item = seed.getItem();
        if (item instanceof ItemNameBlockItem) {
            ItemNameBlockItem blockNamedItem = (ItemNameBlockItem)item;
            BlockState plantBlockState = blockNamedItem.getBlock().defaultBlockState();
            return plantBlockState.canSurvive((LevelReader)maid.level, abovePos);
        }
        return false;
    }

    default public ItemStack plant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        if (seed.getItem() instanceof ItemNameBlockItem) {
            maid.placeItemBlock(basePos.above(), seed);
        }
        return seed;
    }
}

