/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.item.ItemMaidBed;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBed;
import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockMaidBed
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final List<DyeColor> AVAILABLE_COLOR = (List)Util.make((Object)Lists.newArrayList(), list -> {
        list.add(DyeColor.WHITE);
        list.add(DyeColor.BLACK);
        list.add(DyeColor.YELLOW);
        list.add(DyeColor.BLUE);
        list.add(DyeColor.GREEN);
        list.add(DyeColor.PURPLE);
        list.add(DyeColor.PINK);
    });
    public static final EnumProperty<BedPart> PART = BlockStateProperties.BED_PART;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.OCCUPIED;
    protected static final VoxelShape BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);

    public BlockMaidBed() {
        super(BlockBehaviour.Properties.of().sound(SoundType.WOOD).sound(SoundType.WOOD).strength(0.2f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)BedPart.FOOT)).setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BASE;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemStack = player.getItemInHand(hand);
        Item item = itemStack.getItem();
        if (!(item instanceof DyeItem)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        DyeItem dyeItem = (DyeItem)item;
        DyeColor dyeColor = dyeItem.getDyeColor();
        if (!AVAILABLE_COLOR.contains(dyeColor)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockPos headPos = state.getValue(PART) == BedPart.HEAD ? pos : pos.relative((Direction)state.getValue((Property)FACING));
        BlockEntity blockEntity = level.getBlockEntity(headPos);
        if (!(blockEntity instanceof TileEntityMaidBed)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        TileEntityMaidBed bed = (TileEntityMaidBed)blockEntity;
        if (bed.getColor() == dyeColor) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        bed.setColor(dyeColor);
        if (!player.isCreative()) {
            itemStack.shrink(1);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == this.getNeighbourDirection((BedPart)stateIn.getValue(PART), (Direction)stateIn.getValue((Property)FACING))) {
            return facingState.is((Block)this) && facingState.getValue(PART) != stateIn.getValue(PART) ? (BlockState)stateIn.setValue((Property)OCCUPIED, (Comparable)((Boolean)facingState.getValue((Property)OCCUPIED))) : Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        BedPart bedpart;
        if (!worldIn.isClientSide && player.isCreative() && (bedpart = (BedPart)state.getValue(PART)) == BedPart.FOOT && (blockstate = worldIn.getBlockState(blockpos = pos.relative(this.getNeighbourDirection(bedpart, (Direction)state.getValue((Property)FACING))))).getBlock() == this && blockstate.getValue(PART) == BedPart.HEAD) {
            worldIn.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 35);
            worldIn.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART, OCCUPIED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        BlockPos relativePos = context.getClickedPos().relative(direction);
        return context.getLevel().getBlockState(relativePos).canBeReplaced(context) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction) : null;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (!worldIn.isClientSide) {
            BlockPos headPos = pos.relative((Direction)state.getValue((Property)FACING));
            worldIn.setBlock(headPos, (BlockState)state.setValue(PART, (Comparable)BedPart.HEAD), 3);
            worldIn.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)worldIn, pos, 3);
            BlockEntity blockEntity = worldIn.getBlockEntity(headPos);
            if (blockEntity instanceof TileEntityMaidBed) {
                TileEntityMaidBed bed = (TileEntityMaidBed)blockEntity;
                bed.setColor(ItemMaidBed.getColor(stack));
            }
        }
    }

    public void fallOn(Level worldIn, BlockState blockState, BlockPos pos, Entity entityIn, float fallDistance) {
        super.fallOn(worldIn, blockState, pos, entityIn, fallDistance * 0.5f);
    }

    public void updateEntityAfterFallOn(BlockGetter worldIn, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(worldIn, entity);
        } else {
            Vec3 movement = entity.getDeltaMovement();
            if (movement.y < 0.0) {
                double modulus = entity instanceof LivingEntity ? 1.0 : 0.8;
                entity.setDeltaMovement(movement.x, -movement.y * (double)0.66f * modulus, movement.z);
            }
        }
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long getSeed(BlockState state, BlockPos pos) {
        BlockPos blockpos = pos.relative((Direction)state.getValue((Property)FACING), state.getValue(PART) == BedPart.HEAD ? 0 : 1);
        return Mth.getSeed((int)blockpos.getX(), (int)pos.getY(), (int)blockpos.getZ());
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public boolean isBed(BlockState state, BlockGetter world, BlockPos pos, @Nullable LivingEntity entity) {
        if (entity instanceof EntityMaid) {
            return true;
        }
        assert (entity != null);
        return super.isBed(state, world, pos, entity);
    }

    private Direction getNeighbourDirection(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.getOpposite();
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return BlockMaidBed.simpleCodec(properties -> new BlockMaidBed());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        if (pState.getValue(PART) == BedPart.HEAD) {
            return new TileEntityMaidBed(pPos, pState);
        }
        return null;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        List stacks = super.getDrops(state, params);
        BlockEntity parameter = (BlockEntity)params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (parameter instanceof TileEntityMaidBed) {
            TileEntityMaidBed bed = (TileEntityMaidBed)parameter;
            stacks.forEach(stack -> {
                if (stack.getItem() instanceof ItemMaidBed) {
                    ItemMaidBed.setColor(bed.getColor(), stack);
                }
            });
        }
        return stacks;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockPos headPos;
        BlockEntity headEntity;
        ItemStack stack = super.getCloneItemStack(level, pos, state);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileEntityMaidBed) {
            TileEntityMaidBed bed = (TileEntityMaidBed)blockEntity;
            ItemMaidBed.setColor(bed.getColor(), stack);
        } else if (state.getValue(PART) == BedPart.FOOT && (headEntity = level.getBlockEntity(headPos = pos.relative((Direction)state.getValue((Property)FACING)))) instanceof TileEntityMaidBed) {
            TileEntityMaidBed bed = (TileEntityMaidBed)headEntity;
            ItemMaidBed.setColor(bed.getColor(), stack);
        }
        return stack;
    }
}

