/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.block.properties.PicnicMatPart;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemPicnicBasket;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityPicnicMat;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class BlockPicnicMat
extends Block
implements EntityBlock {
    public static final EnumProperty<PicnicMatPart> PART = EnumProperty.create((String)"part", PicnicMatPart.class);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final VoxelShape AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public BlockPicnicMat() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(2.0f, 3.0f).forceSolidOn().noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)PicnicMatPart.CENTER)));
    }

    public void startMaidSit(EntityMaid maid, BlockState state, Level worldIn, BlockPos pos) {
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            BlockEntity blockEntity = worldIn.getBlockEntity(pos);
            if (blockEntity instanceof TileEntityPicnicMat) {
                TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)blockEntity;
                if (!((PicnicMatPart)((Object)state.getValue(PART))).isCenter()) {
                    return;
                }
                boolean hasEmptySit = false;
                int sitIndex = -1;
                for (UUID uuid : picnicMat.getSitIds()) {
                    ++sitIndex;
                    if (uuid.equals(Util.NIL_UUID)) {
                        hasEmptySit = true;
                        break;
                    }
                    Entity oldSitEntity = serverLevel.getEntity(uuid);
                    if (oldSitEntity != null && oldSitEntity.isAlive()) continue;
                    hasEmptySit = true;
                    break;
                }
                if (hasEmptySit) {
                    Vec3 sitPosition = this.sitPosition(sitIndex);
                    EntitySit newSitEntity = new EntitySit(worldIn, Vec3.atLowerCornerWithOffset((Vec3i)pos, (double)sitPosition.x, (double)(sitPosition.y + 0.0625), (double)sitPosition.z), Type.ON_HOME_MEAL.getTypeName(), pos);
                    double y = sitPosition.z < 0.0 ? -1.0 : 1.0;
                    double x = sitPosition.x < 0.0 ? -1.0 : 1.0;
                    double rotOffset = Math.toDegrees(Math.atan2(y, x));
                    newSitEntity.setYRot((float)rotOffset + 90.0f);
                    worldIn.addFreshEntity((Entity)newSitEntity);
                    picnicMat.setSitId(sitIndex, newSitEntity.getUUID());
                    maid.startRiding(newSitEntity);
                }
            }
        }
    }

    private Vec3 sitPosition(int sitIndex) {
        switch (sitIndex) {
            case 0: {
                return new Vec3(2.0, 0.0, 2.0);
            }
            case 1: {
                return new Vec3(-1.0, 0.0, 2.0);
            }
            case 2: {
                return new Vec3(-1.0, 0.0, -1.0);
            }
        }
        return new Vec3(2.0, 0.0, -1.0);
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        if (worldIn.isClientSide) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (hand != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (!(blockEntity instanceof TileEntityPicnicMat)) {
            return ItemInteractionResult.FAIL;
        }
        TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)blockEntity;
        BlockPos centerPos = picnicMat.getCenterPos();
        BlockEntity blockEntity2 = worldIn.getBlockEntity(centerPos);
        if (!(blockEntity2 instanceof TileEntityPicnicMat)) {
            return ItemInteractionResult.FAIL;
        }
        TileEntityPicnicMat picnicMatCenter = (TileEntityPicnicMat)blockEntity2;
        ItemStack itemInHand = playerIn.getItemInHand(hand);
        if (itemInHand.getFoodProperties(null) != null) {
            return BlockPicnicMat.placeFood(itemInHand, playerIn, picnicMatCenter);
        }
        if (itemInHand.isEmpty() && playerIn.isDiscrete()) {
            return BlockPicnicMat.takeFood(playerIn, picnicMatCenter);
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    private static ItemInteractionResult placeFood(ItemStack food, Player playerIn, TileEntityPicnicMat picnicMatCenter) {
        int count = food.getCount();
        ItemStack resultStack = ItemHandlerHelper.insertItemStacked((IItemHandler)picnicMatCenter.getHandler(), (ItemStack)food.copy(), (boolean)false);
        picnicMatCenter.refresh();
        int shrinkCount = count - resultStack.getCount();
        if (shrinkCount <= 0) {
            return ItemInteractionResult.FAIL;
        }
        food.shrink(shrinkCount);
        return ItemInteractionResult.SUCCESS;
    }

    private static ItemInteractionResult takeFood(Player playerIn, TileEntityPicnicMat picnicMatCenter) {
        int size;
        ItemStackHandler handler = picnicMatCenter.getHandler();
        for (int i = size = handler.getSlots() - 1; i >= 0; --i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            ItemStack outputStack = handler.extractItem(i, handler.getSlotLimit(i), false);
            picnicMatCenter.refresh();
            ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)outputStack);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPicnicMat.handlePicnicMatRemove(world, pos, state);
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        BlockPicnicMat.handlePicnicMatRemove(world, pos, state);
        super.onBlockExploded(state, world, pos, explosion);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos centerPos = context.getClickedPos();
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                BlockPos searchPos = centerPos.offset(i, 0, j);
                if (context.getLevel().getBlockState(searchPos).canBeReplaced(context)) continue;
                return null;
            }
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (worldIn.isClientSide) {
            return;
        }
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                BlockEntity blockEntity;
                BlockPos searchPos = pos.offset(i, 0, j);
                if (!searchPos.equals((Object)pos)) {
                    worldIn.setBlock(searchPos, (BlockState)state.setValue(PART, (Comparable)((Object)PicnicMatPart.SIDE)), 3);
                }
                if (!((blockEntity = worldIn.getBlockEntity(searchPos)) instanceof TileEntityPicnicMat)) continue;
                TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)blockEntity;
                picnicMat.setCenterPos(pos);
            }
        }
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof TileEntityPicnicMat) {
            TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)blockEntity;
            if (stack.is((Item)InitItems.PICNIC_BASKET.get())) {
                picnicMat.setHandler(ItemPicnicBasket.getContainer(stack));
            }
        }
    }

    public boolean canSurvive(BlockState blockState, LevelReader level, BlockPos blockPos) {
        BlockPos below = blockPos.below();
        return level.getBlockState(below).isFaceSturdy((BlockGetter)level, below, Direction.UP);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityPicnicMat(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return true;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AABB;
    }

    private static void handlePicnicMatRemove(Level world, BlockPos pos, BlockState state) {
        if (world.isClientSide) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof TileEntityPicnicMat)) {
            return;
        }
        TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)blockEntity;
        BlockPos centerPos = picnicMat.getCenterPos();
        BlockEntity blockEntity2 = world.getBlockEntity(centerPos);
        if (blockEntity2 instanceof TileEntityPicnicMat) {
            TileEntityPicnicMat picnicMatCenter = (TileEntityPicnicMat)blockEntity2;
            ItemStack stack = ((Item)InitItems.PICNIC_BASKET.get()).getDefaultInstance();
            ItemPicnicBasket.setContainer(stack, picnicMatCenter.getHandler());
            BlockPicnicMat.popResource((Level)world, (BlockPos)centerPos, (ItemStack)stack);
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                for (UUID uuid : picnicMatCenter.getSitIds()) {
                    Entity entity;
                    if (uuid.equals(Util.NIL_UUID) || !((entity = serverLevel.getEntity(uuid)) instanceof EntitySit)) continue;
                    entity.discard();
                }
            }
        }
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                BlockPos offset = centerPos.offset(i, 0, j);
                if (!world.getBlockState(offset).is((Block)InitBlocks.PICNIC_MAT.get())) continue;
                world.setBlockAndUpdate(offset, Blocks.AIR.defaultBlockState());
            }
        }
    }
}

