/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;

public class ConditionalChair {
    private static final String EMPTY = "";
    private final List<String> idTest = Lists.newArrayList();
    private final String idPre;

    public ConditionalChair() {
        this.idPre = "chair$";
    }

    public void addTest(String name) {
        int preSize = this.idPre.length();
        if (name.length() <= preSize) {
            return;
        }
        String substring = name.substring(preSize);
        if (name.startsWith(this.idPre) && ResourceLocationUtil.isValidResourceLocation(substring)) {
            this.idTest.add(substring);
        }
    }

    public String doTest(Mob maid) {
        Entity vehicle = maid.getVehicle();
        if (!(vehicle instanceof EntityChair)) {
            return EMPTY;
        }
        EntityChair chair = (EntityChair)vehicle;
        return this.doIdTest(chair);
    }

    private String doIdTest(EntityChair chair) {
        if (this.idTest.isEmpty()) {
            return EMPTY;
        }
        String modelId = chair.getModelId();
        if (this.idTest.contains(modelId)) {
            return this.idPre + modelId;
        }
        return EMPTY;
    }
}

