/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.script;

import com.github.tartaricacid.touhoulittlemaid.api.animation.IChairData;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.WorldWrapper;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public final class EntityChairWrapper
implements IChairData {
    private final WorldWrapper world = new WorldWrapper();
    private EntityChair chair;

    public void setData(EntityChair chair) {
        this.chair = chair;
        this.world.setData(chair.level());
    }

    public void clearData() {
        this.chair = null;
        this.world.clearData();
    }

    @Override
    public boolean isRidingPlayer() {
        return this.chair.getControllingPassenger() instanceof Player;
    }

    @Override
    public boolean hasPassenger() {
        return !this.chair.getPassengers().isEmpty();
    }

    @Override
    public float getPassengerYaw() {
        if (!this.chair.getPassengers().isEmpty()) {
            return ((Entity)this.chair.getPassengers().get(0)).getYRot();
        }
        return 0.0f;
    }

    @Override
    public float getYaw() {
        return this.chair.getYRot();
    }

    @Override
    public float getPassengerPitch() {
        if (!this.chair.getPassengers().isEmpty()) {
            return ((Entity)this.chair.getPassengers().get(0)).getXRot();
        }
        return 0.0f;
    }

    @Override
    public WorldWrapper getWorld() {
        return this.world;
    }

    @Override
    public long getSeed() {
        return Math.abs(this.chair.getUUID().getLeastSignificantBits());
    }

    @Override
    @Deprecated
    public int getDim() {
        return this.chair.getDim();
    }
}

