/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.script;

import com.mojang.blaze3d.vertex.PoseStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GlWrapper {
    private static PoseStack poseStack;

    public static void setPoseStack(PoseStack poseStackIn) {
        poseStack = poseStackIn;
    }

    public static void clearPoseStack() {
        poseStack = null;
    }

    public static void translate(double x, double y, double z) {
        poseStack.translate(x, y, z);
    }

    public static void rotate(double angle, double x, double y, double z) {
        Vector3f vector3f = new Vector3f(GlWrapper.normalize(x), GlWrapper.normalize(y), GlWrapper.normalize(z));
        poseStack.mulPose(new Quaternionf().rotateAxis((float)angle * ((float)Math.PI / 180), (Vector3fc)vector3f));
    }

    public static void scale(double x, double y, double z) {
        poseStack.scale((float)x, (float)y, (float)z);
    }

    public static void pushMatrix() {
        poseStack.pushPose();
    }

    public static void popMatrix() {
        poseStack.popPose();
    }

    private static float normalize(double value) {
        if (value >= 1.0E-5) {
            return 1.0f;
        }
        if (value <= -1.0E-5) {
            return -1.0f;
        }
        return 0.0f;
    }
}

