/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.event;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemKappaCompass;
import com.github.tartaricacid.touhoulittlemaid.util.RenderHelper;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="touhou_little_maid", value={Dist.CLIENT})
public class CompassRenderEvent {
    @SubscribeEvent
    public static void onRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            BlockPos resetPos;
            BlockPos idlePos;
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            ItemStack stack = mc.player.getMainHandItem();
            if (stack.getItem() != InitItems.KAPPA_COMPASS.get() && (stack = mc.player.getOffhandItem()).getItem() != InitItems.KAPPA_COMPASS.get()) {
                return;
            }
            if (!ItemKappaCompass.hasKappaCompassData(stack)) {
                return;
            }
            ResourceLocation dimension = ItemKappaCompass.getDimension(stack);
            if (dimension != null && !mc.player.level.dimension().location().equals((Object)dimension)) {
                return;
            }
            BlockPos workPos = ItemKappaCompass.getPoint(Activity.WORK, stack);
            Vec3 camera = event.getCamera().getPosition().reverse();
            event.getPoseStack().pushPose();
            event.getPoseStack().translate(0.0f, 1.0f, 0.0f);
            if (workPos != null) {
                Vec3 centerPos = camera.add((double)workPos.getX() + 0.5, (double)workPos.getY() + 0.5, (double)workPos.getZ() + 0.5);
                double radius = (double)((Integer)MaidConfig.MAID_WORK_RANGE.get()).intValue() + 0.1;
                VertexConsumer buffer = mc.renderBuffers().bufferSource().getBuffer((RenderType)RenderType.LINES);
                RenderHelper.renderCylinder(event.getPoseStack(), buffer, centerPos, radius, 16, 1.0f, 0.0f, 0.0f);
                Vec3 textPos = new Vec3((double)workPos.getX() + 0.5, (double)(workPos.getY() + 2), (double)workPos.getZ() + 0.5);
                String text = I18n.get((String)"message.touhou_little_maid.kappa_compass.work_area", (Object[])new Object[0]);
                RenderHelper.renderFloatingText(event.getPoseStack(), text, textPos.x, textPos.y, textPos.z, 0xFF1111, 0.15f, true, -5.0f, false);
                RenderHelper.renderFloatingText(event.getPoseStack(), "\u25bc", textPos.x, textPos.y, textPos.z, 0xFF1111, 0.15f, true, 5.0f, false);
            }
            if ((idlePos = ItemKappaCompass.getPoint(Activity.IDLE, stack)) != null) {
                Vec3 centerPos = camera.add((double)idlePos.getX() + 0.5, (double)idlePos.getY() + 0.5, (double)idlePos.getZ() + 0.5);
                double radius = ((Integer)MaidConfig.MAID_IDLE_RANGE.get()).intValue();
                VertexConsumer buffer = mc.renderBuffers().bufferSource().getBuffer((RenderType)RenderType.LINES);
                RenderHelper.renderCylinder(event.getPoseStack(), buffer, centerPos, radius, 16, 0.0f, 1.0f, 0.0f);
                Vec3 textPos = new Vec3((double)idlePos.getX() + 0.5, (double)(idlePos.getY() + 2), (double)idlePos.getZ() + 0.5);
                if (idlePos.equals((Object)workPos)) {
                    textPos = textPos.add(0.0, 1.0, 0.0);
                } else if (workPos != null) {
                    Vec3 prePos = camera.add((double)workPos.getX() + 0.5, (double)workPos.getY() + 0.5, (double)workPos.getZ() + 0.5);
                    RenderHelper.renderLine(event.getPoseStack(), buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
                }
                String text = I18n.get((String)"message.touhou_little_maid.kappa_compass.idle_area", (Object[])new Object[0]);
                RenderHelper.renderFloatingText(event.getPoseStack(), text, textPos.x, textPos.y, textPos.z, 0x11FF11, 0.15f, true, -5.0f, false);
                RenderHelper.renderFloatingText(event.getPoseStack(), "\u25bc", textPos.x, textPos.y, textPos.z, 0x11FF11, 0.15f, true, 5.0f, false);
            }
            if ((resetPos = ItemKappaCompass.getPoint(Activity.REST, stack)) != null) {
                Vec3 centerPos = camera.add((double)resetPos.getX() + 0.5, (double)resetPos.getY() + 0.5, (double)resetPos.getZ() + 0.5);
                double radius = (double)((Integer)MaidConfig.MAID_SLEEP_RANGE.get()).intValue() - 0.1;
                VertexConsumer buffer = mc.renderBuffers().bufferSource().getBuffer((RenderType)RenderType.LINES);
                RenderHelper.renderCylinder(event.getPoseStack(), buffer, centerPos, radius, 16, 0.0f, 0.0f, 1.0f);
                Vec3 textPos = new Vec3((double)resetPos.getX() + 0.5, (double)(resetPos.getY() + 2), (double)resetPos.getZ() + 0.5);
                if (resetPos.equals((Object)idlePos)) {
                    textPos = textPos.add(0.0, 2.0, 0.0);
                } else if (idlePos != null && workPos != null) {
                    Vec3 prePos = camera.add((double)idlePos.getX() + 0.5, (double)idlePos.getY() + 0.5, (double)idlePos.getZ() + 0.5);
                    RenderHelper.renderLine(event.getPoseStack(), buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
                    prePos = camera.add((double)workPos.getX() + 0.5, (double)workPos.getY() + 0.5, (double)workPos.getZ() + 0.5);
                    RenderHelper.renderLine(event.getPoseStack(), buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
                }
                String text = I18n.get((String)"message.touhou_little_maid.kappa_compass.sleep_area", (Object[])new Object[0]);
                RenderHelper.renderFloatingText(event.getPoseStack(), text, textPos.x, textPos.y, textPos.z, 0x1111FF, 0.15f, true, -5.0f, false);
                RenderHelper.renderFloatingText(event.getPoseStack(), "\u25bc", textPos.x, textPos.y, textPos.z, 0x1111FF, 0.15f, true, 5.0f, false);
            }
            event.getPoseStack().popPose();
        }
    }
}

