/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.block;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.cache.CacheIconManager;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.DirectButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ImageButtonWithId;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.TouhouImageButton;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.SaveSwitcherDataPackage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityModelSwitcher;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class ModelSwitcherGui
extends Screen {
    private static final ResourceLocation BG = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/model_switcher.png");
    private static final ResourceLocation DEFAULT_MODEL_ID = ResourceLocation.parse((String)"touhou_little_maid:hakurei_reimu");
    private final List<TileEntityModelSwitcher.ModeInfo> infoList;
    private final BlockPos pos;
    private final int maxRow = 6;
    private final UUID bindUuid;
    protected int imageWidth = 256;
    protected int imageHeight = 166;
    protected int leftPos;
    protected int topPos;
    private EntityMaid maid = null;
    private EditBox description;
    private int selectedIndex = -1;
    private int page;

    public ModelSwitcherGui(TileEntityModelSwitcher switcher) {
        super((Component)Component.literal((String)"Model Switcher GUI"));
        this.infoList = switcher.getInfoList();
        this.pos = switcher.getBlockPos();
        this.bindUuid = switcher.getUuid();
        if (Minecraft.getInstance().level != null) {
            this.maid = new EntityMaid((Level)Minecraft.getInstance().level);
        }
    }

    protected void init() {
        this.clearWidgets();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.selectedIndex = this.selectedIndex < this.infoList.size() ? this.selectedIndex : -1;
        this.page = this.page <= (this.infoList.size() - 1) / 6 ? this.page : 0;
        this.addListChangeButton();
        this.addPageButton();
        this.addListButton();
        if (this.selectedIndex >= 0) {
            this.addEditButton();
        } else {
            this.description = null;
        }
    }

    private void addEditButton() {
        TileEntityModelSwitcher.ModeInfo info = this.infoList.get(this.selectedIndex);
        this.maid.setModelId(info.getModelId().toString());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.touhou_little_maid.button.skin"), b -> CacheIconManager.openModelSwitcherModelGui(this.maid, info, this)).pos(this.leftPos + 55, this.topPos + 15).size(76, 20).build());
        this.addRenderableWidget((GuiEventListener)new DirectButton(this.leftPos + 55, this.topPos + 38, 76, 20, info.getDirection(), b -> info.setDirection(((DirectButton)b).getDirection())));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"selectWorld.edit.save"), b -> PacketDistributor.sendToServer((CustomPacketPayload)new SaveSwitcherDataPackage(this.pos, this.infoList), (CustomPacketPayload[])new CustomPacketPayload[0])).pos(this.leftPos + 12, this.topPos + 135).size(121, 20).build());
        this.description = new EditBox(this.getMinecraft().font, this.leftPos + 12, this.topPos + 65, 119, 20, (Component)Component.translatable((String)"gui.touhou_little_maid.name_tag.edit_box"));
        this.description.setValue(info.getText());
        this.addWidget((GuiEventListener)this.description);
        this.setInitialFocus((GuiEventListener)this.description);
    }

    private void addListButton() {
        int startOffsetY = this.topPos + 24;
        for (int i = this.page * 6; i < Math.min(this.infoList.size(), (this.page + 1) * 6); ++i) {
            ImageButtonWithId button = i != this.selectedIndex ? new ImageButtonWithId(i, this.leftPos + 141, startOffsetY, 108, 19, 0, 166, 19, BG, b -> {
                this.selectedIndex = ((ImageButtonWithId)b).getIndex();
                this.init();
            }) : new ImageButtonWithId(i, this.leftPos + 141, startOffsetY, 108, 19, 108, 166, 0, BG, b -> {
                this.selectedIndex = -1;
                this.init();
            });
            this.addRenderableWidget((GuiEventListener)button);
            startOffsetY += 19;
        }
    }

    private void addPageButton() {
        this.addRenderableWidget((GuiEventListener)new TouhouImageButton(this.leftPos + 141, this.topPos + 7, 13, 16, 0, 204, 16, BG, b -> {
            if (this.page > 0) {
                --this.page;
                this.init();
            }
        }));
        this.addRenderableWidget((GuiEventListener)new TouhouImageButton(this.leftPos + 236, this.topPos + 7, 13, 16, 13, 204, 16, BG, b -> {
            if (this.page + 1 <= (this.infoList.size() - 1) / 6) {
                ++this.page;
                this.init();
            }
        }));
    }

    private void addListChangeButton() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.touhou_little_maid.model_switcher.list.add"), b -> {
            this.infoList.add(new TileEntityModelSwitcher.ModeInfo(DEFAULT_MODEL_ID, "", Direction.NORTH));
            this.init();
        }).pos(this.leftPos + 141, this.topPos + 139).size(53, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"selectWorld.deleteButton"), b -> {
            if (-1 < this.selectedIndex && this.selectedIndex < this.infoList.size()) {
                this.infoList.remove(this.selectedIndex);
                this.selectedIndex = -1;
                this.init();
            }
        }).pos(this.leftPos + 196, this.topPos + 139).size(53, 20).build());
    }

    public void resize(Minecraft pMinecraft, int pWidth, int pHeight) {
        String value = "";
        if (this.description != null) {
            value = this.description.getValue();
        }
        super.resize(pMinecraft, pWidth, pHeight);
        if (this.description != null) {
            this.description.setValue(value);
        }
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.maid == null) {
            return;
        }
        this.renderBackground(graphics, pMouseX, pMouseY, pPartialTick);
        graphics.blit(BG, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (this.bindUuid != null) {
            graphics.drawCenteredString(this.font, this.bindUuid.toString(), this.leftPos + 128, this.topPos - 10, 0xFFFFFF);
        } else {
            graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.model_switcher.uuid.empty"), this.leftPos + 128, this.topPos - 10, 0xFFFFFF);
        }
        graphics.drawCenteredString(this.font, String.format("%d/%d", this.page + 1, (this.infoList.size() - 1) / 6 + 1), this.leftPos + 193, this.topPos + 12, 0xFFFFFF);
        if (this.description != null) {
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)graphics, (int)(this.leftPos + 9), (int)(this.topPos + 8), (int)(this.leftPos + 54), (int)(this.topPos + 68), (int)24, (float)0.1f, (float)(this.leftPos + 45), (float)(this.topPos + 45), (LivingEntity)this.maid);
            this.description.render(graphics, pMouseX, pMouseY, pPartialTick);
        }
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, pMouseX, pMouseY, pPartialTick);
        }
        this.renderListButtonName(graphics);
    }

    private void renderListButtonName(GuiGraphics graphics) {
        int startOffsetY = this.topPos + 29;
        for (int i = this.page * 6; i < Math.min(this.infoList.size(), (this.page + 1) * 6); ++i) {
            String modelId = this.infoList.get(i).getModelId().toString();
            if (CustomPackLoader.MAID_MODELS.getInfo(modelId).isPresent()) {
                MaidModelInfo info = CustomPackLoader.MAID_MODELS.getInfo(modelId).get();
                MutableComponent component = Component.translatable((String)ParseI18n.getI18nKey(info.getName()));
                graphics.drawCenteredString(this.font, (Component)component, this.leftPos + 193, startOffsetY, 0xFFFFFF);
            }
            startOffsetY += 19;
        }
    }

    public void tick() {
        if (this.description != null && 0 <= this.selectedIndex && this.selectedIndex < this.infoList.size()) {
            this.infoList.get(this.selectedIndex).setText(this.description.getValue());
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.description != null && this.description.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused((GuiEventListener)this.description);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void insertText(String text, boolean overwrite) {
        if (this.description != null) {
            if (overwrite) {
                this.description.setValue(text);
            } else {
                this.description.insertText(text);
            }
        }
    }

    public void onClose() {
        PacketDistributor.sendToServer((CustomPacketPayload)new SaveSwitcherDataPackage(this.pos, this.infoList), (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.onClose();
    }
}

