/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.detail;

import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.TouhouImageButton;
import com.github.tartaricacid.touhoulittlemaid.client.model.DebugFloorModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.github.tartaricacid.touhoulittlemaid.util.Rectangle;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class AbstractModelDetailsGui<T extends LivingEntity, E extends IModelInfo>
extends Screen {
    private static final ResourceLocation BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/skin_detail.png");
    private static final ResourceLocation FLOOR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/entity/debug_floor.png");
    private static final int LEFT_MOUSE_BUTTON = 0;
    private static final int RIGHT_MOUSE_BUTTON = 1;
    private static final float SCALE_MAX = 360.0f;
    private static final float SCALE_MIN = 18.0f;
    private static final float PITCH_MAX = 90.0f;
    private static final float PITCH_MIN = -90.0f;
    private static Rectangle BACKGROUND_SIZE;
    private static Rectangle BOTTOM_STATUS_BAR_SIZE;
    private static Rectangle SIDE_MENU_SIZE;
    private static Rectangle TOP_STATUS_BAR_SIZE;
    protected final DebugFloorModel floorModel;
    protected T sourceEntity;
    protected volatile T guiEntity;
    protected E modelInfo;
    private float posX = 0.0f;
    private float posY = 25.0f;
    private float scale = 80.0f;
    private float yaw = 145.0f;
    private float pitch = 0.0f;
    private boolean showFloor = true;

    public AbstractModelDetailsGui(T sourceEntity, @Nullable T guiEntity, E modelInfo) {
        super((Component)Component.translatable((String)"gui.touhou_little_maid.custom_model_details_gui.title"));
        this.sourceEntity = sourceEntity;
        this.guiEntity = guiEntity;
        this.modelInfo = modelInfo;
        this.floorModel = new DebugFloorModel(Minecraft.getInstance().getEntityModels().bakeLayer(DebugFloorModel.LAYER));
    }

    protected abstract void applyReturnButtonLogic();

    protected abstract void initSideButton();

    protected abstract void renderExtraEntity(EntityRenderDispatcher var1, PoseStack var2, MultiBufferSource.BufferSource var3);

    protected void init() {
        this.clearWidgets();
        BACKGROUND_SIZE = new Rectangle(0.0, 0.0, this.width, this.height);
        BOTTOM_STATUS_BAR_SIZE = new Rectangle(0.0, this.height - 16, this.width, this.height);
        SIDE_MENU_SIZE = new Rectangle(0.0, 0.0, 132.0, this.height);
        TOP_STATUS_BAR_SIZE = new Rectangle(0.0, 0.0, this.width, 15.0);
        TouhouImageButton closeButton = new TouhouImageButton(this.width - 15, 0, 15, 15, 0, 24, 15, BUTTON_TEXTURE, b -> Minecraft.getInstance().setScreen(null));
        TouhouImageButton floorButton = new TouhouImageButton(this.width - 30, 0, 15, 15, 30, 24, 15, BUTTON_TEXTURE, b -> {
            this.showFloor = !this.showFloor;
        });
        TouhouImageButton returnButton = new TouhouImageButton(this.width - 45, 0, 15, 15, 15, 24, 15, BUTTON_TEXTURE, b -> this.applyReturnButtonLogic());
        this.addRenderableWidget((GuiEventListener)closeButton);
        this.addRenderableWidget((GuiEventListener)floorButton);
        this.addRenderableWidget((GuiEventListener)returnButton);
        this.initSideButton();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.minecraft == null) {
            return;
        }
        this.renderViewBg(graphics);
        this.renderEntity((this.width + 132) / 2, this.height / 2 + 50, graphics);
        this.renderBottomStatueBar(graphics);
        this.fillGradient(graphics, SIDE_MENU_SIZE, -31382229);
        this.fillGradient(graphics, TOP_STATUS_BAR_SIZE, -30921676);
        graphics.drawString(this.font, this.getTitle(), 6, 4, -5592406);
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    private void renderViewBg(GuiGraphics graphics) {
        this.fillGradient(graphics, BACKGROUND_SIZE, -32040675, -999);
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, -900.0f);
        graphics.drawString(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.skin_details.left_mouse"), (int)AbstractModelDetailsGui.SIDE_MENU_SIZE.w + 4, (int)AbstractModelDetailsGui.TOP_STATUS_BAR_SIZE.h + 4, -5592406, false);
        graphics.drawString(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.skin_details.right_mouse"), (int)AbstractModelDetailsGui.SIDE_MENU_SIZE.w + 4, (int)AbstractModelDetailsGui.TOP_STATUS_BAR_SIZE.h + 14, -5592406, false);
        graphics.drawString(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.skin_details.mouse_wheel"), (int)AbstractModelDetailsGui.SIDE_MENU_SIZE.w + 4, (int)AbstractModelDetailsGui.TOP_STATUS_BAR_SIZE.h + 24, -5592406, false);
        graphics.pose().popPose();
    }

    private void renderBottomStatueBar(GuiGraphics graphics) {
        this.fillGradient(graphics, BOTTOM_STATUS_BAR_SIZE, -30921676);
        String name = String.format("%s %s", "\u2714", I18n.get((String)ParseI18n.getI18nKey(this.modelInfo.getName()), (Object[])new Object[0]));
        String info = String.format("%d FPS %.2f%%", Minecraft.fps, Float.valueOf(this.scale * 100.0f / 80.0f));
        graphics.drawString(this.font, name, 136, this.height - 12, 13290196, false);
        graphics.drawString(this.font, info, this.width - this.font.width(info) - 4, this.height - 12, 13290196, false);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean isInRange;
        boolean isInWidthRange = 132.0 < mouseX && mouseX < (double)(this.width - 1);
        boolean isInHeightRange = 15.0 < mouseY && mouseY < (double)(this.height - 16);
        boolean bl = isInRange = isInWidthRange && isInHeightRange;
        if (this.minecraft == null || !isInRange) {
            return false;
        }
        if (button == 0) {
            this.yaw = (float)((double)this.yaw + dragX);
            this.changePitchValue((float)dragY);
        }
        if (button == 1) {
            this.posX = (float)((double)this.posX + dragX);
            this.posY = (float)((double)this.posY + dragY);
        }
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        boolean isInRange;
        boolean isInWidthRange = 132.0 < mouseX && mouseX < (double)(this.width - 1);
        boolean isInHeightRange = 15.0 < mouseY && mouseY < (double)(this.height - 16);
        boolean bl = isInRange = isInWidthRange && isInHeightRange;
        if (this.minecraft == null || !isInRange) {
            return false;
        }
        if (deltaY != 0.0) {
            this.changeScaleValue((float)deltaY * 0.07f);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    private void changePitchValue(float amount) {
        this.pitch = this.pitch - amount > 90.0f ? 90.0f : (this.pitch - amount < -90.0f ? -90.0f : (this.pitch -= amount));
    }

    private void changeScaleValue(float amount) {
        float tmp = this.scale + amount * this.scale;
        this.scale = Mth.clamp((float)tmp, (float)18.0f, (float)360.0f);
    }

    private void renderEntity(int middleWidth, int middleHeight, GuiGraphics graphics) {
        graphics.enableScissor(132, 15, this.width, this.height - 16);
        PoseStack viewStack = graphics.pose();
        viewStack.pushPose();
        viewStack.translate(0.0, 0.0, 1050.0);
        viewStack.scale(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack poseStack = new PoseStack();
        poseStack.translate((double)(this.posX + (float)middleWidth), (double)(this.posY + (float)middleHeight), 1000.0);
        poseStack.scale(this.scale, this.scale, -this.scale);
        Quaternionf zp = Axis.ZP.rotationDegrees(-180.0f);
        Quaternionf yp = Axis.YP.rotationDegrees(this.yaw);
        Quaternionf xp = Axis.XP.rotationDegrees(-this.pitch);
        yp.mul((Quaternionfc)xp);
        zp.mul((Quaternionfc)yp);
        poseStack.mulPose(zp);
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher manager = Minecraft.getInstance().getEntityRenderDispatcher();
        xp.conjugate();
        manager.overrideCameraOrientation(xp);
        manager.setRenderShadow(false);
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.runAsFancy(() -> {
            manager.render(this.guiEntity, 0.0, 0.0, 0.0, 0.0f, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false), poseStack, (MultiBufferSource)buffer, 0xF000F0);
            poseStack.translate(0.0, 0.5, 0.0);
            if (this.showFloor) {
                this.floorModel.renderToBuffer(poseStack, buffer.getBuffer(this.floorModel.renderType(FLOOR_TEXTURE)), 0xF000F0, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            this.renderExtraEntity(manager, poseStack, buffer);
        });
        buffer.endBatch();
        manager.setRenderShadow(true);
        viewStack.popPose();
        RenderSystem.applyModelViewMatrix();
        Lighting.setupFor3DItems();
        graphics.disableScissor();
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void fillGradient(GuiGraphics graphics, Rectangle vec4d, int color) {
        graphics.fillGradient((int)vec4d.x, (int)vec4d.y, (int)vec4d.w, (int)vec4d.h, color, color);
    }

    private void fillGradient(GuiGraphics graphics, Rectangle vec4d, int color, int zLevel) {
        graphics.fillGradient((int)vec4d.x, (int)vec4d.y, (int)vec4d.w, (int)vec4d.h, zLevel, color, color);
    }
}

