/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.config;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MaidConfigButton;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidConfigManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.PickType;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.config.MaidConfigContainer;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidSubConfigPackage;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNGuiHints;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;

@IPNPlayerSideOnly
@IPNGuiHints(value={@IPNGuiHint(button=IPNButton.SORT, horizontalOffset=-36, bottom=-12), @IPNGuiHint(button=IPNButton.SORT_COLUMNS, horizontalOffset=-24, bottom=-24), @IPNGuiHint(button=IPNButton.SORT_ROWS, horizontalOffset=-12, bottom=-36), @IPNGuiHint(button=IPNButton.SHOW_EDITOR, horizontalOffset=-5), @IPNGuiHint(button=IPNButton.SETTINGS, horizontalOffset=-5)})
public class MaidConfigContainerGui
extends AbstractMaidContainerGui<MaidConfigContainer> {
    private static final ResourceLocation ICON = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/maid_gui_config.png");
    private final MaidConfigManager.SyncNetwork syncNetwork = this.getMaid().getConfigManager().getSyncNetwork();

    public MaidConfigContainerGui(MaidConfigContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        super.renderBg(graphics, partialTicks, x, y);
        graphics.blit(ICON, this.leftPos + 80, this.topPos + 28, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Override
    protected void initAdditionWidgets() {
        int buttonLeft = this.leftPos + 86;
        int buttonTop = this.topPos + 52;
        this.addRenderableWidget((GuiEventListener)new MaidConfigButton(buttonLeft, buttonTop, (Component)Component.translatable((String)"gui.touhou_little_maid.maid_config.show_backpack"), (Component)Component.translatable((String)("gui.touhou_little_maid.maid_config.value." + this.syncNetwork.showBackpack())), button -> {
            this.syncNetwork.setShowBackpack(!this.syncNetwork.showBackpack());
            button.setValue((Component)Component.translatable((String)("gui.touhou_little_maid.maid_config.value." + this.syncNetwork.showBackpack())));
            PacketDistributor.sendToServer((CustomPacketPayload)new MaidSubConfigPackage(this.maid.getId(), this.syncNetwork), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
        this.addRenderableWidget((GuiEventListener)new MaidConfigButton(buttonLeft, buttonTop += 13, (Component)Component.translatable((String)"gui.touhou_little_maid.maid_config.show_back_item"), (Component)Component.translatable((String)("gui.touhou_little_maid.maid_config.value." + this.syncNetwork.showBackItem())), button -> {
            this.syncNetwork.setShowBackItem(!this.syncNetwork.showBackItem());
            button.setValue((Component)Component.translatable((String)("gui.touhou_little_maid.maid_config.value." + this.syncNetwork.showBackItem())));
            PacketDistributor.sendToServer((CustomPacketPayload)new MaidSubConfigPackage(this.maid.getId(), this.syncNetwork), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
        this.addRenderableWidget((GuiEventListener)new MaidConfigButton(buttonLeft, buttonTop += 13, (Component)Component.translatable((String)"gui.touhou_little_maid.maid_config.show_chat_bubble"), (Component)Component.translatable((String)("gui.touhou_little_maid.maid_config.value." + this.syncNetwork.showChatBubble())), button -> {
            this.syncNetwork.setShowChatBubble(!this.syncNetwork.showChatBubble());
            button.setValue((Component)Component.translatable((String)("gui.touhou_little_maid.maid_config.value." + this.syncNetwork.showChatBubble())));
            PacketDistributor.sendToServer((CustomPacketPayload)new MaidSubConfigPackage(this.maid.getId(), this.syncNetwork), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
        this.addRenderableWidget((GuiEventListener)new MaidConfigButton(buttonLeft, buttonTop += 13, (Component)Component.translatable((String)"gui.touhou_little_maid.maid_config.sound_frequency"), (Component)Component.literal((String)(Math.round(this.syncNetwork.soundFreq() * 100.0f) + "%")).withStyle(ChatFormatting.YELLOW), button -> {
            this.syncNetwork.setSoundFreq(this.syncNetwork.soundFreq() - 0.1f);
            button.setValue((Component)Component.literal((String)(Math.round(this.syncNetwork.soundFreq() * 100.0f) + "%")).withStyle(ChatFormatting.YELLOW));
            PacketDistributor.sendToServer((CustomPacketPayload)new MaidSubConfigPackage(this.maid.getId(), this.syncNetwork), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }, button -> {
            this.syncNetwork.setSoundFreq(this.syncNetwork.soundFreq() + 0.1f);
            button.setValue((Component)Component.literal((String)(Math.round(this.syncNetwork.soundFreq() * 100.0f) + "%")).withStyle(ChatFormatting.YELLOW));
            PacketDistributor.sendToServer((CustomPacketPayload)new MaidSubConfigPackage(this.maid.getId(), this.syncNetwork), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
        this.addRenderableWidget((GuiEventListener)new MaidConfigButton(buttonLeft, buttonTop += 13, (Component)Component.translatable((String)"gui.touhou_little_maid.maid_config.pick_type"), (Component)Component.translatable((String)PickType.getTransKey(this.syncNetwork.pickType())).withStyle(ChatFormatting.DARK_RED), button -> {
            this.syncNetwork.setPickType(PickType.getPreviousPickType(this.syncNetwork.pickType()));
            button.setValue((Component)Component.translatable((String)PickType.getTransKey(this.syncNetwork.pickType())).withStyle(ChatFormatting.DARK_RED));
            PacketDistributor.sendToServer((CustomPacketPayload)new MaidSubConfigPackage(this.maid.getId(), this.syncNetwork), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }, button -> {
            this.syncNetwork.setPickType(PickType.getNextPickType(this.syncNetwork.pickType()));
            button.setValue((Component)Component.translatable((String)PickType.getTransKey(this.syncNetwork.pickType())).withStyle(ChatFormatting.DARK_RED));
            PacketDistributor.sendToServer((CustomPacketPayload)new MaidSubConfigPackage(this.maid.getId(), this.syncNetwork), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
        this.addRenderableWidget((GuiEventListener)new MaidConfigButton(buttonLeft, buttonTop += 13, (Component)Component.translatable((String)"gui.touhou_little_maid.maid_config.open_door"), (Component)Component.translatable((String)("gui.touhou_little_maid.maid_config.value." + this.syncNetwork.openDoor())), button -> {
            this.syncNetwork.setOpenDoor(!this.syncNetwork.openDoor());
            button.setValue((Component)Component.translatable((String)("gui.touhou_little_maid.maid_config.value." + this.syncNetwork.openDoor())));
            PacketDistributor.sendToServer((CustomPacketPayload)new MaidSubConfigPackage(this.maid.getId(), this.syncNetwork), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
        this.addRenderableWidget((GuiEventListener)new MaidConfigButton(buttonLeft, buttonTop += 13, (Component)Component.translatable((String)"gui.touhou_little_maid.maid_config.open_fence_gate"), (Component)Component.translatable((String)("gui.touhou_little_maid.maid_config.value." + this.syncNetwork.openFenceGate())), button -> {
            this.syncNetwork.setOpenFenceGate(!this.syncNetwork.openFenceGate());
            button.setValue((Component)Component.translatable((String)("gui.touhou_little_maid.maid_config.value." + this.syncNetwork.openFenceGate())));
            PacketDistributor.sendToServer((CustomPacketPayload)new MaidSubConfigPackage(this.maid.getId(), this.syncNetwork), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
        this.addRenderableWidget((GuiEventListener)new MaidConfigButton(buttonLeft, buttonTop += 13, (Component)Component.translatable((String)"gui.touhou_little_maid.maid_config.active_climbing"), (Component)Component.translatable((String)("gui.touhou_little_maid.maid_config.value." + this.syncNetwork.activeClimbing())), button -> {
            this.syncNetwork.setActiveClimbing(!this.syncNetwork.activeClimbing());
            button.setValue((Component)Component.translatable((String)("gui.touhou_little_maid.maid_config.value." + this.syncNetwork.activeClimbing())));
            PacketDistributor.sendToServer((CustomPacketPayload)new MaidSubConfigPackage(this.maid.getId(), this.syncNetwork), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
    }

    @Override
    protected void renderAddition(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.button.maid_config"), this.leftPos + 167, this.topPos + 41, 0xFFFFFF);
    }
}

