/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.item;

import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.github.tartaricacid.touhoulittlemaid.network.message.FoxScrollPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetScrollPackage;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;

public class FoxScrollScreen
extends Screen {
    private static final int PER_PAGE_COUNT = 5;
    private final Map<String, List<FoxScrollPackage.FoxScrollData>> data;
    private int leftPos;
    private int topPos;
    private String selectDim;
    private int page = 0;

    public FoxScrollScreen(Map<String, List<FoxScrollPackage.FoxScrollData>> data) {
        super((Component)Component.literal((String)"Red Fox Scroll"));
        this.data = data;
        if (!this.data.isEmpty()) {
            this.selectDim = (String)this.data.keySet().stream().findFirst().get();
        }
    }

    protected void init() {
        this.clearWidgets();
        this.leftPos = (this.width - 400) / 2;
        this.topPos = (this.height - 208) / 2;
        this.addDimensionButtons();
        this.addPointButtons();
    }

    private void addPointButtons() {
        if (StringUtils.isNotBlank((CharSequence)this.selectDim) && this.data.containsKey(this.selectDim)) {
            List<FoxScrollPackage.FoxScrollData> scrollData = this.data.get(this.selectDim);
            if (scrollData.size() > 5) {
                this.addRenderableWidget((GuiEventListener)new FlatColorButton(this.leftPos + 400 - 20, this.topPos, 20, 20, (Component)Component.literal((String)"\u2191"), b -> {
                    if (this.page > 0) {
                        --this.page;
                        this.init();
                    }
                }));
                this.addRenderableWidget((GuiEventListener)new FlatColorButton(this.leftPos + 400 - 20, this.topPos + 208 - 20, 20, 20, (Component)Component.literal((String)"\u2193"), b -> {
                    if (this.page < (scrollData.size() - 1) / 5) {
                        ++this.page;
                        this.init();
                    }
                }));
            }
            int offsetIn = this.topPos;
            for (int i = this.page * 5; i < this.page * 5 + 5; ++i) {
                if (i >= scrollData.size()) continue;
                FoxScrollPackage.FoxScrollData info = scrollData.get(i);
                this.addRenderableWidget((GuiEventListener)new FlatColorButton(this.leftPos + 400 - 90, offsetIn + 11, 60, 20, (Component)Component.translatable((String)"gui.touhou_little_maid.fox_scroll.track"), b -> PacketDistributor.sendToServer((CustomPacketPayload)new SetScrollPackage(this.selectDim, info.pos()), (CustomPacketPayload[])new CustomPacketPayload[0])));
                offsetIn += 42;
            }
        }
    }

    private void addDimensionButtons() {
        int offset = this.topPos;
        for (String dim : this.data.keySet()) {
            MutableComponent name = Component.literal((String)dim);
            FlatColorButton dimButton = new FlatColorButton(this.leftPos, offset, 150, 19, (Component)name, b -> {
                this.selectDim = dim;
                this.page = 0;
                this.init();
            });
            if (dim.equals(this.selectDim)) {
                dimButton.setSelect(true);
            }
            this.addRenderableWidget((GuiEventListener)dimButton);
            offset += 21;
        }
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(graphics, pMouseX, pMouseY, pPartialTick);
        if (this.data.isEmpty()) {
            int x = this.width / 2;
            int y = this.height / 2 - 5;
            graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.fox_scroll.empty"), x, y, 0xFF0000);
            return;
        }
        this.renderMain(graphics);
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, pMouseX, pMouseY, pPartialTick);
        }
    }

    private void renderMain(GuiGraphics graphics) {
        if (StringUtils.isNotBlank((CharSequence)this.selectDim) && this.data.containsKey(this.selectDim)) {
            List<FoxScrollPackage.FoxScrollData> scrollData = this.data.get(this.selectDim);
            boolean inSameDim = this.selectDim.equals(this.getPlayerDimension());
            BlockPos playerPos = this.getPlayerPos();
            int offsetIn = this.topPos;
            for (int i = this.page * 5; i < this.page * 5 + 5; ++i) {
                MutableComponent distanceText;
                if (i >= scrollData.size()) continue;
                FoxScrollPackage.FoxScrollData info = scrollData.get(i);
                BlockPos pos = info.pos();
                if (inSameDim) {
                    int distance = (int)Math.sqrt(playerPos.distSqr((Vec3i)pos));
                    distanceText = Component.translatable((String)"gui.touhou_little_maid.fox_scroll.distance.same_dimension", (Object[])new Object[]{distance});
                } else {
                    distanceText = Component.translatable((String)"gui.touhou_little_maid.fox_scroll.distance.different_dimension");
                }
                MutableComponent posText = Component.translatable((String)"gui.touhou_little_maid.fox_scroll.position", (Object[])new Object[]{pos.toShortString()});
                graphics.fill(this.leftPos + 152, offsetIn, this.leftPos + 400 - 22, offsetIn + 40, -279420309);
                graphics.drawString(this.font, info.name(), this.leftPos + 160, offsetIn + 4, ChatFormatting.GOLD.getColor().intValue());
                graphics.drawString(this.font, (Component)posText, this.leftPos + 160, offsetIn + 16, ChatFormatting.GRAY.getColor().intValue(), false);
                graphics.drawString(this.font, (Component)distanceText, this.leftPos + 160, offsetIn + 28, ChatFormatting.GRAY.getColor().intValue(), false);
                offsetIn += 42;
            }
            if (scrollData.size() > 5) {
                String pageText = String.format("%d/%d", this.page + 1, (scrollData.size() - 1) / 5 + 1);
                graphics.drawCenteredString(this.font, pageText, this.leftPos + 400 - 8, this.topPos + 104 - 5, ChatFormatting.GRAY.getColor().intValue());
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private BlockPos getPlayerPos() {
        if (this.getMinecraft().player != null) {
            return this.getMinecraft().player.blockPosition();
        }
        return BlockPos.ZERO;
    }

    @Nullable
    private String getPlayerDimension() {
        if (this.getMinecraft().player != null) {
            return this.getMinecraft().player.level.dimension().location().toString();
        }
        return null;
    }
}

