/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendNameTagPackage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;

public class NameTagGui
extends Screen {
    final ResourceLocation CONFIRM_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/beacon/confirm");
    final ResourceLocation CANCEL_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/beacon/cancel");
    private final EntityMaid maid;
    private EditBox textField;
    private Button alwaysShowButton;
    private boolean alwaysShow = false;

    public NameTagGui(EntityMaid maid) {
        super((Component)Component.empty());
        this.maid = maid;
    }

    protected void init() {
        this.clearWidgets();
        int middleX = this.width / 2;
        int middleY = this.height / 2;
        this.textField = new EditBox(this.getMinecraft().font, middleX - 99, middleY - 26, 176, 20, (Component)Component.translatable((String)"gui.touhou_little_maid.name_tag.edit_box"));
        this.addWidget((GuiEventListener)this.textField);
        this.setInitialFocus((GuiEventListener)this.textField);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), this::sendDoneMessage).pos(middleX - 100, middleY).size(98, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), b -> this.onClose()).pos(middleX + 2, middleY).size(98, 20).build());
        this.alwaysShowButton = Button.builder((Component)Component.empty(), b -> {
            this.alwaysShow = !this.alwaysShow;
        }).pos(middleX + 80, middleY - 26).size(20, 20).build();
        this.addRenderableWidget((GuiEventListener)this.alwaysShowButton);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String value = this.textField.getValue();
        super.resize(minecraft, width, height);
        this.textField.setValue(value);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int middleX = this.width / 2;
        int middleY = this.height / 2;
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        this.textField.render(graphics, mouseX, mouseY, partialTicks);
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, mouseX, mouseY, partialTicks);
        }
        if (!this.alwaysShow) {
            graphics.blitSprite(this.CANCEL_SPRITE, middleX + 82, middleY - 26, 18, 18);
        } else {
            graphics.blitSprite(this.CONFIRM_SPRITE, middleX + 82, middleY - 26, 18, 18);
        }
        if (this.alwaysShowButton.isHovered()) {
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.tag.always_show"), mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.textField.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused((GuiEventListener)this.textField);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void insertText(String text, boolean overwrite) {
        if (overwrite) {
            this.textField.setValue(text);
        } else {
            this.textField.insertText(text);
        }
    }

    private void sendDoneMessage(Button button) {
        if (StringUtils.isNotBlank((CharSequence)this.textField.getValue())) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SendNameTagPackage(this.maid.getId(), this.textField.getValue(), this.alwaysShow), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.onClose();
    }
}

