/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.item;

import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.WirelessIOSlotButton;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import com.github.tartaricacid.touhoulittlemaid.network.message.WirelessIOSlotConfigPackage;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.compress.utils.Lists;

public class WirelessIOConfigSlotGui
extends Screen {
    private static final ResourceLocation SLOT = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/wireless_io_slot_config.png");
    private static final int SLOT_NUM = 38;
    private List<Boolean> configData;
    protected int imageWidth = 155;
    protected int imageHeight = 160;
    protected int leftPos;
    protected int topPos;

    protected WirelessIOConfigSlotGui(ItemStack wirelessIO) {
        super((Component)Component.literal((String)"Wireless IO Config Slot GUI"));
        int configDataSize;
        this.configData = ItemWirelessIO.getSlotConfig(wirelessIO);
        if (this.configData == null) {
            this.configData = Lists.newArrayList();
        }
        if ((configDataSize = this.configData.size()) < 38) {
            for (int i = configDataSize; i < 38; ++i) {
                this.configData.add(false);
            }
        }
    }

    protected void init() {
        WirelessIOSlotButton button;
        int row;
        WirelessIOSlotButton button2;
        int col;
        this.clearWidgets();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        int index = 0;
        for (col = 0; col < 6; ++col) {
            button2 = new WirelessIOSlotButton(index, this.leftPos + 8 + 18 * col, this.topPos + 8, 16, 16, this.configData);
            button2.initTextureValues(158, 0, 16, 16, SLOT);
            this.addRenderableWidget((GuiEventListener)button2);
            ++index;
        }
        for (col = 0; col < 6; ++col) {
            button2 = new WirelessIOSlotButton(index, this.leftPos + 8 + 18 * col, this.topPos + 30, 16, 16, this.configData);
            button2.initTextureValues(158, 0, 16, 16, SLOT);
            this.addRenderableWidget((GuiEventListener)button2);
            ++index;
        }
        for (row = 0; row < 2; ++row) {
            for (int col2 = 0; col2 < 6; ++col2) {
                button = new WirelessIOSlotButton(index, this.leftPos + 8 + 18 * col2, this.topPos + 53 + 18 * row, 16, 16, this.configData);
                button.initTextureValues(158, 0, 16, 16, SLOT);
                this.addRenderableWidget((GuiEventListener)button);
                ++index;
            }
        }
        for (row = 0; row < 2; ++row) {
            for (int col3 = 0; col3 < 6; ++col3) {
                button = new WirelessIOSlotButton(index, this.leftPos + 8 + 18 * col3, this.topPos + 94 + 18 * row, 16, 16, this.configData);
                button.initTextureValues(158, 0, 16, 16, SLOT);
                this.addRenderableWidget((GuiEventListener)button);
                ++index;
            }
        }
        for (row = 0; row < 2; ++row) {
            WirelessIOSlotButton button3 = new WirelessIOSlotButton(index, this.leftPos + 131, this.topPos + 8 + 18 * row, 16, 16, this.configData);
            button3.initTextureValues(158, 0, 16, 16, SLOT);
            this.addRenderableWidget((GuiEventListener)button3);
            ++index;
        }
        Button confirm = Button.builder((Component)Component.translatable((String)"gui.done"), b -> PacketDistributor.sendToServer((CustomPacketPayload)new WirelessIOSlotConfigPackage(this.configData), (CustomPacketPayload[])new CustomPacketPayload[0])).pos(this.leftPos, this.topPos + 140).size(60, 20).build();
        Button cancel = Button.builder((Component)Component.translatable((String)"gui.cancel"), b -> PacketDistributor.sendToServer((CustomPacketPayload)new WirelessIOSlotConfigPackage(), (CustomPacketPayload[])new CustomPacketPayload[0])).pos(this.leftPos + 62, this.topPos + 140).size(60, 20).build();
        this.addRenderableWidget((GuiEventListener)confirm);
        this.addRenderableWidget((GuiEventListener)cancel);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBg(graphics, mouseX, mouseY, partialTicks);
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    private void renderBg(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.blit(SLOT, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }
}

