/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.item;

import com.github.tartaricacid.touhoulittlemaid.client.gui.item.WirelessIOConfigSlotGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.TouhouImageButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.WirelessIOButton;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.other.WirelessIOContainer;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import com.github.tartaricacid.touhoulittlemaid.network.message.WirelessIOGuiPackage;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;
import org.anti_ad.mc.ipn.api.IPNIgnore;

@IPNIgnore
public class WirelessIOContainerGui
extends AbstractContainerScreen<WirelessIOContainer> {
    private static final ResourceLocation MAIN = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/wireless_io.png");
    private boolean isMaidToChest;
    private boolean isBlacklist;

    public WirelessIOContainerGui(WirelessIOContainer container, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)container, inv, titleIn);
        this.isMaidToChest = ItemWirelessIO.isMaidToChest(container.getWirelessIO());
        this.isBlacklist = ItemWirelessIO.isBlacklist(container.getWirelessIO());
    }

    protected void init() {
        super.init();
        this.clearWidgets();
        WirelessIOButton ioModeToggle = new WirelessIOButton(this.leftPos + 23, this.topPos + 34, 18, 18, this.isMaidToChest, (x, y) -> {
            this.isMaidToChest = !this.isMaidToChest;
            PacketDistributor.sendToServer((CustomPacketPayload)new WirelessIOGuiPackage(this.isMaidToChest, this.isBlacklist), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }, (m, x, y) -> m.renderTooltip(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.wireless_io.io_mode"), x, y));
        ioModeToggle.initTextureValues(194, 32, -18, 18, MAIN);
        WirelessIOButton filterModeToggle = new WirelessIOButton(this.leftPos + 136, this.topPos + 26, 16, 16, this.isBlacklist, (x, y) -> {
            this.isBlacklist = !this.isBlacklist;
            PacketDistributor.sendToServer((CustomPacketPayload)new WirelessIOGuiPackage(this.isMaidToChest, this.isBlacklist), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }, (m, x, y) -> m.renderTooltip(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.wireless_io.filter_mode"), x, y));
        filterModeToggle.initTextureValues(176, 0, 16, 16, MAIN);
        TouhouImageButton configButton = new TouhouImageButton(this.leftPos + 136, this.topPos + 44, 16, 16, 208, 0, 16, MAIN, 256, 256, buttons -> this.getMinecraft().setScreen((Screen)new WirelessIOConfigSlotGui(((WirelessIOContainer)this.menu).getWirelessIO())));
        configButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.touhou_little_maid.wireless_io.config_slot")));
        this.addRenderableWidget((GuiEventListener)filterModeToggle);
        this.addRenderableWidget((GuiEventListener)configButton);
        this.addRenderableWidget((GuiEventListener)ioModeToggle);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        super.renderTransparentBackground(graphics);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)MAIN);
        graphics.blit(MAIN, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (this.isBlacklist) {
            graphics.blit(MAIN, this.leftPos + 61, this.topPos + 15, 0, 166, 54, 55);
        }
    }

    protected void renderLabels(GuiGraphics graphics, int x, int y) {
    }
}

