/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.mod;

import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class PatchouliWarningScreen
extends Screen {
    private final String patchouliUrl = "https://www.curseforge.com/minecraft/mc-mods/patchouli";
    private final Screen lastScreen;
    private MultiLineLabel message = MultiLineLabel.EMPTY;

    protected PatchouliWarningScreen(Screen lastScreen) {
        super((Component)Component.literal((String)"Patchouli"));
        this.lastScreen = lastScreen;
    }

    public static void open() {
        Minecraft.getInstance().setScreen((Screen)new PatchouliWarningScreen(Minecraft.getInstance().screen));
    }

    protected void init() {
        int posX = (this.width - 200) / 2;
        int posY = this.height / 2;
        this.message = MultiLineLabel.create((Font)this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.patchouli_warning.tips"), (int)300);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.touhou_little_maid.patchouli_warning.download"), b -> this.openUrl("https://www.curseforge.com/minecraft/mc-mods/patchouli")).bounds(posX, posY - 15, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_BACK, pressed -> Minecraft.getInstance().setScreen(this.lastScreen)).bounds(posX, posY + 50, 200, 20).build());
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(graphics, pMouseX, pMouseY, pPartialTick);
        this.message.renderCentered(graphics, this.width / 2, 80);
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
    }

    private void openUrl(String url) {
        if (StringUtils.isNotBlank((CharSequence)url) && this.minecraft != null) {
            this.minecraft.setScreen((Screen)new ConfirmLinkScreen(yes -> {
                if (yes) {
                    Util.getPlatform().openUri(url);
                }
                this.minecraft.setScreen((Screen)this);
            }, url, true));
        }
    }
}

