/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class FlatColorButton
extends Button {
    private List<Component> tooltips;
    protected boolean isSelect = false;

    public FlatColorButton(int pX, int pY, int pWidth, int pHeight, Component pMessage, Button.OnPress pOnPress) {
        super(pX, pY, pWidth, pHeight, pMessage, pOnPress, DEFAULT_NARRATION);
    }

    public FlatColorButton setTooltips(String key) {
        this.tooltips = Collections.singletonList(Component.translatable((String)key));
        return this;
    }

    public FlatColorButton setTooltips(List<Component> tooltips) {
        this.tooltips = tooltips;
        return this;
    }

    public void renderToolTip(GuiGraphics graphics, Screen screen, int pMouseX, int pMouseY) {
        if (this.isHovered && this.tooltips != null) {
            graphics.renderComponentTooltip(screen.getMinecraft().font, this.tooltips, pMouseX, pMouseY);
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pPartialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        if (this.isSelect) {
            graphics.fillGradient(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -14774017, -14774017);
        } else {
            graphics.fillGradient(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -12369342, -12369342);
        }
        if (this.isHoveredOrFocused()) {
            graphics.fillGradient(this.getX(), this.getY() + 1, this.getX() + 1, this.getY() + this.height - 1, -790560, -790560);
            graphics.fillGradient(this.getX(), this.getY(), this.getX() + this.width, this.getY() + 1, -790560, -790560);
            graphics.fillGradient(this.getX() + this.width - 1, this.getY() + 1, this.getX() + this.width, this.getY() + this.height - 1, -790560, -790560);
            graphics.fillGradient(this.getX(), this.getY() + this.height - 1, this.getX() + this.width, this.getY() + this.height, -790560, -790560);
        }
        int i = this.getFGColor();
        this.renderString(graphics, minecraft.font, i | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    public void renderString(GuiGraphics graphics, Font font, int pColor) {
        graphics.drawCenteredString(font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, 15986656);
    }

    public void setSelect(boolean select) {
        this.isSelect = select;
    }
}

