/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.api.client.gui.ITooltipButton;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MaidTabButton
extends Button
implements ITooltipButton {
    private static final ResourceLocation SIDE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/maid_gui_side.png");
    private final int left;
    private final List<Component> tooltips;

    public MaidTabButton(int x, int y, int left, String key, Button.OnPress onPressIn) {
        super(Button.builder((Component)Component.empty(), (Button.OnPress)onPressIn).pos(x, y).size(24, 26));
        this.left = left;
        this.tooltips = Lists.newArrayList((Object[])new Component[]{Component.translatable((String)("gui.touhou_little_maid.button." + key)), Component.translatable((String)("gui.touhou_little_maid.button." + key + ".desc"))});
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableDepthTest();
        if (!this.active) {
            graphics.blit(SIDE, this.getX(), this.getY(), (float)this.left, 21.0f, this.width, this.height, 256, 256);
        }
        graphics.blit(SIDE, this.getX() + 4, this.getY() + 6, (float)this.left, 47.0f, 16, 16, 256, 256);
    }

    @Override
    public boolean isTooltipHovered() {
        return this.active && this.isHovered();
    }

    @Override
    public void renderTooltip(GuiGraphics graphics, Minecraft mc, int mouseX, int mouseY) {
        Font font = Minecraft.getInstance().font;
        graphics.renderComponentTooltip(font, this.tooltips, mouseX, mouseY);
    }
}

