/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidConfigPackage;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.schedule.Activity;
import net.neoforged.neoforge.network.PacketDistributor;

public class ScheduleButton<T extends AbstractMaidContainer>
extends Button {
    private static final ResourceLocation BUTTON = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/maid_gui_button.png");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00");
    private final EntityMaid maid;
    private MaidSchedule mode;

    public ScheduleButton(int x, int y, AbstractMaidContainerGui<T> gui) {
        super(Button.builder((Component)Component.empty(), b -> {}).pos(x, y).size(61, 13));
        this.maid = gui.getMaid();
        this.mode = this.maid.getSchedule();
    }

    public void onPress() {
        int index = this.mode.ordinal() + 1;
        int length = MaidSchedule.values().length;
        this.mode = MaidSchedule.values()[index % length];
        PacketDistributor.sendToServer((CustomPacketPayload)new MaidConfigPackage(this.maid.getId(), this.maid.isHomeModeEnable(), this.maid.isPickup(), this.maid.isRideable(), this.mode), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableDepthTest();
        graphics.blit(BUTTON, this.getX(), this.getY(), 82.0f, (float)(43 + 14 * this.mode.ordinal()), this.width, this.height, 256, 256);
    }

    public List<Component> getTooltips() {
        int time = (int)(this.maid.level().getDayTime() % 24000L);
        int hour = (time / 1000 + 6) % 24;
        int minute = time % 1000 * 60 / 1000;
        Activity activity = this.maid.getScheduleDetail();
        ArrayList out = Lists.newArrayList();
        out.add(Component.literal((String)String.format("\u00a7n%s\u00a77 %s:%s", this.getScheduleTransText(), DECIMAL_FORMAT.format(hour), DECIMAL_FORMAT.format(minute))));
        switch (this.mode) {
            case ALL: {
                out.add(Component.literal((String)String.format("\u00a7a\u2588 00:00-24:00 %s", this.getActivityTransText(Activity.WORK))));
                break;
            }
            case NIGHT: {
                if (activity == Activity.WORK) {
                    out.add(Component.literal((String)String.format("\u00a7a\u2588 18:00-06:00 %s", this.getActivityTransText(Activity.WORK))));
                } else {
                    out.add(Component.literal((String)String.format("\u00a78\u2588 18:00-06:00 %s", this.getActivityTransText(Activity.WORK))));
                }
                if (activity == Activity.REST) {
                    out.add(Component.literal((String)String.format("\u00a7a\u2588 06:00-14:00 %s", this.getActivityTransText(Activity.REST))));
                } else {
                    out.add(Component.literal((String)String.format("\u00a78\u2588 06:00-14:00 %s", this.getActivityTransText(Activity.REST))));
                }
                if (activity == Activity.IDLE) {
                    out.add(Component.literal((String)String.format("\u00a7a\u2588 14:00-18:00 %s", this.getActivityTransText(Activity.IDLE))));
                    break;
                }
                out.add(Component.literal((String)String.format("\u00a78\u2588 14:00-18:00 %s", this.getActivityTransText(Activity.IDLE))));
                break;
            }
            default: {
                if (activity == Activity.WORK) {
                    out.add(Component.literal((String)String.format("\u00a7a\u2588 06:00-18:00 %s", this.getActivityTransText(Activity.WORK))));
                } else {
                    out.add(Component.literal((String)String.format("\u00a78\u2588 06:00-18:00 %s", this.getActivityTransText(Activity.WORK))));
                }
                if (activity == Activity.IDLE) {
                    out.add(Component.literal((String)String.format("\u00a7a\u2588 18:00-22:00 %s", this.getActivityTransText(Activity.IDLE))));
                } else {
                    out.add(Component.literal((String)String.format("\u00a78\u2588 18:00-22:00 %s", this.getActivityTransText(Activity.IDLE))));
                }
                if (activity == Activity.REST) {
                    out.add(Component.literal((String)String.format("\u00a7a\u2588 22:00-06:00 %s", this.getActivityTransText(Activity.REST))));
                    break;
                }
                out.add(Component.literal((String)String.format("\u00a78\u2588 22:00-06:00 %s", this.getActivityTransText(Activity.REST))));
            }
        }
        out.add(Component.translatable((String)"tooltips.touhou_little_maid.schedule.desc"));
        return out;
    }

    public String getScheduleTransText() {
        return I18n.get((String)("gui.touhou_little_maid.schedule." + this.mode.name().toLowerCase(Locale.US)), (Object[])new Object[0]);
    }

    public String getActivityTransText(Activity activity) {
        return I18n.get((String)("gui.touhou_little_maid.activity." + activity.getName()), (Object[])new Object[0]);
    }
}

