/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.github.tartaricacid.touhoulittlemaid.client.sound.data.SoundData;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SoundElementButton
extends FlatColorButton {
    private final ResourceLocation soundEvent;
    private final int soundCount;
    private final boolean otherColor;

    public SoundElementButton(int pX, int pY, int pWidth, int pHeight, ResourceLocation soundEvent, List<SoundData> sounds, boolean otherColor, Button.OnPress pOnPress) {
        super(pX, pY, pWidth, pHeight, (Component)Component.translatable((String)soundEvent.toLanguageKey("button")), pOnPress);
        this.soundEvent = soundEvent;
        this.soundCount = sounds.size();
        this.otherColor = otherColor;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pPartialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        if (this.otherColor) {
            graphics.fillGradient(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, 1604230814, 1604230814);
        } else {
            graphics.fillGradient(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -12369342, -12369342);
        }
        if (this.isHoveredOrFocused()) {
            graphics.fillGradient(this.getX(), this.getY() + 1, this.getX() + 1, this.getY() + this.height - 1, -790560, -790560);
            graphics.fillGradient(this.getX(), this.getY(), this.getX() + this.width, this.getY() + 1, -790560, -790560);
            graphics.fillGradient(this.getX() + this.width - 1, this.getY() + 1, this.getX() + this.width, this.getY() + this.height - 1, -790560, -790560);
            graphics.fillGradient(this.getX(), this.getY() + this.height - 1, this.getX() + this.width, this.getY() + this.height, -790560, -790560);
        }
        int i = this.getFGColor();
        this.renderString(graphics, minecraft.font, i | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    @Override
    public void renderString(GuiGraphics graphics, Font font, int pColor) {
        graphics.drawString(font, "\u25b7", this.getX() + 5, this.getY() + (this.height - 8) / 2, 0xE0E0E0);
        graphics.drawString(font, this.getMessage(), this.getX() + 15, this.getY() + (this.height - 8) / 2, 0xFAFAFA);
        String countText = this.soundCount + "\u266b";
        int countTextWidth = font.width(countText);
        graphics.drawString(font, countText, this.getX() + this.getWidth() - countTextWidth - 5, this.getY() + (this.height - 8) / 2, 0xCCCCCC);
    }

    public ResourceLocation getSoundEvent() {
        return this.soundEvent;
    }
}

