/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.sound.pojo.SoundPackInfo;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class SoundPackButton
extends FlatColorButton {
    private static final ResourceLocation ICON = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/maid_custom_sound.png");
    private final SoundPackInfo info;
    private boolean isUse = false;

    public SoundPackButton(int pX, int pY, SoundPackInfo info, Button.OnPress onPress) {
        super(pX, pY, 230, 43, (Component)Component.empty(), onPress);
        this.info = info;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pPartialTick) {
        super.renderWidget(graphics, mouseX, mouseY, pPartialTick);
        ResourceLocation icon = this.info.getIcon();
        if (icon == null) {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON);
            graphics.blit(ICON, this.getX() + 4, this.getY() + 5, 0.0f, 16.0f, 32, 32, 256, 256);
        } else {
            if (this.info.getIconAnimation() == CustomModelPack.AnimationState.UNCHECK) {
                this.checkIconAnimation(this.info, icon);
            }
            if (this.info.getIconAnimation() == CustomModelPack.AnimationState.FALSE) {
                graphics.blit(icon, this.getX() + 4, this.getY() + 5, 0.0f, 0.0f, 32, 32, 32, 32);
            } else {
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon);
                int time = this.getTickTime() / this.info.getIconDelay();
                int iconIndex = time % this.info.getIconAspectRatio();
                graphics.blit(icon, this.getX() + 4, this.getY() + 5, 0.0f, (float)(iconIndex * 32), 32, 32, 32, 32 * this.info.getIconAspectRatio());
            }
        }
        if (this.isUse) {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON);
            graphics.blit(ICON, this.getX() + this.getWidth() - 20, this.getY() + 13, 32.0f, 0.0f, 16, 16, 256, 256);
        }
    }

    @Override
    public void renderString(GuiGraphics graphics, Font font, int pColor) {
        int startX = this.getX() + 42;
        int startY = this.getY() + 7;
        MutableComponent packName = ParseI18n.parse(this.info.getPackName());
        String version = this.info.getVersion();
        List<String> author = this.info.getAuthor();
        String date = this.info.getDate();
        graphics.drawString(font, (Component)packName, startX, startY, ChatFormatting.WHITE.getColor().intValue());
        if (StringUtils.isNotBlank((CharSequence)version)) {
            int titleWidth = font.width((FormattedText)packName);
            graphics.drawString(font, "\u00a7nv" + version, startX + titleWidth + 5, startY, ChatFormatting.AQUA.getColor().intValue());
        }
        if (!author.isEmpty()) {
            String authorListText = StringUtils.joinWith((String)I18n.get((String)"gui.touhou_little_maid.resources_download.author.delimiter", (Object[])new Object[0]), (Object[])new Object[]{author});
            String authorText = I18n.get((String)"gui.touhou_little_maid.resources_download.author", (Object[])new Object[]{authorListText});
            graphics.drawString(font, authorText, startX, startY += 10, ChatFormatting.GOLD.getColor().intValue());
        }
        if (StringUtils.isNotBlank((CharSequence)date)) {
            MutableComponent dateText = Component.translatable((String)"gui.touhou_little_maid.skin.text.date", (Object[])new Object[]{date});
            graphics.drawString(font, (Component)dateText, startX, startY += 10, ChatFormatting.GREEN.getColor().intValue());
        }
    }

    private int getTickTime() {
        return (int)System.currentTimeMillis() / 50;
    }

    private void checkIconAnimation(SoundPackInfo info, ResourceLocation icon) {
        AbstractTexture iconText = Minecraft.getInstance().getTextureManager().getTexture(icon);
        if (iconText instanceof SizeTexture) {
            int height;
            int width = ((SizeTexture)iconText).getWidth();
            if (width >= (height = ((SizeTexture)iconText).getHeight())) {
                info.setIconAnimation(CustomModelPack.AnimationState.FALSE);
            } else {
                info.setIconAnimation(CustomModelPack.AnimationState.TRUE);
                info.setIconAspectRatio(height / width);
            }
        } else {
            info.setIconAnimation(CustomModelPack.AnimationState.FALSE);
        }
    }

    public boolean isUse() {
        return this.isUse;
    }

    public void setUse(boolean use) {
        this.isUse = use;
    }
}

