/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.compat.oculus.OculusCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.MaidFishingHook;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MaidFishingHookRenderer<T extends MaidFishingHook>
extends EntityRenderer<T> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/fishing_hook.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutout((ResourceLocation)TEXTURE_LOCATION);

    public MaidFishingHookRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(T fishingHook, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        EntityMaid maid = ((MaidFishingHook)((Object)fishingHook)).getMaidOwner();
        if (maid == null) {
            return;
        }
        poseStack.pushPose();
        this.renderBobber(fishingHook, poseStack, buffer, packedLight);
        this.renderFishingLine(fishingHook, partialTicks, poseStack, buffer, maid);
        poseStack.popPose();
        super.render(fishingHook, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected void renderBobber(T fishingHook, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        PoseStack.Pose lastedPose = poseStack.last();
        VertexConsumer consumer = buffer.getBuffer(RENDER_TYPE);
        this.vertex(consumer, lastedPose, packedLight, 0.0f, 0, 0, 1);
        this.vertex(consumer, lastedPose, packedLight, 1.0f, 0, 1, 1);
        this.vertex(consumer, lastedPose, packedLight, 1.0f, 1, 1, 0);
        this.vertex(consumer, lastedPose, packedLight, 0.0f, 1, 0, 0);
        poseStack.popPose();
    }

    protected float[] getLineColor(T fishingHook) {
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    protected void renderFishingLine(T fishingHook, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, EntityMaid maid) {
        float lerpBodyRot;
        Entity entity = maid.getVehicle();
        if (entity instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity;
            lerpBodyRot = Mth.lerp((float)partialTicks, (float)vehicle.yBodyRotO, (float)vehicle.yBodyRot) * ((float)Math.PI / 180);
        } else {
            lerpBodyRot = Mth.lerp((float)partialTicks, (float)maid.yBodyRotO, (float)maid.yBodyRot) * ((float)Math.PI / 180);
        }
        double sin = Mth.sin((float)lerpBodyRot);
        double cos = Mth.cos((float)lerpBodyRot);
        double x1 = Mth.lerp((double)partialTicks, (double)maid.xo, (double)maid.getX()) - cos * 0.35 - sin * 0.8;
        double y1 = maid.yo + (double)maid.getEyeHeight() + (maid.getY() - maid.yo) * (double)partialTicks - 0.45;
        double z1 = Mth.lerp((double)partialTicks, (double)maid.zo, (double)maid.getZ()) - sin * 0.35 + cos * 0.8;
        double x2 = Mth.lerp((double)partialTicks, (double)((MaidFishingHook)((Object)fishingHook)).xo, (double)fishingHook.getX());
        double y2 = Mth.lerp((double)partialTicks, (double)((MaidFishingHook)((Object)fishingHook)).yo, (double)fishingHook.getY()) + 0.25;
        double z2 = Mth.lerp((double)partialTicks, (double)((MaidFishingHook)((Object)fishingHook)).zo, (double)fishingHook.getZ());
        float x = (float)(x1 - x2);
        float y = (float)(y1 - y2) - 0.1875f;
        float z = (float)(z1 - z2);
        float[] colors = this.getLineColor(fishingHook);
        VertexConsumer lineConsumer = buffer.getBuffer(RenderType.lineStrip());
        PoseStack.Pose lasted = poseStack.last();
        for (int i = 0; i <= 16; ++i) {
            this.stringVertex(x, y, z, lineConsumer, lasted, this.fraction(i), this.fraction(i + 1), colors[0], colors[1], colors[2]);
        }
        if (OculusCompat.isOculusInstalled()) {
            lineConsumer.addVertex(0.0f, 0.0f, 0.0f).setColor(0, 0, 0, 255).setNormal(0.0f, 0.0f, 0.0f);
        }
    }

    protected float fraction(int numerator) {
        return (float)numerator / 16.0f;
    }

    protected void vertex(VertexConsumer consumer, PoseStack.Pose pose, int lightMapUV, float pX, int pY, int pU, int pV) {
        consumer.addVertex(pose, pX - 0.5f, (float)pY - 0.5f, 0.0f).setColor(255, 255, 255, 255).setUv((float)pU, (float)pV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(lightMapUV).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    protected static void renderPosTexture(VertexConsumer builder, PoseStack.Pose pose, int lightMapUV, float x, int y, int u, int v) {
        builder.addVertex(pose, x - 0.5f, (float)y - 0.5f, 0.0f).setColor(255, 255, 255, 255).setUv((float)u, (float)v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(lightMapUV).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    protected static void vertex(VertexConsumer builder, PoseStack.Pose pose, int lightMapUV, float x, int y, int u, int v, float r, float g, float b) {
        builder.addVertex(pose, x - 0.5f, (float)y - 0.5f, 0.0f).setColor(r, g, b, 1.0f).setUv((float)u, (float)v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(lightMapUV).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    protected void stringVertex(float pX, float pY, float pZ, VertexConsumer consumer, PoseStack.Pose pose, float fraction1, float fraction2, float r, float g, float b) {
        float x = pX * fraction1;
        float y = pY * (fraction1 * fraction1 + fraction1) * 0.5f + 0.25f;
        float z = pZ * fraction1;
        float nx = pX * fraction2 - x;
        float ny = pY * (fraction2 * fraction2 + fraction2) * 0.5f + 0.25f - y;
        float nz = pZ * fraction2 - z;
        float sqrt = Mth.sqrt((float)(nx * nx + ny * ny + nz * nz));
        consumer.addVertex(pose, x, y, z).setColor(r, g, b, 1.0f).setNormal(pose, nx /= sqrt, ny /= sqrt, nz /= sqrt);
    }

    public ResourceLocation getTextureLocation(T pEntity) {
        return TEXTURE_LOCATION;
    }
}

