/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.implement;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.EntityGraphics;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.IChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.GifTexture;
import com.github.tartaricacid.touhoulittlemaid.client.resource.listener.EmojiReloadListener;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public class EmojiChatBubbleRenderer
implements IChatBubbleRenderer {
    private final int width;
    private final int height;
    private final ResourceLocation bg;
    private final ResourceLocation emoji;

    public EmojiChatBubbleRenderer(ResourceLocation bg) {
        this.bg = bg;
        Optional<EmojiReloadListener.EmojiResource> randomEmojis = EmojiReloadListener.getRandomEmojis();
        if (randomEmojis.isPresent()) {
            EmojiReloadListener.EmojiResource emojiRes = randomEmojis.get();
            this.emoji = emojiRes.location();
            this.width = emojiRes.width();
            this.height = emojiRes.height();
            if (emojiRes.isGif()) {
                this.registerGifImage();
            }
        } else {
            this.emoji = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/chat_bubble/maid_emoji/emoji_0.png");
            this.width = 24;
            this.height = 24;
        }
    }

    private void registerGifImage() {
        TextureManager manager = Minecraft.getInstance().getTextureManager();
        if (manager.byPath.containsKey(this.emoji)) {
            return;
        }
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> manager.register(this.emoji, (AbstractTexture)new GifTexture(this.emoji)));
        } else {
            manager.register(this.emoji, (AbstractTexture)new GifTexture(this.emoji));
        }
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void render(EntityMaidRenderer renderer, EntityGraphics graphics) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.blit(this.emoji, 0, 0, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
    }

    @Override
    public ResourceLocation getBackgroundTexture() {
        return this.bg;
    }
}

