/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resource.pojo;

import com.github.tartaricacid.touhoulittlemaid.client.resource.GeckoModelLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ChairModelInfo
implements IModelInfo {
    private static final float RENDER_ENTITY_SCALE_MIN = 0.2f;
    private static final float RENDER_ENTITY_SCALE_MAX = 2.0f;
    private static final String GECKO_ANIMATION = ".json";
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="description")
    private List<String> description;
    @SerializedName(value="model")
    private ResourceLocation model;
    @SerializedName(value="texture")
    private ResourceLocation texture;
    @SerializedName(value="extra_textures")
    private List<ResourceLocation> extraTextures;
    @SerializedName(value="model_id")
    private ResourceLocation modelId;
    @SerializedName(value="render_item_scale")
    private float renderItemScale = 1.0f;
    @SerializedName(value="render_entity_scale")
    private float renderEntityScale = 1.0f;
    @SerializedName(value="animation")
    private List<ResourceLocation> animation;
    @SerializedName(value="mounted_height")
    private float mountedYOffset;
    @SerializedName(value="tameable_can_ride")
    private boolean tameableCanRide = true;
    @SerializedName(value="no_gravity")
    private boolean noGravity = false;
    @SerializedName(value="is_gecko")
    private boolean isGeckoModel = false;
    @Expose(deserialize=false, serialize=false)
    private ResourceLocation cacheIconId = null;

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public List<ResourceLocation> getExtraTextures() {
        return this.extraTextures;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public List<ResourceLocation> getAnimation() {
        return this.animation;
    }

    @Override
    public ResourceLocation getModelId() {
        return this.modelId;
    }

    @Override
    public ResourceLocation getModel() {
        return this.model;
    }

    @Override
    public boolean isGeckoModel() {
        return this.isGeckoModel;
    }

    public float getMountedYOffset() {
        return this.mountedYOffset;
    }

    public boolean isTameableCanRide() {
        return this.tameableCanRide;
    }

    @Override
    public float getRenderItemScale() {
        return this.renderItemScale;
    }

    public float getRenderEntityScale() {
        return this.renderEntityScale;
    }

    public boolean isNoGravity() {
        return this.noGravity;
    }

    @Override
    public ResourceLocation getCacheIconId() {
        return this.cacheIconId;
    }

    public ChairModelInfo extra(ResourceLocation newModelId, ResourceLocation texture) {
        ChairModelInfo cloneInfo = new ChairModelInfo();
        cloneInfo.modelId = newModelId;
        cloneInfo.texture = texture;
        cloneInfo.cacheIconId = IModelInfo.createCacheIconId(newModelId);
        cloneInfo.name = this.name;
        cloneInfo.description = this.description;
        cloneInfo.model = this.model;
        cloneInfo.renderItemScale = this.renderItemScale;
        cloneInfo.renderEntityScale = this.renderEntityScale;
        cloneInfo.animation = this.animation;
        cloneInfo.mountedYOffset = this.mountedYOffset;
        cloneInfo.tameableCanRide = this.tameableCanRide;
        cloneInfo.noGravity = this.noGravity;
        cloneInfo.isGeckoModel = this.isGeckoModel;
        return cloneInfo;
    }

    public ChairModelInfo decorate() {
        if (this.description == null) {
            this.description = Collections.EMPTY_LIST;
        }
        if (this.modelId == null) {
            throw new JsonSyntaxException("Expected \"model_id\" in model");
        }
        this.cacheIconId = IModelInfo.createCacheIconId(this.modelId);
        if (this.model == null) {
            this.model = ResourceLocation.fromNamespaceAndPath((String)this.modelId.getNamespace(), (String)("models/entity/" + this.modelId.getPath() + GECKO_ANIMATION));
        }
        if (this.texture == null) {
            this.texture = ResourceLocation.fromNamespaceAndPath((String)this.modelId.getNamespace(), (String)("textures/entity/" + this.modelId.getPath() + ".png"));
        }
        if (this.name == null) {
            this.name = String.format("{model.%s.%s.name}", this.modelId.getNamespace(), this.modelId.getPath());
        }
        if (this.isGeckoModel) {
            this.animation = this.animation == null || this.animation.isEmpty() ? Collections.singletonList(GeckoModelLoader.DEFAULT_CHAIR_ANIMATION) : this.animation.stream().filter(res -> res.getPath().endsWith(GECKO_ANIMATION)).collect(Collectors.toList());
        }
        this.renderEntityScale = Mth.clamp((float)this.renderEntityScale, (float)0.2f, (float)2.0f);
        this.mountedYOffset = (this.mountedYOffset - 3.0f) * 0.0625f;
        return this;
    }
}

