/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.sound.record;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import net.minecraft.network.chat.Component;
import net.minecraft.util.VisibleForDebug;
import org.apache.commons.io.FileUtils;

public class MicrophoneManager {
    private static final AudioFormat DEFAULT_FORMAT = new AudioFormat(16000.0f, 16, 1, true, false);
    private static final int MAX_RECORD_TIME_SECONDS = 20;
    private static final ScheduledExecutorService SERVICE = Executors.newSingleThreadScheduledExecutor();
    private static final AtomicBoolean IS_RECORDING = new AtomicBoolean();
    private static CompletableFuture<?> TASK = null;

    @Nullable
    public static Mixer.Info getMicrophoneInfo(AudioFormat audioFormat) {
        List<Mixer.Info> allMicrophoneInfo = MicrophoneManager.getAllMicrophoneInfo(audioFormat);
        if (allMicrophoneInfo.isEmpty()) {
            return null;
        }
        String name = (String)AIConfig.STT_MICROPHONE.get();
        if (name.isBlank()) {
            return allMicrophoneInfo.get(0);
        }
        for (Mixer.Info info : allMicrophoneInfo) {
            if (!info.getName().equals(name)) continue;
            return info;
        }
        return allMicrophoneInfo.get(0);
    }

    public static String[] getAllMicrophoneName() {
        Mixer.Info[] allInfos = AudioSystem.getMixerInfo();
        ArrayList names = Lists.newArrayList();
        for (Mixer.Info info : allInfos) {
            DataLine.Info lineInfo;
            Mixer mixer = AudioSystem.getMixer(info);
            if (!mixer.isLineSupported(lineInfo = new DataLine.Info(TargetDataLine.class, DEFAULT_FORMAT))) continue;
            names.add(info.getName());
        }
        String[] result = names.toArray(new String[0]);
        if (result.length == 0) {
            return new String[]{Component.translatable((String)"mco.configure.world.slot.empty").getString()};
        }
        return result;
    }

    private static List<Mixer.Info> getAllMicrophoneInfo(AudioFormat format) {
        Mixer.Info[] allInfos;
        ArrayList output = Lists.newArrayList();
        for (Mixer.Info info : allInfos = AudioSystem.getMixerInfo()) {
            DataLine.Info lineInfo;
            Mixer mixer = AudioSystem.getMixer(info);
            if (!mixer.isLineSupported(lineInfo = new DataLine.Info(TargetDataLine.class, format))) continue;
            output.add(info);
        }
        return output;
    }

    @Nullable
    private static TargetDataLine getMicrophone(String deviceName, AudioFormat format) throws LineUnavailableException {
        Mixer.Info[] allInfos;
        for (Mixer.Info info : allInfos = AudioSystem.getMixerInfo()) {
            DataLine.Info lineInfo;
            Mixer mixer = AudioSystem.getMixer(info);
            if (!mixer.isLineSupported(lineInfo = new DataLine.Info(TargetDataLine.class, format)) || !info.getName().equals(deviceName)) continue;
            return (TargetDataLine)mixer.getLine(lineInfo);
        }
        return null;
    }

    public static void startRecord(String deviceName, AudioFormat format, Consumer<byte[]> consumer) {
        if (TASK != null && !TASK.isDone()) {
            IS_RECORDING.set(false);
        }
        TASK = CompletableFuture.supplyAsync(() -> {
            MicrophoneManager.doRecord(deviceName, format, consumer);
            return null;
        }, SERVICE).orTimeout(20L, TimeUnit.SECONDS).exceptionally(throwable -> {
            IS_RECORDING.set(false);
            return null;
        });
    }

    public static void stopRecord() {
        IS_RECORDING.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRecord(String deviceName, AudioFormat format, Consumer<byte[]> consumer) {
        try (TargetDataLine dataLine = MicrophoneManager.getMicrophone(deviceName, format);){
            if (dataLine == null) {
                TouhouLittleMaid.LOGGER.error("Microphone Device is not found: {}", (Object)deviceName);
                return;
            }
            TouhouLittleMaid.LOGGER.debug("Microphone start record...");
            IS_RECORDING.set(true);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            dataLine.open(format);
            dataLine.start();
            while (IS_RECORDING.get()) {
                int bytesRead = dataLine.read(buffer, 0, buffer.length);
                if (bytesRead <= 0) continue;
                stream.write(buffer, 0, bytesRead);
            }
            dataLine.stop();
            dataLine.flush();
            byte[] byteArray = MicrophoneManager.pcmToWav(stream.toByteArray(), format);
            consumer.accept(byteArray);
            TouhouLittleMaid.LOGGER.debug("Microphone stop record...");
        }
        catch (LineUnavailableException e) {
            TouhouLittleMaid.LOGGER.error("Microphone is not found: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            TouhouLittleMaid.LOGGER.error("Microphone record error: {}", (Object)e.getMessage());
        }
        finally {
            IS_RECORDING.set(false);
        }
    }

    private static byte[] pcmToWav(byte[] pcmData, AudioFormat format) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int length = pcmData.length / format.getFrameSize();
        try (ByteArrayInputStream input = new ByteArrayInputStream(pcmData);
             AudioInputStream audio = new AudioInputStream(input, format, length);){
            AudioSystem.write(audio, AudioFileFormat.Type.WAVE, output);
        }
        return output.toByteArray();
    }

    @VisibleForDebug
    private static void debugFile(byte[] byteArray) {
        try {
            FileUtils.writeByteArrayToFile((File)new File("test.wav"), (byte[])byteArray);
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Failed to write test.wav file: {}", (Object)e.getMessage());
        }
    }
}

