/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.tooltip;

import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Position;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.GomokuCodec;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.BoardStateTooltip;
import com.github.tartaricacid.touhoulittlemaid.util.CChessUtil;
import com.github.tartaricacid.touhoulittlemaid.util.WChessUtil;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ClientBoardStateTooltip
implements ClientTooltipComponent {
    private static final ResourceLocation GOMOKU_BG = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/gomoku.png");
    private static final ResourceLocation XIANGQI_BG = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/xiangqi.png");
    private static final ResourceLocation CHESS_BG = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/chess.png");
    private static final BiFunction<String, String, Object> CACHE = Util.memoize(ClientBoardStateTooltip::getBoardGameData);
    private final String type;
    private final Object boardGameData;

    public ClientBoardStateTooltip(BoardStateTooltip tooltip) {
        this.boardGameData = CACHE.apply(tooltip.type(), tooltip.stateData());
        this.type = tooltip.type();
    }

    @Nullable
    private static Cloneable getBoardGameData(String type, String stateData) {
        switch (type) {
            case "gomoku": {
                return GomokuCodec.decode(stateData).board();
            }
            case "xiangqi": {
                com.github.tartaricacid.touhoulittlemaid.api.game.xqwlight.Position position = new com.github.tartaricacid.touhoulittlemaid.api.game.xqwlight.Position();
                position.fromFen(stateData);
                return position.squares;
            }
            case "chess": {
                Position position = new Position();
                position.fromFen(stateData);
                return position.squares;
            }
        }
        return null;
    }

    public int getHeight() {
        if (this.boardGameData == null) {
            return 0;
        }
        return switch (this.type) {
            case "gomoku" -> 80;
            case "xiangqi" -> 132;
            case "chess" -> 108;
            default -> 0;
        };
    }

    public int getWidth(Font font) {
        if (this.boardGameData == null) {
            return 0;
        }
        return switch (this.type) {
            case "gomoku" -> 76;
            case "xiangqi" -> 128;
            case "chess" -> 102;
            default -> 0;
        };
    }

    public void renderImage(Font font, int pX, int pY, GuiGraphics graphics) {
        Object object;
        if (this.boardGameData == null) {
            return;
        }
        if (this.type.equals("gomoku") && (object = this.boardGameData) instanceof byte[][]) {
            byte[][] data = (byte[][])object;
            this.renderGomoku(pX, pY, graphics, data);
            return;
        }
        if (this.type.equals("xiangqi") && (object = this.boardGameData) instanceof byte[]) {
            byte[] data = (byte[])object;
            this.renderXiangqi(pX, pY, graphics, data);
            return;
        }
        if (this.type.equals("chess") && (object = this.boardGameData) instanceof byte[]) {
            byte[] chessData = (byte[])object;
            this.renderChess(pX, pY, graphics, chessData);
        }
    }

    private void renderGomoku(int pX, int pY, GuiGraphics graphics, byte[][] data) {
        graphics.pose().pushPose();
        graphics.pose().scale(0.5f, 0.5f, 1.0f);
        graphics.pose().translate((float)pX, (float)pY, 0.0f);
        graphics.blit(GOMOKU_BG, pX, pY, 0, 0, 151, 151);
        for (int y = 0; y <= 14; ++y) {
            for (int x = 0; x <= 14; ++x) {
                int v;
                byte piecesIndex = data[x][y];
                if (piecesIndex == 1) {
                    v = 151;
                } else {
                    if (piecesIndex != 2) continue;
                    v = 160;
                }
                int offsetX = pX + 1 + x * 10;
                int offsetY = pY + 1 + y * 10;
                graphics.blit(GOMOKU_BG, offsetX, offsetY, 0, v, 9, 9);
            }
        }
        graphics.pose().popPose();
    }

    private void renderXiangqi(int pX, int pY, GuiGraphics graphics, byte[] data) {
        graphics.blit(XIANGQI_BG, pX, pY, 0, 0, 128, 126);
        for (int y = 3; y <= 12; ++y) {
            for (int x = 3; x <= 11; ++x) {
                int u;
                int v;
                byte piecesIndex = CChessUtil.piecesIndex(x, y, data);
                if (CChessUtil.isRed(piecesIndex)) {
                    v = 126;
                    u = (piecesIndex - 8) * 11;
                } else {
                    if (!CChessUtil.isBlack(piecesIndex)) continue;
                    v = 137;
                    u = (piecesIndex - 16) * 11;
                }
                int offsetX = pX - 1 + (x - 3) * 13;
                int offsetY = pY - 1 + (y - 3) * 13;
                graphics.blit(XIANGQI_BG, offsetX, offsetY, u, v, 11, 11);
            }
        }
    }

    private void renderChess(int pX, int pY, GuiGraphics graphics, byte[] data) {
        graphics.pose().pushPose();
        graphics.pose().scale(0.5f, 0.5f, 1.0f);
        graphics.pose().translate((float)pX, (float)pY, 0.0f);
        graphics.blit(CHESS_BG, pX, pY, 0, 0, 204, 204);
        for (int y = 0; y <= 7; ++y) {
            for (int x = 4; x <= 11; ++x) {
                int u;
                int v;
                byte piecesIndex = WChessUtil.piecesIndex(x, y, data);
                if (WChessUtil.isWhite(piecesIndex)) {
                    v = 204;
                    u = (piecesIndex - 8) * 24;
                } else {
                    if (!WChessUtil.isBlack(piecesIndex)) continue;
                    v = 228;
                    u = (piecesIndex - 16) * 24;
                }
                int offsetX = pX + 6 + (x - 4) * 24;
                int offsetY = pY + 6 + y * 24;
                graphics.blit(CHESS_BG, offsetX, offsetY, u, v, 24, 24);
            }
        }
        graphics.pose().popPose();
    }
}

