/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.command.subcommand;

import com.github.tartaricacid.touhoulittlemaid.command.arguments.HandleTypeArgument;
import com.github.tartaricacid.touhoulittlemaid.data.ChatTokensAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public final class ChatTokensCommand {
    private static final String TOKENS = "tokens";
    private static final String GET_NAME = "get";
    private static final String HANDLE_NAME = "handle";
    private static final String TARGETS_NAME = "targets";
    private static final String COUNT_NAME = "count";

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder pack = Commands.literal((String)TOKENS);
        RequiredArgumentBuilder targets = Commands.argument((String)TARGETS_NAME, (ArgumentType)EntityArgument.players());
        RequiredArgumentBuilder count = Commands.argument((String)COUNT_NAME, (ArgumentType)IntegerArgumentType.integer((int)0));
        RequiredArgumentBuilder handleType = Commands.argument((String)HANDLE_NAME, (ArgumentType)HandleTypeArgument.type());
        pack.then(Commands.literal((String)GET_NAME).then(targets.executes(ChatTokensCommand::getTokens)));
        pack.then(handleType.then(targets.then(count.executes(ChatTokensCommand::handleTokens))));
        return pack;
    }

    private static int handleTokens(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)TARGETS_NAME);
        int count = IntegerArgumentType.getInteger(context, (String)COUNT_NAME);
        String type = HandleTypeArgument.getType(context, HANDLE_NAME);
        for (Player player : players) {
            switch (type) {
                case "set": {
                    ((ChatTokensAttachment)player.getData(InitDataAttachment.CHAT_TOKENS)).set(count);
                    break;
                }
                case "add": {
                    ((ChatTokensAttachment)player.getData(InitDataAttachment.CHAT_TOKENS)).add(count);
                    break;
                }
                case "min": {
                    ((ChatTokensAttachment)player.getData(InitDataAttachment.CHAT_TOKENS)).min(count);
                    break;
                }
            }
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.touhou_little_maid.chat_tokens.handle.info", (Object[])new Object[]{players.size()}), true);
        return 1;
    }

    private static int getTokens(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        for (Player player : EntityArgument.getPlayers(context, (String)TARGETS_NAME)) {
            ChatTokensAttachment tokens = (ChatTokensAttachment)player.getData(InitDataAttachment.CHAT_TOKENS);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.touhou_little_maid.chat_tokens.get.info", (Object[])new Object[]{player.getScoreboardName(), tokens.get()}), false);
        }
        return 1;
    }
}

