/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.aquaculture.client;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.MaidFishingHookRenderer;
import com.github.tartaricacid.touhoulittlemaid.compat.aquaculture.entity.AquacultureFishingHook;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AquacultureFishingHookRenderer
extends MaidFishingHookRenderer<AquacultureFishingHook> {
    private static final ResourceLocation BOBBER = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/rod/bobber/bobber.png");
    private static final ResourceLocation BOBBER_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/rod/bobber/bobber_overlay.png");
    private static final ResourceLocation BOBBER_VANILLA = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/rod/bobber/bobber_vanilla.png");
    private static final ResourceLocation HOOK = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/rod/hook/hook.png");
    private static final RenderType BOBBER_RENDER = RenderType.entityCutout((ResourceLocation)BOBBER);
    private static final RenderType BOBBER_OVERLAY_RENDER = RenderType.entityCutout((ResourceLocation)BOBBER_OVERLAY);
    private static final RenderType BOBBER_VANILLA_RENDER = RenderType.entityCutout((ResourceLocation)BOBBER_VANILLA);
    private static final RenderType HOOK_RENDER = RenderType.entityCutout((ResourceLocation)HOOK);

    public AquacultureFishingHookRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderBobber(AquacultureFishingHook fishingHook, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        PoseStack.Pose lastedPose = poseStack.last();
        VertexConsumer consumer = fishingHook.hasBobber() ? buffer.getBuffer(BOBBER_OVERLAY_RENDER) : buffer.getBuffer(BOBBER_VANILLA_RENDER);
        ItemStack bobberStack = fishingHook.getBobber();
        float bobberR = 1.0f;
        float bobberG = 1.0f;
        float bobberB = 1.0f;
        int colorInt = FastColor.ARGB32.color((int)193, (int)38, (int)38);
        if (!bobberStack.isEmpty() && bobberStack.is(ItemTags.DYEABLE)) {
            DyedItemColor dyedItemColor = (DyedItemColor)bobberStack.get(DataComponents.DYED_COLOR);
            if (dyedItemColor != null) {
                colorInt = dyedItemColor.rgb();
            }
            bobberR = (float)(colorInt >> 16 & 0xFF) / 255.0f;
            bobberG = (float)(colorInt >> 8 & 0xFF) / 255.0f;
            bobberB = (float)(colorInt & 0xFF) / 255.0f;
        }
        AquacultureFishingHookRenderer.vertex(consumer, lastedPose, packedLight, 0.0f, 0, 0, 1, bobberR, bobberG, bobberB);
        AquacultureFishingHookRenderer.vertex(consumer, lastedPose, packedLight, 1.0f, 0, 1, 1, bobberR, bobberG, bobberB);
        AquacultureFishingHookRenderer.vertex(consumer, lastedPose, packedLight, 1.0f, 1, 1, 0, bobberR, bobberG, bobberB);
        AquacultureFishingHookRenderer.vertex(consumer, lastedPose, packedLight, 0.0f, 1, 0, 0, bobberR, bobberG, bobberB);
        if (fishingHook.hasBobber()) {
            VertexConsumer bobberVertex = buffer.getBuffer(BOBBER_RENDER);
            AquacultureFishingHookRenderer.renderPosTexture(bobberVertex, lastedPose, packedLight, 0.0f, 0, 0, 1);
            AquacultureFishingHookRenderer.renderPosTexture(bobberVertex, lastedPose, packedLight, 1.0f, 0, 1, 1);
            AquacultureFishingHookRenderer.renderPosTexture(bobberVertex, lastedPose, packedLight, 1.0f, 1, 1, 0);
            AquacultureFishingHookRenderer.renderPosTexture(bobberVertex, lastedPose, packedLight, 0.0f, 1, 0, 0);
        }
        RenderType renderType = RenderType.entityCutout((ResourceLocation)fishingHook.getHook().getTexture());
        VertexConsumer hookVertex = fishingHook.hasHook() ? buffer.getBuffer(renderType) : buffer.getBuffer(HOOK_RENDER);
        AquacultureFishingHookRenderer.renderPosTexture(hookVertex, lastedPose, packedLight, 0.0f, 0, 0, 1);
        AquacultureFishingHookRenderer.renderPosTexture(hookVertex, lastedPose, packedLight, 1.0f, 0, 1, 1);
        AquacultureFishingHookRenderer.renderPosTexture(hookVertex, lastedPose, packedLight, 1.0f, 1, 1, 0);
        AquacultureFishingHookRenderer.renderPosTexture(hookVertex, lastedPose, packedLight, 0.0f, 1, 0, 0);
        poseStack.popPose();
    }

    @Override
    protected float[] getLineColor(AquacultureFishingHook fishingHook) {
        DyedItemColor dyedItemColor;
        ItemStack line = fishingHook.getFishingLine();
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (!line.isEmpty() && line.is(ItemTags.DYEABLE) && (dyedItemColor = (DyedItemColor)line.get(DataComponents.DYED_COLOR)) != null) {
            int colorInt = dyedItemColor.rgb();
            r = (float)(colorInt >> 16 & 0xFF) / 255.0f;
            g = (float)(colorInt >> 8 & 0xFF) / 255.0f;
            b = (float)(colorInt & 0xFF) / 255.0f;
        }
        return new float[]{r, g, b};
    }

    @Override
    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull AquacultureFishingHook fishHook) {
        return BOBBER_VANILLA;
    }
}

