/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.emi.transfer;

import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidMainContainer;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.inventory.Slot;

public class BackpackRecipeHandler<C extends MaidMainContainer>
implements StandardRecipeHandler<C> {
    private final EmiRecipeCategory recipeCategory;
    private final int recipeSlotStart;
    private final int recipeSlotCount;
    private final int inventorySlotStart;
    private final int inventorySlotCount;

    public BackpackRecipeHandler(EmiRecipeCategory categoryIdentifier, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
        this.recipeCategory = categoryIdentifier;
        this.recipeSlotStart = recipeSlotStart;
        this.recipeSlotCount = recipeSlotCount;
        this.inventorySlotStart = inventorySlotStart;
        this.inventorySlotCount = inventorySlotCount;
    }

    public List<Slot> getInputSources(C handler) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = this.inventorySlotStart; i < this.inventorySlotStart + this.inventorySlotCount; ++i) {
            slots.add(handler.getSlot(i));
        }
        return slots;
    }

    public List<Slot> getCraftingSlots(C handler) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = this.recipeSlotStart; i < this.recipeSlotStart + this.recipeSlotCount; ++i) {
            slots.add(handler.getSlot(i));
        }
        return slots;
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe.getCategory() == this.recipeCategory;
    }
}

